/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clustering;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;
import org.eclipse.emf.henshin.variability.mergein.clustering.RuleClusterer;

public class RandomRuleClusterer
implements RuleClusterer {
    private int clusterNumber;

    public RandomRuleClusterer(int clusterNumber) {
        this.clusterNumber = clusterNumber;
    }

    @Override
    public List<List<Rule>> clusterRules(List<CloneGroup> cloneGroups) {
        ArrayList<List<Rule>> result = new ArrayList<List<Rule>>();
        int i = 0;
        while (i < this.clusterNumber) {
            ArrayList entry = new ArrayList();
            result.add(entry);
            ++i;
        }
        for (Rule r : this.getRules(cloneGroups)) {
            int targetCluster = (int)Math.floor(Math.random() * (double)this.clusterNumber);
            ((List)result.get(targetCluster)).add(r);
        }
        return result;
    }

    public Set<Rule> getRules(List<CloneGroup> cloneGroups) {
        HashSet<Rule> result = new HashSet<Rule>();
        for (CloneGroup cg : cloneGroups) {
            result.addAll(cg.getRules());
        }
        return result;
    }

    @Override
    public List<List<Rule>> clusterRules(List<CloneGroup> cloneGroups, double clusteringThreshold, boolean includeRhs) {
        return this.clusterRules(cloneGroups);
    }
}

