/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.server.AttributeInfo;
import org.eclipse.emf.cdo.server.ClassInfo;
import org.eclipse.emf.cdo.server.PackageInfo;
import org.eclipse.emf.cdo.server.impl.AttributeInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoImpl
implements ClassInfo {
    protected int cid;
    protected String name;
    protected String parentName;
    protected String tableName;
    protected PackageInfo packageInfo;
    protected List<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
    private ClassInfo cachedParent;
    private String cachedColumnNames;

    public ClassInfoImpl(int cid, String name, String parentName, String tableName, PackageInfo packageInfo) {
        this.cid = cid;
        this.cid = cid;
        this.name = name;
        this.parentName = parentName;
        this.tableName = tableName;
        this.packageInfo = packageInfo;
    }

    @Override
    public int getCID() {
        return this.cid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    @Override
    public AttributeInfo addAttribute(String name, int featureID, int dataType, String columnName, int columnType) {
        AttributeInfoImpl attributeInfo = new AttributeInfoImpl(name, featureID, dataType, columnName, columnType);
        this.attributeInfos.add(attributeInfo);
        return attributeInfo;
    }

    @Override
    public AttributeInfo getAttributeInfo(int feature) {
        for (AttributeInfo attributeInfo : this.attributeInfos) {
            if (attributeInfo.getFeatureID() != feature) continue;
            return attributeInfo;
        }
        ClassInfo parentInfo = this.getParent();
        if (parentInfo != null) {
            return parentInfo.getAttributeInfo(feature);
        }
        return null;
    }

    @Override
    public AttributeInfo[] getAttributeInfos() {
        return this.attributeInfos.toArray(new AttributeInfo[this.attributeInfos.size()]);
    }

    @Override
    public ClassInfo getParent() {
        if (this.cachedParent == null && this.parentName != null) {
            this.cachedParent = this.packageInfo.getPackageManager().getClassInfo(this.parentName);
        }
        return this.cachedParent;
    }

    @Override
    public boolean isParentOf(ClassInfo derived) {
        if (derived == null) {
            return false;
        }
        ClassInfo parent = derived.getParent();
        return parent == this || this.isParentOf(parent);
    }

    @Override
    public List<ClassInfo> getSubClasses() {
        return this.packageInfo.getPackageManager().getSubClassInfos(this);
    }

    @Override
    public String getColumnNames() {
        if (this.cachedColumnNames == null) {
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (AttributeInfo attributeInfo : this.attributeInfos) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(attributeInfo.getColumnName());
            }
            this.cachedColumnNames = buffer.toString();
        }
        return this.cachedColumnNames;
    }
}

