/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.IModificationValidator;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.gmf.runtime.common.ui.resources.FileModificationValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UIModificationValidator
implements IModificationValidator {
    private WindowListener listener;
    private static final Status ERROR_STATUS = new Status(4, "org.eclipse.core.runtime", 1, "", null);

    public UIModificationValidator() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Shell shell = window == null ? null : window.getShell();
                UIModificationValidator.this.listener = new WindowListener(shell);
                PlatformUI.getWorkbench().addWindowListener((IWindowListener)UIModificationValidator.this.listener);
            }
        });
    }

    public IStatus validateEdit(IFile[] files) {
        Shell shell = this.listener == null ? null : this.listener.getShell();
        boolean ok = FileModificationValidator.getInstance().okToEdit(files, CommonUIMessages.UIModificationValidator_ModificationMessage, shell);
        return ok ? Status.OK_STATUS : ERROR_STATUS;
    }

    public void dispose() {
        if (this.listener != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    PlatformUI.getWorkbench().removeWindowListener((IWindowListener)UIModificationValidator.this.listener);
                }
            });
        }
    }

    private class WindowListener
    implements IWindowListener {
        protected Shell shell;

        public void windowActivated(IWorkbenchWindow window) {
            this.shell = window.getShell();
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public WindowListener(Shell theShell) {
            this.shell = theShell;
        }

        public Shell getShell() {
            return this.shell;
        }
    }
}

