/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.Identity;

public class EPath {
    public static final String SEGMENT_DELIMITER = "::";
    public static final EPath ECORE = new EPath(new NamedElementAdapter(){

        public String getName(EObject adaptee) {
            if (adaptee instanceof ENamedElement) {
                ENamedElement adapted = (ENamedElement)adaptee;
                return adapted.getName();
            }
            return null;
        }
    });
    public static final EPath GMFGRAPH = new EPath(new NamedElementAdapter(){

        public String getName(EObject adaptee) {
            if (adaptee instanceof Identity) {
                Identity adapted = (Identity)adaptee;
                return adapted.getName();
            }
            return null;
        }
    });
    private NamedElementAdapter nameAdapter;

    public EPath(NamedElementAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Null named element adapter");
        }
        this.nameAdapter = adapter;
    }

    public EObject lookup(EObject initialContext, String elementPath) {
        String[] segments = elementPath.split(SEGMENT_DELIMITER);
        return this.lookup(initialContext, segments);
    }

    public EObject lookup(EObject initialContext, String[] elementPath) {
        EObject nextContext = initialContext;
        int i = 0;
        while (i < elementPath.length) {
            nextContext = this.lookupImmediate(nextContext, elementPath[i]);
            ++i;
        }
        return nextContext;
    }

    private EObject lookupImmediate(EObject initialContext, String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Non-null name required");
        }
        if (elementName.indexOf(SEGMENT_DELIMITER) >= 0) {
            throw new IllegalArgumentException("Simple name required");
        }
        Iterator it = initialContext.eContents().iterator();
        while (it.hasNext()) {
            EObject nextObj = (EObject)it.next();
            String name = this.nameAdapter.getName(nextObj);
            if (!elementName.equals(name)) continue;
            return nextObj;
        }
        Assert.fail((String)("Element " + elementName + " not found in " + initialContext));
        return null;
    }

    public static Object getStructuralFeatureVal(EObject instance, String featureName) {
        EStructuralFeature resultObj = EPath.findLocalFeature(instance.eClass(), featureName);
        if (!(resultObj instanceof EStructuralFeature)) {
            throw new IllegalArgumentException("Not existing feature: " + featureName);
        }
        EStructuralFeature feature = resultObj;
        return instance.eGet(feature);
    }

    public static EStructuralFeature findLocalFeature(EClass eClass, String name) {
        Iterator it = eClass.getEStructuralFeatures().iterator();
        while (it.hasNext()) {
            EStructuralFeature nextFeature = (EStructuralFeature)it.next();
            if (!name.equals(nextFeature.getName())) continue;
            return nextFeature;
        }
        return null;
    }

    public static EStructuralFeature findFeature(EClass eClass, String name) {
        EStructuralFeature foundFeature = EPath.findLocalFeature(eClass, name);
        if (foundFeature == null) {
            Iterator it = eClass.getESuperTypes().iterator();
            while (it.hasNext()) {
                EClass nextSuperClass = (EClass)it.next();
                foundFeature = EPath.findFeature(nextSuperClass, name);
                if (foundFeature != null) break;
            }
        }
        return foundFeature;
    }

    public static EStructuralFeature findFeature(EObject initialContext, String qualifiedName) {
        int pos = qualifiedName.lastIndexOf(SEGMENT_DELIMITER);
        if (pos <= 0 || pos == qualifiedName.length() - 1) {
            return null;
        }
        String eClassPath = qualifiedName.substring(0, pos);
        EObject eClassObj = ECORE.lookup(initialContext, eClassPath);
        if (eClassObj instanceof EClass) {
            return EPath.findFeature((EClass)eClassObj, qualifiedName.substring(pos + SEGMENT_DELIMITER.length()));
        }
        return null;
    }

    static interface NamedElementAdapter {
        public String getName(EObject var1);
    }
}

