/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.IOException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.AbortPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.AbstractTranscoder;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.AngleArc;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Arc;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.BeginPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.BitBlt;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.CloseFigure;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.CreateBrushIndirect;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.CreateFontIndirect;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.CreatePatternBrush;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.CreatePen;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeleteObject;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.EMFRecord;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.EOF;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Ellipse;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.EndPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.ExtCreatePen;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.ExtTextOut;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.FillPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.FlattenPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Header;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderableObject;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.LineTo;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.ModifyWorldTransform;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.MoveTo;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.PolyBezier;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.PolyDraw;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.PolyPolyLine;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.PolyPolygon;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Polygon;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Polyline;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.PolylineTo;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.RestoreDC;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.RoundRect;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SaveDC;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SelectObject;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetArcDirection;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetBkColor;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetBkMode;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetMiterLimit;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetPolyFillMode;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetROP2;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetStretchBltMode;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetTextAlign;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetTextColor;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetViewportExtent;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetViewportOrg;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetWindowExtent;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.SetWindowOrg;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.StretchBlt;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.StretchDIBits;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.StrokeAndFillPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.StrokePath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.TranscoderException;

public class EMFTranscoder
extends AbstractTranscoder {
    private static final int EMR_HEADER = 1;
    private static final int EMR_POLYBEZIER = 2;
    private static final int EMR_POLYGON = 3;
    private static final int EMR_POLYLINE = 4;
    private static final int EMR_POLYBEZIERTO = 5;
    private static final int EMR_POLYLINETO = 6;
    private static final int EMR_POLYPOLYLINE = 7;
    private static final int EMR_POLYPOLYGON = 8;
    private static final int EMR_SETWINDOWEXTEX = 9;
    private static final int EMR_SETWINDOWORGEX = 10;
    private static final int EMR_SETVIEWPORTEXTEX = 11;
    private static final int EMR_SETVIEWPORTORGEX = 12;
    private static final int EMR_SETBRUSHORGEX = 13;
    private static final int EMR_EOF = 14;
    private static final int EMR_SETPIXELV = 15;
    private static final int EMR_SETMAPPERFLAGS = 16;
    private static final int EMR_SETMAPMODE = 17;
    private static final int EMR_SETBKMODE = 18;
    private static final int EMR_SETPOLYFILLMODE = 19;
    private static final int EMR_SETROP2 = 20;
    private static final int EMR_SETSTRETCHBLTMODE = 21;
    private static final int EMR_SETTEXTALIGN = 22;
    private static final int EMR_SETCOLORADJUSTMENT = 23;
    private static final int EMR_SETTEXTCOLOR = 24;
    private static final int EMR_SETBKCOLOR = 25;
    private static final int EMR_OFFSETCLIPRGN = 26;
    private static final int EMR_MOVETOEX = 27;
    private static final int EMR_SETMETARGN = 28;
    private static final int EMR_EXCLUDECLIPRECT = 29;
    private static final int EMR_INTERSECTCLIPRECT = 30;
    private static final int EMR_SCALEVIEWPORTEXTEX = 31;
    private static final int EMR_SCALEWINDOWEXTEX = 32;
    private static final int EMR_SAVEDC = 33;
    private static final int EMR_RESTOREDC = 34;
    private static final int EMR_SETWORLDTRANSFORM = 35;
    private static final int EMR_MODIFYWORLDTRANSFORM = 36;
    private static final int EMR_SELECTOBJECT = 37;
    private static final int EMR_CREATEPEN = 38;
    private static final int EMR_CREATEBRUSHINDIRECT = 39;
    private static final int EMR_DELETEOBJECT = 40;
    private static final int EMR_ANGLEARC = 41;
    private static final int EMR_ELLIPSE = 42;
    private static final int EMR_RECTANGLE = 43;
    private static final int EMR_ROUNDRECT = 44;
    private static final int EMR_ARC = 45;
    private static final int EMR_CHORD = 46;
    private static final int EMR_PIE = 47;
    private static final int EMR_SELECTPALETTE = 48;
    private static final int EMR_CREATEPALETTE = 49;
    private static final int EMR_SETPALETTEENTRIES = 50;
    private static final int EMR_RESIZEPALETTE = 51;
    private static final int EMR_REALIZEPALETTE = 52;
    private static final int EMR_EXTFLOODFILL = 53;
    private static final int EMR_LINETO = 54;
    private static final int EMR_ARCTO = 55;
    private static final int EMR_POLYDRAW = 56;
    private static final int EMR_SETARCDIRECTION = 57;
    private static final int EMR_SETMITERLIMIT = 58;
    private static final int EMR_BEGINPATH = 59;
    private static final int EMR_ENDPATH = 60;
    private static final int EMR_CLOSEFIGURE = 61;
    private static final int EMR_FILLPATH = 62;
    private static final int EMR_STROKEANDFILLPATH = 63;
    private static final int EMR_STROKEPATH = 64;
    private static final int EMR_FLATTENPATH = 65;
    private static final int EMR_WIDENPATH = 66;
    private static final int EMR_SELECTCLIPPATH = 67;
    private static final int EMR_ABORTPATH = 68;
    private static final int EMR_GDICOMMENT = 70;
    private static final int EMR_FILLRGN = 71;
    private static final int EMR_FRAMERGN = 72;
    private static final int EMR_INVERTRGN = 73;
    private static final int EMR_PAINTRGN = 74;
    private static final int EMR_EXTSELECTCLIPRGN = 75;
    private static final int EMR_BITBLT = 76;
    private static final int EMR_STRETCHBLT = 77;
    private static final int EMR_MASKBLT = 78;
    private static final int EMR_PLGBLT = 79;
    private static final int EMR_SETDIBITSTODEVICE = 80;
    private static final int EMR_STRETCHDIBITS = 81;
    private static final int EMR_EXTCREATEFONTINDIRECTW = 82;
    private static final int EMR_EXTTEXTOUTA = 83;
    private static final int EMR_EXTTEXTOUTW = 84;
    private static final int EMR_POLYBEZIER16 = 85;
    private static final int EMR_POLYGON16 = 86;
    private static final int EMR_POLYLINE16 = 87;
    private static final int EMR_POLYBEZIERTO16 = 88;
    private static final int EMR_POLYLINETO16 = 89;
    private static final int EMR_POLYPOLYLINE16 = 90;
    private static final int EMR_POLYPOLYGON16 = 91;
    private static final int EMR_POLYDRAW16 = 92;
    private static final int EMR_CREATEMONOBRUSH = 93;
    private static final int EMR_CREATEDIBPATTERNBRUSHPT = 94;
    private static final int EMR_EXTCREATEPEN = 95;
    private static final int EMR_POLYTEXTOUTA = 96;
    private static final int EMR_POLYTEXTOUTW = 97;
    private static final int EMR_SETICMMODE = 98;
    private static final int EMR_CREATECOLORSPACE = 99;
    private static final int EMR_SETCOLORSPACE = 100;
    private static final int EMR_DELETECOLORSPACE = 101;
    private static final int EMR_GLSRECORD = 102;
    private static final int EMR_GLSBOUNDEDRECORD = 103;
    private static final int EMR_PIXELFORMAT = 104;
    private static final int EMR_DRAWESCAPE = 105;
    private static final int EMR_EXTESCAPE = 106;
    private static final int EMR_STARTDOC = 107;
    private static final int EMR_SMALLTEXTOUT = 108;
    private static final int EMR_FORCEUFIMAPPING = 109;
    private static final int EMR_NAMEDESCAPE = 110;
    private static final int EMR_COLORCORRECTPALETTE = 111;
    private static final int EMR_SETICMPROFILEA = 112;
    private static final int EMR_SETICMPROFILEW = 113;
    private static final int EMR_ALPHABLEND = 114;
    private static final int EMR_ALPHADIBBLEND = 115;
    private static final int EMR_TRANSPARENTBLT = 116;
    private static final int EMR_TRANSPARENTDIB = 117;
    private static final int EMR_GRADIENTFILL = 118;
    private static final int EMR_SETLINKEDUFIS = 119;
    private static final int EMR_SETTEXTJUSTIFICATION = 120;
    private int m_numRecords = 0;

    private boolean validateHeader(BufferedInputStream stream) throws IOException {
        stream.mark(1000);
        Record rec = new Record(0, 8, stream);
        int type = (int)rec.getDWORDAt(0);
        int size = (int)rec.getDWORDAt(4);
        if (type == 1 && size < 5000) {
            stream.reset();
            return true;
        }
        return false;
    }

    protected Record getNextRecord(BufferedInputStream stream, int curRecord) throws IOException {
        EMFRecord rec = null;
        if (curRecord == 0 && !this.validateHeader(stream)) {
            throw new IOException("Invalid Enhanced Metafile Format:  Invalid header");
        }
        if (curRecord == 0 || curRecord < this.m_numRecords) {
            rec = new EMFRecord(stream);
        }
        return rec;
    }

    protected IRenderableObject getConverter(Record emr) throws TranscoderException {
        IEmf2SvgConverter svgConverter = null;
        switch (emr.getType()) {
            case 1: {
                svgConverter = new Header();
                break;
            }
            case 27: {
                svgConverter = new MoveTo();
                break;
            }
            case 54: {
                svgConverter = new LineTo();
                break;
            }
            case 86: {
                svgConverter = new Polygon(true);
                break;
            }
            case 3: {
                svgConverter = new Polygon(false);
                break;
            }
            case 2: {
                svgConverter = new PolyBezier(false, false);
                break;
            }
            case 85: {
                svgConverter = new PolyBezier(true, false);
                break;
            }
            case 5: {
                svgConverter = new PolyBezier(false, true);
                break;
            }
            case 88: {
                svgConverter = new PolyBezier(true, true);
                break;
            }
            case 4: {
                svgConverter = new Polyline(false);
                break;
            }
            case 87: {
                svgConverter = new Polyline(true);
                break;
            }
            case 6: {
                svgConverter = new PolylineTo(false);
                break;
            }
            case 89: {
                svgConverter = new PolylineTo(true);
                break;
            }
            case 7: {
                svgConverter = new PolyPolyLine(false);
                break;
            }
            case 90: {
                svgConverter = new PolyPolyLine(true);
                break;
            }
            case 8: {
                svgConverter = new PolyPolygon(false);
                break;
            }
            case 91: {
                svgConverter = new PolyPolygon(true);
                break;
            }
            case 9: {
                svgConverter = new SetWindowExtent();
                break;
            }
            case 11: {
                svgConverter = new SetViewportExtent();
                break;
            }
            case 10: {
                svgConverter = new SetWindowOrg();
                break;
            }
            case 12: {
                svgConverter = new SetViewportOrg();
                break;
            }
            case 17: {
                svgConverter = new SetMapMode();
                break;
            }
            case 24: {
                svgConverter = new SetTextColor();
                break;
            }
            case 25: {
                svgConverter = new SetBkColor();
                break;
            }
            case 39: {
                svgConverter = new CreateBrushIndirect();
                break;
            }
            case 94: {
                svgConverter = new CreatePatternBrush(true);
                break;
            }
            case 93: {
                svgConverter = new CreatePatternBrush(false);
                break;
            }
            case 38: {
                svgConverter = new CreatePen();
                break;
            }
            case 82: {
                svgConverter = new CreateFontIndirect();
                break;
            }
            case 37: {
                svgConverter = new SelectObject();
                break;
            }
            case 40: {
                svgConverter = new DeleteObject();
                break;
            }
            case 22: {
                svgConverter = new SetTextAlign();
                break;
            }
            case 83: {
                svgConverter = new ExtTextOut(false);
                break;
            }
            case 84: {
                svgConverter = new ExtTextOut(true);
                break;
            }
            case 42: {
                svgConverter = new Ellipse();
                break;
            }
            case 43: {
                svgConverter = new Rectangle();
                break;
            }
            case 44: {
                svgConverter = new RoundRect();
                break;
            }
            case 57: {
                svgConverter = new SetArcDirection();
                break;
            }
            case 45: {
                svgConverter = new Arc(1);
                break;
            }
            case 55: {
                svgConverter = new Arc(2);
                break;
            }
            case 47: {
                svgConverter = new Arc(3);
                break;
            }
            case 46: {
                svgConverter = new Arc(4);
                break;
            }
            case 41: {
                svgConverter = new AngleArc();
                break;
            }
            case 56: {
                svgConverter = new PolyDraw(false);
                break;
            }
            case 92: {
                svgConverter = new PolyDraw(true);
                break;
            }
            case 19: {
                svgConverter = new SetPolyFillMode();
                break;
            }
            case 95: {
                svgConverter = new ExtCreatePen();
                break;
            }
            case 59: {
                svgConverter = new BeginPath();
                break;
            }
            case 60: {
                svgConverter = new EndPath();
                break;
            }
            case 68: {
                svgConverter = new AbortPath();
                break;
            }
            case 62: {
                svgConverter = new FillPath();
                break;
            }
            case 64: {
                svgConverter = new StrokePath();
                break;
            }
            case 63: {
                svgConverter = new StrokeAndFillPath();
                break;
            }
            case 61: {
                svgConverter = new CloseFigure();
                break;
            }
            case 65: {
                svgConverter = new FlattenPath();
                break;
            }
            case 58: {
                svgConverter = new SetMiterLimit();
                break;
            }
            case 66: {
                break;
            }
            case 18: {
                svgConverter = new SetBkMode();
                break;
            }
            case 14: {
                svgConverter = new EOF();
                break;
            }
            case 76: {
                svgConverter = new BitBlt();
                break;
            }
            case 77: {
                svgConverter = new StretchBlt();
                break;
            }
            case 81: {
                svgConverter = new StretchDIBits();
                break;
            }
            case 21: {
                svgConverter = new SetStretchBltMode();
                break;
            }
            case 20: {
                svgConverter = new SetROP2();
                break;
            }
            case 33: {
                svgConverter = new SaveDC();
                break;
            }
            case 34: {
                svgConverter = new RestoreDC();
                break;
            }
            case 36: {
                svgConverter = new ModifyWorldTransform();
                break;
            }
        }
        if (svgConverter != null) {
            this.initializeConverter(svgConverter, emr);
        }
        return svgConverter;
    }

    private void initializeConverter(IRenderableObject svgConverter, Record rec) throws TranscoderException {
        try {
            IEmf2SvgConverter converter = (IEmf2SvgConverter)svgConverter;
            converter.readEMFRecord(rec);
            if (converter instanceof Header) {
                Header header = (Header)converter;
                this.m_numRecords = header.getNumRecords();
                this.setSize(new Dimension(header.getBounds().width, header.getBounds().height));
            }
        }
        catch (IOException e) {
            throw new TranscoderException(e, false);
        }
    }

    protected String getUserFriendlyName(int emrType) {
        String name = "";
        switch (emrType) {
            case 1: {
                name = "HEADER";
                break;
            }
            case 2: {
                name = "POLYBEZIER";
                break;
            }
            case 3: {
                name = "POLYGON";
                break;
            }
            case 4: {
                name = "POLYLINE";
                break;
            }
            case 5: {
                name = "POLYBEZIERTO";
                break;
            }
            case 6: {
                name = "POLYLINETO";
                break;
            }
            case 7: {
                name = "POLYPOLYLINE";
                break;
            }
            case 8: {
                name = "POLYPOLYGON";
                break;
            }
            case 9: {
                name = "SETWINDOWEXTEX";
                break;
            }
            case 10: {
                name = "SETWINDOWORGEX";
                break;
            }
            case 11: {
                name = "SETVIEWPORTEXTEX";
                break;
            }
            case 12: {
                name = "SETVIEWPORTORGEX";
                break;
            }
            case 13: {
                name = "SETBRUSHORGEX";
                break;
            }
            case 14: {
                name = "EOF";
                break;
            }
            case 15: {
                name = "SETPIXELV";
                break;
            }
            case 16: {
                name = "SETMAPPERFLAGS";
                break;
            }
            case 17: {
                name = "SETMAPMODE";
                break;
            }
            case 18: {
                name = "SETBKMODE";
                break;
            }
            case 19: {
                name = "SETPOLYFILLMODE";
                break;
            }
            case 20: {
                name = "SETROP2";
                break;
            }
            case 21: {
                name = "SETSTRETCHBLTMODE";
                break;
            }
            case 22: {
                name = "SETTEXTALIGN";
                break;
            }
            case 23: {
                name = "SETCOLORADJUSTMENT";
                break;
            }
            case 24: {
                name = "SETTEXTCOLOR";
                break;
            }
            case 25: {
                name = "SETBKCOLOR";
                break;
            }
            case 26: {
                name = "OFFSETCLIPRGN";
                break;
            }
            case 27: {
                name = "MOVETOEX";
                break;
            }
            case 28: {
                name = "SETMETARGN";
                break;
            }
            case 29: {
                name = "EXCLUDECLIPRECT";
                break;
            }
            case 30: {
                name = "INTERSECTCLIPRECT";
                break;
            }
            case 31: {
                name = "SCALEVIEWPORTEXTEX";
                break;
            }
            case 32: {
                name = "SCALEWINDOWEXTEX";
                break;
            }
            case 33: {
                name = "SAVEDC";
                break;
            }
            case 34: {
                name = "RESTOREDC";
                break;
            }
            case 35: {
                name = "SETWORLDTRANSFORM";
                break;
            }
            case 36: {
                name = "MODIFYWORLDTRANSFORM";
                break;
            }
            case 37: {
                name = "SELECTOBJECT";
                break;
            }
            case 38: {
                name = "CREATEPEN";
                break;
            }
            case 39: {
                name = "CREATEBRUSHINDIRECT";
                break;
            }
            case 40: {
                name = "DELETEOBJECT";
                break;
            }
            case 41: {
                name = "ANGLEARC";
                break;
            }
            case 42: {
                name = "ELLIPSE";
                break;
            }
            case 43: {
                name = "RECTANGLE";
                break;
            }
            case 44: {
                name = "ROUNDRECT";
                break;
            }
            case 45: {
                name = "ARC";
                break;
            }
            case 46: {
                name = "CHORD";
                break;
            }
            case 47: {
                name = "PIE";
                break;
            }
            case 48: {
                name = "SELECTPALETTE";
                break;
            }
            case 49: {
                name = "CREATEPALETTE";
                break;
            }
            case 50: {
                name = "SETPALETTEENTRIES";
                break;
            }
            case 51: {
                name = "RESIZEPALETTE";
                break;
            }
            case 52: {
                name = "REALIZEPALETTE";
                break;
            }
            case 53: {
                name = "EXTFLOODFILL";
                break;
            }
            case 54: {
                name = "LINETO";
                break;
            }
            case 55: {
                name = "ARCTO";
                break;
            }
            case 56: {
                name = "POLYDRAW";
                break;
            }
            case 57: {
                name = "SETARCDIRECTION";
                break;
            }
            case 58: {
                name = "SETMITERLIMIT";
                break;
            }
            case 59: {
                name = "BEGINPATH";
                break;
            }
            case 60: {
                name = "ENDPATH";
                break;
            }
            case 61: {
                name = "CLOSEFIGURE";
                break;
            }
            case 62: {
                name = "FILLPATH";
                break;
            }
            case 63: {
                name = "STROKEANDFILLPATH";
                break;
            }
            case 64: {
                name = "STROKEPATH";
                break;
            }
            case 65: {
                name = "FLATTENPATH";
                break;
            }
            case 66: {
                name = "WIDENPATH";
                break;
            }
            case 67: {
                name = "SELECTCLIPPATH";
                break;
            }
            case 68: {
                name = "ABORTPATH";
                break;
            }
            case 70: {
                name = "GDICOMMENT";
                break;
            }
            case 71: {
                name = "FILLRGN";
                break;
            }
            case 72: {
                name = "FRAMERGN";
                break;
            }
            case 73: {
                name = "INVERTRGN";
                break;
            }
            case 74: {
                name = "PAINTRGN";
                break;
            }
            case 75: {
                name = "EXTSELECTCLIPRGN";
                break;
            }
            case 76: {
                name = "BITBLT";
                break;
            }
            case 77: {
                name = "STRETCHBLT";
                break;
            }
            case 78: {
                name = "MASKBLT";
                break;
            }
            case 79: {
                name = "PLGBLT";
                break;
            }
            case 80: {
                name = "SETDIBITSTODEVICE";
                break;
            }
            case 81: {
                name = "STRETCHDIBITS";
                break;
            }
            case 82: {
                name = "EXTCREATEFONTINDIRECTW";
                break;
            }
            case 83: {
                name = "EXTTEXTOUTA";
                break;
            }
            case 84: {
                name = "EXTTEXTOUTW";
                break;
            }
            case 85: {
                name = "POLYBEZIER16";
                break;
            }
            case 86: {
                name = "POLYGON16";
                break;
            }
            case 87: {
                name = "POLYLINE16";
                break;
            }
            case 88: {
                name = "POLYBEZIERTO16";
                break;
            }
            case 89: {
                name = "POLYLINETO16";
                break;
            }
            case 90: {
                name = "POLYPOLYLINE16";
                break;
            }
            case 91: {
                name = "POLYPOLYGON16";
                break;
            }
            case 92: {
                name = "POLYDRAW16";
                break;
            }
            case 93: {
                name = "CREATEMONOBRUSH";
                break;
            }
            case 94: {
                name = "CREATEDIBPATTERNBRUSHPT";
                break;
            }
            case 95: {
                name = "EXTCREATEPEN";
                break;
            }
            case 96: {
                name = "POLYTEXTOUTA";
                break;
            }
            case 97: {
                name = "POLYTEXTOUTW";
                break;
            }
            case 98: {
                name = "SETICMMODE";
                break;
            }
            case 99: {
                name = "CREATECOLORSPACE";
                break;
            }
            case 100: {
                name = "SETCOLORSPACE";
                break;
            }
            case 101: {
                name = "DELETECOLORSPACE";
                break;
            }
            case 102: {
                name = "GLSRECORD";
                break;
            }
            case 103: {
                name = "GLSBOUNDEDRECORD";
                break;
            }
            case 104: {
                name = "PIXELFORMAT";
                break;
            }
            case 105: {
                name = "DRAWESCAPE";
                break;
            }
            case 106: {
                name = "EXTESCAPE";
                break;
            }
            case 107: {
                name = "STARTDOC";
                break;
            }
            case 108: {
                name = "SMALLTEXTOUT";
                break;
            }
            case 109: {
                name = "FORCEUFIMAPPING";
                break;
            }
            case 110: {
                name = "NAMEDESCAPE";
                break;
            }
            case 111: {
                name = "COLORCORRECTPALETTE";
                break;
            }
            case 112: {
                name = "SETICMPROFILEA";
                break;
            }
            case 113: {
                name = "SETICMPROFILEW";
                break;
            }
            case 114: {
                name = "ALPHABLEND";
                break;
            }
            case 115: {
                name = "ALPHADIBBLEND";
                break;
            }
            case 116: {
                name = "TRANSPARENTBLT";
                break;
            }
            case 117: {
                name = "TRANSPARENTDIB";
                break;
            }
            case 118: {
                name = "GRADIENTFILL";
                break;
            }
            case 119: {
                name = "SETLINKEDUFIS";
                break;
            }
            case 120: {
                name = "SETTEXTJUSTIFICATION";
                break;
            }
            default: {
                name = "<unknown>";
            }
        }
        return name;
    }
}

