/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions;

import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class CommentAction
extends Action
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    public static final String ACTION_ID = "org.eclipse.acceleo.ide.ui.editors.template.actions.comment";
    public static final String COMMAND_ID = "org.eclipse.acceleo.ide.ui.comment";

    public void run(IAction action) {
        super.run();
        AcceleoEditor editor = null;
        IDocument document = null;
        ITextSelection selection = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof AcceleoEditor) {
            editor = (AcceleoEditor)window.getActivePage().getActiveEditor();
            document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            if (editor.getSelectionProvider() != null && editor.getSelectionProvider().getSelection() instanceof ITextSelection) {
                selection = (ITextSelection)editor.getSelectionProvider().getSelection();
            }
        }
        if (editor != null && document != null && selection != null) {
            String newText;
            int b = selection.getOffset();
            int e = selection.getOffset() + selection.getLength();
            String text = document.get();
            while (b < e && Character.isWhitespace(text.charAt(b))) {
                ++b;
            }
            while (e > b && Character.isWhitespace(text.charAt(e - 1))) {
                --e;
            }
            CSTNode cstNode = editor.getContent().getCSTNode(b, e);
            if (cstNode instanceof Comment) {
                b = cstNode.getStartPosition();
                e = cstNode.getEndPosition();
                newText = ((Comment)cstNode).getBody();
            } else {
                if (b == e) {
                    while (b > 0 && text.charAt(b - 1) != '\n') {
                        --b;
                    }
                    while (e < text.length() && text.charAt(e) != '\r' && text.charAt(e) != '\n') {
                        ++e;
                    }
                }
                newText = "[comment]" + text.substring(b, e) + "[/comment]";
            }
            try {
                document.replace(b, e - b, newText);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

