/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast;

import java.util.List;
import org.eclipse.acceleo.internal.parser.ast.ASTFactory;
import org.eclipse.acceleo.internal.parser.ast.IASTProvider;
import org.eclipse.acceleo.internal.parser.ast.ocl.OCLParser;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.acceleo.parser.cst.CstPackage;
import org.eclipse.acceleo.parser.cst.FileBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.InitSection;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.ModuleElement;
import org.eclipse.acceleo.parser.cst.OpenModeKind;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateExpression;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TraceBlock;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.ASTNode;

public class CST2ASTConverter {
    protected ASTFactory factory = new ASTFactory();
    protected IASTProvider astProvider = null;
    protected boolean isCanceled = false;

    public OCLParser getOCL() {
        return this.factory.getOCL();
    }

    public void setASTProvider(IASTProvider theASTProvider) {
        this.astProvider = theASTProvider;
        this.factory.setLogHandler(this.astProvider);
    }

    protected void log(String message, int posBegin, int posEnd) {
        if (this.astProvider != null) {
            this.astProvider.log(message, posBegin, posEnd);
        }
    }

    public void createAST(org.eclipse.acceleo.parser.cst.Module rootCST, Resource resourceAST) {
        if (rootCST != null) {
            Module oModule = this.factory.getOrCreateModule(rootCST);
            resourceAST.getContents().add(0, (Object)oModule);
            this.factory.initOCL(resourceAST);
            this.transformStepCopy(rootCST);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Module iModule) {
        Module oModule = this.factory.getOrCreateModule(iModule);
        if (iModule != null && oModule != null) {
            String ioName = iModule.getName();
            oModule.setName(ioName);
            this.transformStepCopyOwnedModuleElement(iModule, oModule);
            for (org.eclipse.acceleo.parser.cst.TypedModel iNext : iModule.getInput()) {
                TypedModel oNext = this.factory.getOrCreateTypedModel(iNext);
                if (oNext != null) {
                    oModule.getInput().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.TypedModel iTypedModel) {
        TypedModel oTypedModel = this.factory.getOrCreateTypedModel(iTypedModel);
        if (iTypedModel != null && oTypedModel != null) {
            for (EPackage ioNext : iTypedModel.getTakesTypesFrom()) {
                oTypedModel.getTakesTypesFrom().add((Object)ioNext);
            }
        }
    }

    private void transformStepCopy(Template iTemplate) {
        org.eclipse.acceleo.model.mtl.Template oTemplate = this.factory.getOrCreateTemplate(iTemplate);
        if (iTemplate != null && oTemplate != null) {
            org.eclipse.acceleo.parser.cst.VisibilityKind iVisibility = iTemplate.getVisibility();
            VisibilityKind oVisibility = VisibilityKind.get((int)iVisibility.getValue());
            oTemplate.setVisibility(oVisibility);
            this.transformStepCopyPositions(iTemplate, (ASTNode)oTemplate);
            String ioName = iTemplate.getName();
            oTemplate.setName(ioName);
            InitSection iInit = iTemplate.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oTemplate.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iGuard = iTemplate.getGuard();
            this.transformStepCopy(iGuard);
            this.transformStepCopyBody(iTemplate, (org.eclipse.acceleo.model.mtl.Block)oTemplate);
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iTemplate.getParameter()) {
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oNext != null) {
                    oTemplate.getParameter().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            boolean isMain = false;
            TreeIterator iChildren = iTemplate.eAllContents();
            while (!isMain && iChildren.hasNext()) {
                EObject iChild = (EObject)iChildren.next();
                if (!(iChild instanceof Comment) || ((Comment)iChild).getBody() == null || ((Comment)iChild).getBody().indexOf("@main") <= -1) continue;
                isMain = true;
            }
            oTemplate.setMain(isMain);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Variable iVariable) {
        Variable oVariable = this.factory.getOrCreateVariable(iVariable);
        if (iVariable != null && oVariable != null) {
            this.transformStepCopyPositions(iVariable, (ASTNode)oVariable);
            String ioName = iVariable.getName();
            oVariable.setName(ioName);
            String ioType = iVariable.getType();
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("MTL");
            eAnnotation.getDetails().put((Object)"type", (Object)ioType);
            oVariable.getEAnnotations().add((Object)eAnnotation);
        }
    }

    private void transformStepCopy(ModelExpression iModelExpression) {
    }

    private void transformStepCopy(TextExpression iTextExpression) {
        StringLiteralExp oTextExpression = this.factory.getOrCreateStringLiteralExp(iTextExpression);
        if (iTextExpression != null && oTextExpression != null) {
            this.transformStepCopyPositions(iTextExpression, (ASTNode)oTextExpression);
            this.transformFormattedText(iTextExpression, oTextExpression);
        }
    }

    private boolean isSingleLineBlock(Block block) {
        return this.astProvider.getLineOfOffset(block.getStartPosition()) == this.astProvider.getLineOfOffset(block.getEndPosition() - 1);
    }

    private void transformFormattedText(TextExpression iTextExpression, StringLiteralExp oTextExpression) {
        List eBody;
        String ioValue = iTextExpression.getValue();
        if (ioValue != null && iTextExpression.eContainingFeature() == CstPackage.eINSTANCE.getBlock_Body() && iTextExpression.eContainer() != null && (eBody = (List)iTextExpression.eContainer().eGet((EStructuralFeature)CstPackage.eINSTANCE.getBlock_Body())) != null && eBody.size() > 0) {
            int index = eBody.indexOf(iTextExpression);
            int shiftBegin = index == 0 && iTextExpression.eContainer() instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock ? 0 : (index == 0 || eBody.get(index - 1) instanceof Block && !(eBody.get(index - 1) instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) && !this.isSingleLineBlock((Block)eBody.get(index - 1)) ? this.shiftBegin(ioValue) : 0);
            if (shiftBegin > ioValue.length()) {
                oTextExpression.setStartPosition(oTextExpression.getStartPosition() + ioValue.length());
                ioValue = "";
            } else if (shiftBegin > 0) {
                oTextExpression.setStartPosition(oTextExpression.getStartPosition() + shiftBegin);
                ioValue = ioValue.substring(shiftBegin);
            }
            int shiftEnd = index == eBody.size() - 1 && iTextExpression.eContainer() instanceof Template ? this.shiftEnd(ioValue, false) : (index == eBody.size() - 1 ? this.shiftEnd(ioValue, true) : (index + 1 < eBody.size() && eBody.get(index + 1) instanceof Block ? this.shiftEnd(ioValue, true) : 0));
            if (shiftEnd > ioValue.length()) {
                oTextExpression.setEndPosition(oTextExpression.getEndPosition() - ioValue.length());
                ioValue = "";
            } else if (shiftEnd > 0) {
                oTextExpression.setEndPosition(oTextExpression.getEndPosition() - shiftEnd);
                ioValue = ioValue.substring(0, ioValue.length() - shiftEnd);
            }
        }
        oTextExpression.setStringSymbol(ioValue);
    }

    private int shiftBegin(String ioValue) {
        int shiftBegin = -1;
        int b = 0;
        while (shiftBegin == -1 && b < ioValue.length()) {
            char c = ioValue.charAt(b);
            if (c == '\n') {
                shiftBegin = b + 1;
            } else if (!Character.isWhitespace(c)) {
                shiftBegin = 0;
            }
            ++b;
        }
        if (shiftBegin == -1) {
            shiftBegin = ioValue.length();
        }
        return shiftBegin;
    }

    private int shiftEnd(String ioValue, boolean keepPreviousReturn) {
        int shiftEnd = -1;
        int e = ioValue.length() - 1;
        while (shiftEnd == -1 && e >= 0) {
            char c = ioValue.charAt(e);
            if (c == '\n') {
                shiftEnd = keepPreviousReturn ? ioValue.length() - (e + 1) : (e > 0 && ioValue.charAt(e - 1) == '\r' ? ioValue.length() - (e - 1) : ioValue.length() - e);
            } else if (!Character.isWhitespace(c)) {
                shiftEnd = 0;
            }
            --e;
        }
        if (shiftEnd == -1) {
            shiftEnd = ioValue.length();
        }
        return shiftEnd;
    }

    private void transformStepCopy(Block iBlock) {
        org.eclipse.acceleo.model.mtl.Block oBlock = this.factory.getOrCreateBlock(iBlock);
        if (iBlock != null && oBlock != null) {
            this.transformStepCopyPositions(iBlock, (ASTNode)oBlock);
            InitSection iInit = iBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            this.transformStepCopyBody(iBlock, oBlock);
        }
    }

    private void transformStepCopy(InitSection iInitSection) {
        org.eclipse.acceleo.model.mtl.InitSection oInitSection = this.factory.getOrCreateInitSection(iInitSection);
        if (iInitSection != null && oInitSection != null) {
            this.transformStepCopyPositions(iInitSection, (ASTNode)oInitSection);
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iInitSection.getVariable()) {
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oNext != null) {
                    oInitSection.getVariable().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.ProtectedAreaBlock iProtectedAreaBlock) {
        ProtectedAreaBlock oProtectedAreaBlock = this.factory.getOrCreateProtectedAreaBlock(iProtectedAreaBlock);
        if (iProtectedAreaBlock != null && oProtectedAreaBlock != null) {
            this.transformStepCopyPositions(iProtectedAreaBlock, (ASTNode)oProtectedAreaBlock);
            InitSection iInit = iProtectedAreaBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oProtectedAreaBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iMarker = iProtectedAreaBlock.getMarker();
            this.transformStepCopy(iMarker);
            this.transformStepCopyBody(iProtectedAreaBlock, (org.eclipse.acceleo.model.mtl.Block)oProtectedAreaBlock);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.ForBlock iForBlock) {
        ForBlock oForBlock = this.factory.getOrCreateForBlock(iForBlock);
        if (iForBlock != null && oForBlock != null) {
            this.transformStepCopyPositions(iForBlock, (ASTNode)oForBlock);
            InitSection iInit = iForBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oForBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iIterSet = iForBlock.getIterSet();
            this.transformStepCopy(iIterSet);
            ModelExpression iBefore = iForBlock.getBefore();
            this.transformStepCopy(iBefore);
            ModelExpression iEach = iForBlock.getEach();
            this.transformStepCopy(iEach);
            ModelExpression iAfter = iForBlock.getAfter();
            this.transformStepCopy(iAfter);
            ModelExpression iGuard = iForBlock.getGuard();
            this.transformStepCopy(iGuard);
            this.transformStepCopyBody(iForBlock, (org.eclipse.acceleo.model.mtl.Block)oForBlock);
            org.eclipse.acceleo.parser.cst.Variable iLoopVariable = iForBlock.getLoopVariable();
            Variable oLoopVariable = this.factory.getOrCreateVariable(iLoopVariable);
            if (oLoopVariable != null) {
                oForBlock.setLoopVariable(oLoopVariable);
            }
            this.transformStepCopy(iLoopVariable);
        }
    }

    private void transformStepCopy(IfBlock iIfBlock) {
        org.eclipse.acceleo.model.mtl.IfBlock oIfBlock = this.factory.getOrCreateIfBlock(iIfBlock);
        if (iIfBlock != null && oIfBlock != null) {
            org.eclipse.acceleo.model.mtl.Template oElse;
            Block iElse = iIfBlock.getElse();
            if (iElse instanceof Template) {
                oElse = this.factory.getOrCreateTemplate((Template)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((Template)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                oElse = this.factory.getOrCreateProtectedAreaBlock((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                oElse = this.factory.getOrCreateForBlock((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
            } else if (iElse instanceof IfBlock) {
                oElse = this.factory.getOrCreateIfBlock((IfBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((IfBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                oElse = this.factory.getOrCreateLetBlock((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
            } else if (iElse instanceof FileBlock) {
                oElse = this.factory.getOrCreateFileBlock((FileBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((FileBlock)iElse);
            } else if (iElse instanceof TraceBlock) {
                oElse = this.factory.getOrCreateTraceBlock((TraceBlock)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((TraceBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.Macro) {
                oElse = this.factory.getOrCreateMacro((org.eclipse.acceleo.parser.cst.Macro)iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.Macro)iElse);
            } else {
                oElse = this.factory.getOrCreateBlock(iElse);
                if (oElse != null) {
                    oIfBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy(iElse);
            }
            this.transformStepCopyPositions(iIfBlock, (ASTNode)oIfBlock);
            for (IfBlock iNext : iIfBlock.getElseIf()) {
                org.eclipse.acceleo.model.mtl.IfBlock oNext = this.factory.getOrCreateIfBlock(iNext);
                if (oNext != null) {
                    oIfBlock.getElseIf().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            InitSection iInit = iIfBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oIfBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iIfExpr = iIfBlock.getIfExpr();
            this.transformStepCopy(iIfExpr);
            this.transformStepCopyBody(iIfBlock, (org.eclipse.acceleo.model.mtl.Block)oIfBlock);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.LetBlock iLetBlock) {
        LetBlock oLetBlock = this.factory.getOrCreateLetBlock(iLetBlock);
        if (iLetBlock != null && oLetBlock != null) {
            org.eclipse.acceleo.model.mtl.Template oElse;
            Block iElse = iLetBlock.getElse();
            if (iElse instanceof Template) {
                oElse = this.factory.getOrCreateTemplate((Template)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((Template)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                oElse = this.factory.getOrCreateProtectedAreaBlock((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                oElse = this.factory.getOrCreateForBlock((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.ForBlock)iElse);
            } else if (iElse instanceof IfBlock) {
                oElse = this.factory.getOrCreateIfBlock((IfBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((IfBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                oElse = this.factory.getOrCreateLetBlock((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.LetBlock)iElse);
            } else if (iElse instanceof FileBlock) {
                oElse = this.factory.getOrCreateFileBlock((FileBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((FileBlock)iElse);
            } else if (iElse instanceof TraceBlock) {
                oElse = this.factory.getOrCreateTraceBlock((TraceBlock)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((TraceBlock)iElse);
            } else if (iElse instanceof org.eclipse.acceleo.parser.cst.Macro) {
                oElse = this.factory.getOrCreateMacro((org.eclipse.acceleo.parser.cst.Macro)iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.Macro)iElse);
            } else {
                oElse = this.factory.getOrCreateBlock(iElse);
                if (oElse != null) {
                    oLetBlock.setElse((org.eclipse.acceleo.model.mtl.Block)oElse);
                }
                this.transformStepCopy(iElse);
            }
            this.transformStepCopyPositions(iLetBlock, (ASTNode)oLetBlock);
            InitSection iInit = iLetBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oLetBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            for (org.eclipse.acceleo.parser.cst.LetBlock iNext : iLetBlock.getElseLet()) {
                LetBlock oNext = this.factory.getOrCreateLetBlock(iNext);
                if (oNext != null) {
                    oLetBlock.getElseLet().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            org.eclipse.acceleo.parser.cst.Variable iLetVariable = iLetBlock.getLetVariable();
            Variable oLetVariable = this.factory.getOrCreateVariable(iLetVariable);
            if (oLetVariable != null) {
                oLetBlock.setLetVariable(oLetVariable);
            }
            this.transformStepCopy(iLetVariable);
            this.transformStepCopyBody(iLetBlock, (org.eclipse.acceleo.model.mtl.Block)oLetBlock);
        }
    }

    private void transformStepCopy(FileBlock iFileBlock) {
        org.eclipse.acceleo.model.mtl.FileBlock oFileBlock = this.factory.getOrCreateFileBlock(iFileBlock);
        if (iFileBlock != null && oFileBlock != null) {
            OpenModeKind iOpenMode = iFileBlock.getOpenMode();
            org.eclipse.acceleo.model.mtl.OpenModeKind oOpenMode = org.eclipse.acceleo.model.mtl.OpenModeKind.get((int)iOpenMode.getValue());
            oFileBlock.setOpenMode(oOpenMode);
            this.transformStepCopyPositions(iFileBlock, (ASTNode)oFileBlock);
            InitSection iInit = iFileBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oFileBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iFileUrl = iFileBlock.getFileUrl();
            this.transformStepCopy(iFileUrl);
            ModelExpression iUniqId = iFileBlock.getUniqId();
            this.transformStepCopy(iUniqId);
            this.transformStepCopyBody(iFileBlock, (org.eclipse.acceleo.model.mtl.Block)oFileBlock);
        }
    }

    private void transformStepCopy(TraceBlock iTraceBlock) {
        org.eclipse.acceleo.model.mtl.TraceBlock oTraceBlock = this.factory.getOrCreateTraceBlock(iTraceBlock);
        if (iTraceBlock != null && oTraceBlock != null) {
            this.transformStepCopyPositions(iTraceBlock, (ASTNode)oTraceBlock);
            InitSection iInit = iTraceBlock.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oTraceBlock.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            ModelExpression iModelElement = iTraceBlock.getModelElement();
            this.transformStepCopy(iModelElement);
            this.transformStepCopyBody(iTraceBlock, (org.eclipse.acceleo.model.mtl.Block)oTraceBlock);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Macro iMacro) {
        Macro oMacro = this.factory.getOrCreateMacro(iMacro);
        if (iMacro != null && oMacro != null) {
            org.eclipse.acceleo.parser.cst.VisibilityKind iVisibility = iMacro.getVisibility();
            VisibilityKind oVisibility = VisibilityKind.get((int)iVisibility.getValue());
            oMacro.setVisibility(oVisibility);
            this.transformStepCopyPositions(iMacro, (ASTNode)oMacro);
            String ioName = iMacro.getName();
            oMacro.setName(ioName);
            InitSection iInit = iMacro.getInit();
            org.eclipse.acceleo.model.mtl.InitSection oInit = this.factory.getOrCreateInitSection(iInit);
            if (oInit != null) {
                oMacro.setInit(oInit);
            }
            this.transformStepCopy(iInit);
            this.transformStepCopyBody(iMacro, (org.eclipse.acceleo.model.mtl.Block)oMacro);
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iMacro.getParameter()) {
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oNext != null) {
                    oMacro.getParameter().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            String ioType = iMacro.getType();
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("MTL");
            eAnnotation.getDetails().put((Object)"type", (Object)ioType);
            oMacro.getEAnnotations().add((Object)eAnnotation);
        }
    }

    private void transformStepCopy(org.eclipse.acceleo.parser.cst.Query iQuery) {
        Query oQuery = this.factory.getOrCreateQuery(iQuery);
        if (iQuery != null && oQuery != null) {
            org.eclipse.acceleo.parser.cst.VisibilityKind iVisibility = iQuery.getVisibility();
            VisibilityKind oVisibility = VisibilityKind.get((int)iVisibility.getValue());
            oQuery.setVisibility(oVisibility);
            this.transformStepCopyPositions(iQuery, (ASTNode)oQuery);
            String ioName = iQuery.getName();
            oQuery.setName(ioName);
            ModelExpression iExpression = iQuery.getExpression();
            this.transformStepCopy(iExpression);
            for (org.eclipse.acceleo.parser.cst.Variable iNext : iQuery.getParameter()) {
                Variable oNext = this.factory.getOrCreateVariable(iNext);
                if (oNext != null) {
                    oQuery.getParameter().add((Object)oNext);
                }
                this.transformStepCopy(iNext);
            }
            String ioType = iQuery.getType();
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("MTL");
            eAnnotation.getDetails().put((Object)"type", (Object)ioType);
            oQuery.getEAnnotations().add((Object)eAnnotation);
        }
    }

    private void transformStepCopyOwnedModuleElement(org.eclipse.acceleo.parser.cst.Module iModule, Module oModule) {
        if (!this.isCanceled) {
            for (ModuleElement iNext : iModule.getOwnedModuleElement()) {
                org.eclipse.acceleo.model.mtl.Template oNext;
                if (iNext instanceof Template) {
                    oNext = this.factory.getOrCreateTemplate((Template)iNext);
                    if (oNext != null) {
                        oModule.getOwnedModuleElement().add((Object)oNext);
                    }
                    this.transformStepCopy((Template)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.Macro) {
                    oNext = this.factory.getOrCreateMacro((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    if (oNext != null) {
                        oModule.getOwnedModuleElement().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    continue;
                }
                if (!(iNext instanceof org.eclipse.acceleo.parser.cst.Query)) continue;
                oNext = this.factory.getOrCreateQuery((org.eclipse.acceleo.parser.cst.Query)iNext);
                if (oNext != null) {
                    oModule.getOwnedModuleElement().add((Object)oNext);
                }
                this.transformStepCopy((org.eclipse.acceleo.parser.cst.Query)iNext);
            }
        }
    }

    private void transformStepCopyBody(Block iBlock, org.eclipse.acceleo.model.mtl.Block oBlock) {
        if (!this.isCanceled) {
            for (TemplateExpression iNext : iBlock.getBody()) {
                org.eclipse.acceleo.model.mtl.Template oNext;
                if (iNext instanceof Template) {
                    oNext = this.factory.getOrCreateTemplate((Template)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((Template)iNext);
                    continue;
                }
                if (iNext instanceof TextExpression) {
                    oNext = this.factory.getOrCreateStringLiteralExp((TextExpression)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((TextExpression)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.ProtectedAreaBlock) {
                    oNext = this.factory.getOrCreateProtectedAreaBlock((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.ProtectedAreaBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.ForBlock) {
                    oNext = this.factory.getOrCreateForBlock((org.eclipse.acceleo.parser.cst.ForBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.ForBlock)iNext);
                    continue;
                }
                if (iNext instanceof IfBlock) {
                    oNext = this.factory.getOrCreateIfBlock((IfBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((IfBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.LetBlock) {
                    oNext = this.factory.getOrCreateLetBlock((org.eclipse.acceleo.parser.cst.LetBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.LetBlock)iNext);
                    continue;
                }
                if (iNext instanceof FileBlock) {
                    oNext = this.factory.getOrCreateFileBlock((FileBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((FileBlock)iNext);
                    continue;
                }
                if (iNext instanceof TraceBlock) {
                    oNext = this.factory.getOrCreateTraceBlock((TraceBlock)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((TraceBlock)iNext);
                    continue;
                }
                if (iNext instanceof org.eclipse.acceleo.parser.cst.Macro) {
                    oNext = this.factory.getOrCreateMacro((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((org.eclipse.acceleo.parser.cst.Macro)iNext);
                    continue;
                }
                if (iNext instanceof Block) {
                    oNext = this.factory.getOrCreateBlock((Block)iNext);
                    if (oNext != null) {
                        oBlock.getBody().add((Object)oNext);
                    }
                    this.transformStepCopy((Block)iNext);
                    continue;
                }
                if (iNext instanceof Comment || (oNext = this.factory.getOrCreateTemporaryTemplateExpression(iNext)) == null) continue;
                oBlock.getBody().add((Object)oNext);
            }
        }
    }

    private void transformStepCopyPositions(CSTNode iNode, ASTNode oNode) {
        int ioStartPosition = iNode.getStartPosition();
        oNode.setStartPosition(ioStartPosition);
        int ioEndPosition = iNode.getEndPosition();
        oNode.setEndPosition(ioEndPosition);
    }

    public void canceling(boolean cancel) {
        this.isCanceled = cancel;
    }
}

