/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability;

import java.io.File;
import java.util.List;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationContext;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.TraceabilityModel;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoTraceabilityEvaluationContext<C>
extends AcceleoEvaluationContext<C> {
    private final TraceabilityModel evaluationTrace;

    public AcceleoTraceabilityEvaluationContext(File root, List<IAcceleoTextGenerationListener> listeners, IAcceleoGenerationStrategy generationStrategy, Monitor monitor, TraceabilityModel trace) {
        super(root, listeners, generationStrategy, monitor);
        this.evaluationTrace = trace;
    }

    protected void fireFileGenerated(String filePath, Block fileBlock, EObject source) {
        GeneratedFile file = this.evaluationTrace.getGeneratedFile(filePath);
        AcceleoTextGenerationEvent event = new AcceleoTextGenerationEvent(filePath, fileBlock, source, (EObject)file);
        for (IAcceleoTextGenerationListener listener : this.listeners) {
            if (!this.notifyOnGenerationEnd) {
                EcoreUtil.remove((EObject)file);
            }
            listener.fileGenerated(event);
        }
    }
}

