/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitor;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitorDecorator;
import org.eclipse.acceleo.internal.traceability.engine.AcceleoTraceabilityOperationVisitor;
import org.eclipse.acceleo.internal.traceability.engine.ExpressionTrace;
import org.eclipse.acceleo.internal.traceability.engine.VariableTrace;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.FileBlock;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.IfBlock;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.ModelFile;
import org.eclipse.acceleo.traceability.ModuleElement;
import org.eclipse.acceleo.traceability.ModuleFile;
import org.eclipse.acceleo.traceability.TraceabilityFactory;
import org.eclipse.acceleo.traceability.TraceabilityModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.types.PrimitiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoTraceabilityVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends AcceleoEvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private OCLExpression<C> currentExpression;
    private LinkedList<GeneratedFile> currentFiles = new LinkedList();
    private final TraceabilityModel evaluationTrace;
    private org.eclipse.ocl.expressions.Variable<C, PM> initializingVariable;
    private LinkedList<ExpressionTrace<C>> invocationTraces;
    private ExpressionTrace<C> operationArgumentTrace;
    private Object operationCallSource;
    private OCLExpression<C> operationCallSourceExpression;
    private AcceleoTraceabilityOperationVisitor<C, PM> operationVisitor = new AcceleoTraceabilityOperationVisitor(this);
    private EObject propertyCallSource;
    private OCLExpression<C> propertyCallSourceExpression;
    private InputElement protectedAreaSource;
    private boolean record = true;
    private final LinkedList<ExpressionTrace<C>> recordedTraces = new LinkedList();
    private LinkedList<EObject> scopeEObjects = new LinkedList();
    private final Map<org.eclipse.ocl.expressions.Variable<C, PM>, VariableTrace<C, PM>> variableTraces = new HashMap<org.eclipse.ocl.expressions.Variable<C, PM>, VariableTrace<C, PM>>();

    public AcceleoTraceabilityVisitor(AcceleoEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratedVisitor, TraceabilityModel trace) {
        super(decoratedVisitor);
        this.evaluationTrace = trace;
    }

    public void append(String string, Block sourceBlock, EObject source, boolean fireEvent) {
        if (fireEvent && string.length() > 0 && this.currentFiles != null && this.recordedTraces != null && this.currentFiles.size() > 0 && this.recordedTraces.size() > 0) {
            GeneratedFile generatedFile = this.currentFiles.getLast();
            boolean disposeTrace = !(sourceBlock instanceof IfBlock) || !(sourceBlock instanceof ForBlock);
            ExpressionTrace<C> trace = sourceBlock instanceof IfBlock || sourceBlock instanceof ForBlock ? this.recordedTraces.getLast() : this.recordedTraces.removeLast();
            if (this.protectedAreaSource != null) {
                this.alterProtectedAreaTrace(string, sourceBlock, trace);
            }
            int fileLength = generatedFile.getLength();
            int addedLength = 0;
            if (this.invocationTraces != null && this.invocationTraces.contains(trace)) {
                this.invocationTraces.remove(trace);
                this.invocationTraces.add(new ExpressionTrace<C>(trace));
            }
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                for (GeneratedText text : new LinkedHashSet(entry.getValue())) {
                    int startingOffset = addedLength;
                    text.setStartOffset(fileLength + startingOffset);
                    text.setEndOffset(fileLength + (addedLength += text.getEndOffset() - text.getStartOffset()));
                    generatedFile.getGeneratedRegions().add((Object)text);
                    entry.getValue().remove(text);
                }
            }
            generatedFile.setLength(fileLength + addedLength);
            if (disposeTrace) {
                trace.dispose();
            }
        }
        super.append(string, sourceBlock, source, fireEvent);
    }

    public void createFileWriter(File generatedFile, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        boolean fileExisted = generatedFile.exists();
        GeneratedFile file = this.getGeneratedFile(generatedFile, appendMode);
        file.setCharset(charset);
        file.setFileBlock(this.getModuleElement((EObject)fileBlock));
        this.currentFiles.add(file);
        ExpressionTrace<C> traceContext = this.recordedTraces.removeLast();
        for (Map.Entry<InputElement, Set<GeneratedText>> entry : traceContext.getTraces().entrySet()) {
            file.getSourceElements().add((Object)entry.getKey());
            file.getNameRegions().addAll((Collection)entry.getValue());
        }
        traceContext.dispose();
        if (appendMode && fileExisted) {
            file.setLength(file.getLength() + 1);
        }
        super.createFileWriter(generatedFile, fileBlock, source, appendMode, charset);
    }

    public String fitIndentationTo(String source, String indentation) {
        if ("".equals(indentation)) {
            return source;
        }
        String regex = "\r\n|\r|\n";
        String replacement = "$0" + indentation;
        EObject scopeEObject = this.retrieveScopeEObjectValue();
        InputElement input = this.getInputElement(scopeEObject);
        if (this.protectedAreaSource != null) {
            input = this.protectedAreaSource;
        }
        GeneratedText text = this.createGeneratedTextFor((EObject)this.currentExpression);
        text.setEndOffset(indentation.length());
        ExpressionTrace<C> indentationTrace = new ExpressionTrace<C>(this.currentExpression);
        indentationTrace.addTrace(input, text, indentation);
        return this.operationVisitor.visitReplaceOperation(source, regex, replacement, indentationTrace, true, true);
    }

    public LinkedList<GeneratedFile> getCurrentFiles() {
        return this.currentFiles;
    }

    public LinkedList<ExpressionTrace<C>> getInvocationTraces() {
        return this.invocationTraces;
    }

    public ExpressionTrace<C> getLastExpressionTrace() {
        return this.recordedTraces.getLast();
    }

    public void visitAcceleoFileBlock(FileBlock fileBlock) {
        super.visitAcceleoFileBlock(fileBlock);
        this.currentFiles.removeLast();
        if (this.recordedTraces.size() > 0 && this.recordedTraces.getLast().getReferredExpression() == fileBlock && this.recordedTraces.getLast().getTraces().size() == 0) {
            this.recordedTraces.removeLast();
        }
    }

    public void visitAcceleoForBlock(ForBlock forBlock) {
        if (forBlock.getLoopVariable() != null) {
            this.scopeEObjects.add((EObject)forBlock.getLoopVariable());
        }
        super.visitAcceleoForBlock(forBlock);
        if (forBlock.getLoopVariable() != null) {
            this.scopeEObjects.removeLast();
        }
        if (this.recordedTraces.size() > 0 && this.recordedTraces.getLast().getReferredExpression() == forBlock && this.recordedTraces.getLast().getTraces().size() == 0) {
            this.recordedTraces.removeLast();
        }
    }

    public void visitAcceleoIfBlock(IfBlock ifBlock) {
        super.visitAcceleoIfBlock(ifBlock);
        if (this.recordedTraces.size() > 0 && this.recordedTraces.getLast().getReferredExpression() == ifBlock && this.recordedTraces.getLast().getTraces().size() == 0) {
            this.recordedTraces.removeLast();
        }
    }

    public void visitAcceleoProtectedArea(ProtectedAreaBlock protectedArea) {
        this.protectedAreaSource = this.getInputElement(this.retrieveScopeEObjectValue());
        super.visitAcceleoProtectedArea(protectedArea);
        this.protectedAreaSource = null;
    }

    public Object visitAcceleoQueryInvocation(QueryInvocation invocation) {
        this.scopeEObjects.add((EObject)invocation.getArgument().get(0));
        Object result = super.visitAcceleoQueryInvocation(invocation);
        this.scopeEObjects.removeLast();
        if (this.isPropertyCallSource((OCLExpression<C>)invocation)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)invocation)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitAcceleoTemplateInvocation(TemplateInvocation invocation) {
        if (invocation.getArgument().size() > 0) {
            this.scopeEObjects.add((EObject)invocation.getArgument().get(0));
        }
        LinkedList<ExpressionTrace<C>> oldTraces = this.invocationTraces;
        this.invocationTraces = new LinkedList();
        Object result = super.visitAcceleoTemplateInvocation(invocation);
        for (ExpressionTrace expressionTrace : this.invocationTraces) {
            if (oldTraces != null) {
                oldTraces.add(expressionTrace);
                continue;
            }
            expressionTrace.dispose();
        }
        this.invocationTraces = oldTraces;
        if (invocation.getArgument().size() > 0) {
            this.scopeEObjects.removeLast();
        }
        if (this.isPropertyCallSource((OCLExpression<C>)invocation)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)invocation)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitAssociationClassCallExp(AssociationClassCallExp<C, P> callExp) {
        Object result = super.visitAssociationClassCallExp(callExp);
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp<C, EL> literalExp) {
        Object result = super.visitEnumLiteralExp(literalExp);
        if (this.isPropertyCallSource((OCLExpression<C>)literalExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)literalExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitExpression(OCLExpression<C> expression) {
        OCLExpression<C> oldExpression = this.currentExpression;
        this.currentExpression = expression;
        if (this.scopeEObjects.size() == 0 && expression instanceof Template) {
            for (Variable var : ((Template)expression).getParameter()) {
                Object value = this.getEvaluationEnvironment().getValueOf(var.getName());
                if (!(value instanceof EObject)) continue;
                this.scopeEObjects.add((EObject)value);
                break;
            }
        }
        boolean oldRecordingValue = this.record;
        if (expression.eContainingFeature() == MtlPackage.eINSTANCE.getIfBlock_IfExpr() || expression.eContainingFeature() == ExpressionsPackage.eINSTANCE.getIfExp_Condition()) {
            this.record = false;
        }
        if (this.shouldRecordTrace((EReference)expression.eContainingFeature()) && !(expression.eContainer() instanceof ProtectedAreaBlock)) {
            ExpressionTrace<C> trace = new ExpressionTrace<C>(expression);
            this.recordedTraces.add(trace);
            if (this.invocationTraces != null) {
                this.invocationTraces.add(trace);
            }
        }
        Object result = null;
        try {
            try {
                result = this.getDelegate().visitExpression(expression);
            }
            catch (AcceleoEvaluationCancelledException e) {
                this.cancel();
                throw e;
            }
        }
        finally {
            this.record = oldRecordingValue;
        }
        if (this.isPropertyCallSource(expression)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource(expression)) {
            this.operationCallSource = result;
        }
        if (expression.eContainingFeature() == MtlPackage.eINSTANCE.getProtectedAreaBlock_Marker()) {
            ExpressionTrace<C> trace = this.recordedTraces.getLast();
            int gap = -1;
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                for (GeneratedText text : entry.getValue()) {
                    if (gap != -1 && text.getStartOffset() >= gap) continue;
                    gap = text.getStartOffset();
                }
            }
            this.operationVisitor.visitTrimOperation((String)result, gap);
        }
        this.currentExpression = oldExpression;
        return result;
    }

    public Object visitIfExp(IfExp<C> ifExp) {
        Object result = super.visitIfExp(ifExp);
        if (this.isPropertyCallSource((OCLExpression<C>)ifExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)ifExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitIterateExp(IterateExp<C, PM> callExp) {
        this.scopeEObjects.add((EObject)callExp.getIterator().get(0));
        Object result = super.visitIterateExp(callExp);
        this.scopeEObjects.removeLast();
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitIteratorExp(IteratorExp<C, PM> callExp) {
        this.scopeEObjects.add((EObject)callExp.getIterator().get(0));
        Object result = super.visitIteratorExp(callExp);
        this.scopeEObjects.removeLast();
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitLetExp(LetExp<C, PM> letExp) {
        this.scopeEObjects.add((EObject)letExp.getVariable());
        Object result = super.visitLetExp(letExp);
        this.scopeEObjects.removeLast();
        if (this.isPropertyCallSource((OCLExpression<C>)letExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)letExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitOperationCallExp(OperationCallExp<C, O> callExp) {
        OCLExpression<C> oldOperationCallSourceExpression = this.operationCallSourceExpression;
        this.operationCallSourceExpression = callExp.getSource();
        Object result = this.isTraceabilityImpactingOperation(callExp) ? this.internalVisitOperationCallExp(callExp) : super.visitOperationCallExp(callExp);
        this.operationCallSource = null;
        this.operationCallSourceExpression = oldOperationCallSourceExpression;
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitPropertyCallExp(PropertyCallExp<C, P> callExp) {
        OCLExpression<C> oldPropertyCallSourceExpression = this.propertyCallSourceExpression;
        this.propertyCallSourceExpression = callExp.getSource();
        Object result = this.getDelegate().visitPropertyCallExp(callExp);
        this.propertyCallSourceExpression = oldPropertyCallSourceExpression;
        if (this.propertyCallSource != null && result != null) {
            InputElement propertyCallInput = this.getInputElement(this.propertyCallSource, (EStructuralFeature)callExp.getReferredProperty());
            this.propertyCallSource = null;
            if (this.protectedAreaSource != null) {
                propertyCallInput = this.protectedAreaSource;
            }
            GeneratedText text = this.createGeneratedTextFor((EObject)callExp);
            if (this.operationArgumentTrace != null) {
                this.operationArgumentTrace.addTrace(propertyCallInput, text, result);
            } else if (this.initializingVariable != null && !(result instanceof EObject)) {
                this.variableTraces.get(this.initializingVariable).addTrace(propertyCallInput, text, result);
            } else if (this.recordedTraces.size() > 0 && this.shouldRecordTrace((OCLExpression<C>)callExp)) {
                this.recordedTraces.getLast().addTrace(propertyCallInput, text, result);
            }
        }
        if (this.isPropertyCallSource((OCLExpression<C>)callExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)callExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitStateExp(StateExp<C, S> stateExp) {
        Object result = super.visitStateExp(stateExp);
        if (this.isPropertyCallSource((OCLExpression<C>)stateExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)stateExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    public Object visitStringLiteralExp(StringLiteralExp<C> literalExp) {
        Object result = super.visitStringLiteralExp(literalExp);
        InputElement input = this.getInputElement(this.retrieveScopeEObjectValue());
        if (this.protectedAreaSource != null) {
            input = this.protectedAreaSource;
        }
        GeneratedText text = this.createGeneratedTextFor((EObject)literalExp);
        if (this.operationArgumentTrace != null) {
            this.operationArgumentTrace.addTrace(input, text, result);
        } else if (this.initializingVariable != null) {
            this.variableTraces.get(this.initializingVariable).addTrace(input, text, result);
        } else if (this.recordedTraces.size() > 0 && ((String)result).length() > 0 && this.shouldRecordTrace((OCLExpression<C>)literalExp)) {
            this.recordedTraces.getLast().addTrace(input, text, result);
        }
        return result;
    }

    public Object visitVariable(org.eclipse.ocl.expressions.Variable<C, PM> variable) {
        boolean isPrimitive = variable.getType() instanceof PrimitiveType;
        org.eclipse.ocl.expressions.Variable<C, PM> oldVar = null;
        if (isPrimitive) {
            this.variableTraces.put(variable, new VariableTrace<C, PM>(variable));
            oldVar = this.initializingVariable;
            this.initializingVariable = variable;
        }
        Object result = this.getDelegate().visitVariable(variable);
        if (this.scopeEObjects.getLast() == variable && result instanceof EObject) {
            this.scopeEObjects.removeLast();
            this.scopeEObjects.add((EObject)result);
        }
        this.initializingVariable = oldVar;
        return result;
    }

    public Object visitVariableExp(VariableExp<C, PM> variableExp) {
        boolean recordTrace;
        Object result = super.visitVariableExp(variableExp);
        boolean recordOperationArgument = this.operationArgumentTrace != null;
        boolean recordVariableInitialization = this.initializingVariable != null && this.variableTraces.get(variableExp.getReferredVariable()) != null && this.shouldRecordTrace((OCLExpression<C>)variableExp);
        boolean bl = recordTrace = this.initializingVariable == null && this.recordedTraces.size() > 0 && result instanceof String && ((String)result).length() > 0;
        if (recordVariableInitialization || recordTrace || recordOperationArgument) {
            VariableTrace<C, PM> referredVarTrace = this.variableTraces.get(variableExp.getReferredVariable());
            if (referredVarTrace != null) {
                for (Map.Entry<InputElement, Set<GeneratedText>> entry : referredVarTrace.getTraces().entrySet()) {
                    InputElement input = entry.getKey();
                    if (this.protectedAreaSource != null) {
                        input = this.protectedAreaSource;
                    }
                    for (GeneratedText text : entry.getValue()) {
                        if (recordOperationArgument) {
                            this.operationArgumentTrace.addTrace(input, text, result);
                            continue;
                        }
                        if (recordTrace) {
                            this.recordedTraces.getLast().addTrace(input, text, result);
                            continue;
                        }
                        if (!recordVariableInitialization) continue;
                        this.variableTraces.get(this.initializingVariable).addTrace(input, text, result);
                    }
                }
            } else {
                InputElement input = this.protectedAreaSource == null ? this.getInputElement(this.retrieveScopeEObjectValue(0)) : this.protectedAreaSource;
                GeneratedText text = this.createGeneratedTextFor((EObject)variableExp);
                if (recordOperationArgument) {
                    this.operationArgumentTrace.addTrace(input, text, result);
                } else if (recordTrace) {
                    this.recordedTraces.getLast().addTrace(input, text, result);
                } else if (recordVariableInitialization) {
                    this.variableTraces.get(this.initializingVariable).addTrace(input, text, result);
                }
            }
        }
        if (this.isPropertyCallSource((OCLExpression<C>)variableExp)) {
            this.propertyCallSource = (EObject)result;
        } else if (this.isOperationCallSource((OCLExpression<C>)variableExp)) {
            this.operationCallSource = result;
        }
        return result;
    }

    private void alterProtectedAreaTrace(String content, Block protectedArea, ExpressionTrace<C> trace) {
        String areaStart = String.valueOf(AcceleoEngineMessages.getString((String)"usercode.start")) + ' ';
        String areaEnd = AcceleoEngineMessages.getString((String)"usercode.end");
        int markerIndex = content.indexOf(areaStart) + areaStart.length();
        int areaEndIndex = content.indexOf(areaEnd);
        boolean isExistingArea = trace.getTraces().size() == 0;
        int markerEndIndex = content.indexOf("\r\n", markerIndex);
        if (markerEndIndex == -1) {
            markerEndIndex = content.indexOf(10, markerIndex);
        }
        if (markerEndIndex == -1) {
            markerEndIndex = content.indexOf(13, markerIndex);
        }
        int contentStart = -1;
        int endOffset = -1;
        ArrayList<GeneratedText> contentTraces = new ArrayList<GeneratedText>();
        if (isExistingArea) {
            GeneratedText markerRegion = TraceabilityFactory.eINSTANCE.createGeneratedText();
            markerRegion.setStartOffset(markerIndex);
            markerRegion.setStartOffset(markerEndIndex);
            markerRegion.setModuleElement(this.getModuleElement((EObject)protectedArea));
            trace.addTrace(this.protectedAreaSource, markerRegion, content);
        } else {
            for (Map.Entry<InputElement, Set<GeneratedText>> entry : trace.getTraces().entrySet()) {
                for (GeneratedText text : entry.getValue()) {
                    text.setStartOffset(text.getStartOffset() + markerIndex);
                    text.setEndOffset(text.getEndOffset() + markerIndex);
                    if (text.getEndOffset() > markerEndIndex && (contentStart == -1 || text.getStartOffset() < contentStart)) {
                        contentStart = text.getStartOffset();
                        contentTraces.add(text);
                    }
                    if (endOffset != -1 && text.getEndOffset() <= endOffset) continue;
                    endOffset = text.getEndOffset();
                }
            }
        }
        if (contentStart > markerEndIndex) {
            int gap = contentStart - markerEndIndex;
            endOffset -= gap;
            for (GeneratedText text : contentTraces) {
                text.setStartOffset(text.getStartOffset() - gap);
                text.setEndOffset(text.getEndOffset() - gap);
            }
        }
        GeneratedText startRegion = TraceabilityFactory.eINSTANCE.createGeneratedText();
        startRegion.setEndOffset(markerIndex);
        startRegion.setModuleElement(this.getModuleElement((EObject)protectedArea));
        startRegion.setSourceElement(this.protectedAreaSource);
        GeneratedText endRegion = TraceabilityFactory.eINSTANCE.createGeneratedText();
        endRegion.setStartOffset(areaEndIndex);
        endRegion.setEndOffset(content.length());
        endRegion.setModuleElement(this.getModuleElement((EObject)protectedArea));
        endRegion.setSourceElement(this.protectedAreaSource);
        GeneratedText contentRegion = null;
        if (endOffset != areaEndIndex) {
            contentRegion = TraceabilityFactory.eINSTANCE.createGeneratedText();
            contentRegion.setStartOffset(endOffset);
            contentRegion.setEndOffset(areaEndIndex);
            contentRegion.setModuleElement(this.getModuleElement((EObject)protectedArea));
            contentRegion.setSourceElement(this.protectedAreaSource);
        }
        LinkedHashSet set = (LinkedHashSet)trace.getTraces().get(this.protectedAreaSource);
        LinkedHashSet copy = new LinkedHashSet(set);
        set.clear();
        set.add(startRegion);
        set.addAll(copy);
        if (contentRegion != null) {
            set.add(contentRegion);
        }
        set.add(endRegion);
    }

    private void cancel() {
        this.currentExpression = null;
        if (this.currentFiles != null) {
            this.currentFiles.clear();
            this.currentFiles = null;
        }
        this.initializingVariable = null;
        if (this.invocationTraces != null) {
            for (ExpressionTrace expressionTrace : this.invocationTraces) {
                expressionTrace.dispose();
            }
            this.invocationTraces.clear();
            this.invocationTraces = null;
        }
        if (this.operationArgumentTrace != null) {
            this.operationArgumentTrace.dispose();
            this.operationArgumentTrace = null;
        }
        this.operationCallSource = null;
        this.operationCallSourceExpression = null;
        this.propertyCallSource = null;
        this.propertyCallSourceExpression = null;
        this.protectedAreaSource = null;
        this.record = true;
        for (ExpressionTrace expressionTrace : this.recordedTraces) {
            expressionTrace.dispose();
        }
        this.recordedTraces.clear();
        if (this.scopeEObjects != null) {
            this.scopeEObjects.clear();
        }
        for (VariableTrace variableTrace : this.variableTraces.values()) {
            variableTrace.dispose();
        }
        this.variableTraces.clear();
    }

    private GeneratedText createGeneratedTextFor(EObject moduleElement) {
        ModuleElement modElement = this.getModuleElement(moduleElement);
        GeneratedText text = TraceabilityFactory.eINSTANCE.createGeneratedText();
        text.setModuleElement(modElement);
        return text;
    }

    private GeneratedFile getGeneratedFile(File generatedFile, boolean appendMode) {
        GeneratedFile soughtFile = this.evaluationTrace.getGeneratedFile(generatedFile.getPath());
        if (soughtFile == null) {
            soughtFile = TraceabilityFactory.eINSTANCE.createGeneratedFile();
            soughtFile.setPath(generatedFile.getPath());
            soughtFile.setName(this.stripFileNameFrom(generatedFile.getPath()));
            if (appendMode && generatedFile.exists() && generatedFile.canRead()) {
                int length = 0;
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(generatedFile));
                    String line = reader.readLine();
                    while (line != null) {
                        length += line.length() + 1;
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    AcceleoEnginePlugin.log((Exception)e, (boolean)true);
                }
                soughtFile.setLength(length);
            }
            this.evaluationTrace.getGeneratedFiles().add((Object)soughtFile);
        }
        return soughtFile;
    }

    private InputElement getInputElement(EObject modelElement) {
        ModelFile soughtModel = this.getModelFile(modelElement);
        for (InputElement input : soughtModel.getInputElements()) {
            if (input.getFeature() != null || input.getModelElement() != modelElement) continue;
            return input;
        }
        InputElement soughtElement = TraceabilityFactory.eINSTANCE.createInputElement();
        soughtElement.setModelElement(modelElement);
        soughtModel.getInputElements().add((Object)soughtElement);
        return soughtElement;
    }

    private InputElement getInputElement(EObject modelElement, EOperation operation) {
        ModelFile soughtModel = this.getModelFile(modelElement);
        for (InputElement input : soughtModel.getInputElements()) {
            if (input.getOperation() != operation || input.getModelElement() != modelElement) continue;
            return input;
        }
        InputElement soughtElement = TraceabilityFactory.eINSTANCE.createInputElement();
        soughtElement.setModelElement(modelElement);
        soughtElement.setOperation(operation);
        soughtModel.getInputElements().add((Object)soughtElement);
        return soughtElement;
    }

    private InputElement getInputElement(EObject modelElement, EStructuralFeature feature) {
        ModelFile soughtModel = this.getModelFile(modelElement);
        for (InputElement input : soughtModel.getInputElements()) {
            if (input.getFeature() != feature || input.getModelElement() != modelElement) continue;
            return input;
        }
        InputElement soughtElement = TraceabilityFactory.eINSTANCE.createInputElement();
        soughtElement.setModelElement(modelElement);
        soughtElement.setFeature(feature);
        soughtModel.getInputElements().add((Object)soughtElement);
        return soughtElement;
    }

    private ModelFile getModelFile(EObject modelElement) {
        URI modelURI = modelElement.eResource().getURI();
        String name = modelURI.lastSegment();
        ModelFile soughtModel = this.evaluationTrace.getInputModel(modelURI.path());
        if (soughtModel == null) {
            soughtModel = TraceabilityFactory.eINSTANCE.createModelFile();
            soughtModel.setPath(modelURI.toString());
            soughtModel.setName(name);
            this.evaluationTrace.getModelFiles().add((Object)soughtModel);
        }
        return soughtModel;
    }

    private ModuleElement getModuleElement(EObject moduleElement) {
        ModuleFile soughtModule = this.getModuleFile(moduleElement);
        for (ModuleElement element : soughtModule.getModuleElements()) {
            if (element.getModuleElement() != moduleElement) continue;
            return element;
        }
        ModuleElement soughtElement = TraceabilityFactory.eINSTANCE.createModuleElement();
        soughtElement.setModuleElement(moduleElement);
        soughtModule.getModuleElements().add((Object)soughtElement);
        return soughtElement;
    }

    private ModuleFile getModuleFile(EObject moduleElement) {
        String moduleURI = moduleElement.eResource().getURI().toString();
        ModuleFile soughtModule = this.evaluationTrace.getGenerationModule(moduleURI);
        if (soughtModule == null) {
            soughtModule = TraceabilityFactory.eINSTANCE.createModuleFile();
            soughtModule.setPath(moduleURI);
            soughtModule.setName(this.stripFileNameFrom(moduleURI));
            this.evaluationTrace.getModules().add((Object)soughtModule);
        }
        return soughtModule;
    }

    private Object internalVisitOperationCallExp(OperationCallExp<C, O> callExp) {
        Collection<Object> result;
        String operationName = ((EOperation)callExp.getReferredOperation()).getName();
        if (operationName.equals("substitute") || operationName.equals("substituteAll") || operationName.equals("replace") || operationName.equals("replaceAll")) {
            boolean substituteAll = false;
            boolean substituteRegexes = false;
            if (operationName.equals("substituteAll")) {
                substituteAll = true;
            } else if (operationName.equals("replace")) {
                substituteRegexes = true;
            } else if (operationName.equals("replaceAll")) {
                substituteAll = true;
                substituteRegexes = true;
            }
            Object sourceObject = super.visitExpression(callExp.getSource());
            boolean oldRecordingValue = this.record;
            this.record = false;
            Object substring = super.visitExpression((OCLExpression)callExp.getArgument().get(0));
            this.record = oldRecordingValue;
            ExpressionTrace<C> oldArgTrace = this.operationArgumentTrace;
            this.operationArgumentTrace = new ExpressionTrace((OCLExpression)callExp.getArgument().get(1));
            Object substitution = super.visitExpression((OCLExpression)callExp.getArgument().get(1));
            if (!substituteRegexes) {
                substring = "\\Q" + substring + "\\E";
                substitution = ((String)substitution).replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
            }
            String result2 = this.operationVisitor.visitReplaceOperation((String)sourceObject, (String)substring, (String)substitution, this.operationArgumentTrace, substituteAll, false);
            this.operationArgumentTrace = oldArgTrace;
            return result2;
        }
        if (callExp.getOperationCode() == 22) {
            Object sourceObject = super.visitExpression(callExp.getSource());
            Object startIndex = super.visitExpression((OCLExpression)callExp.getArgument().get(0));
            Object endIndex = super.visitExpression((OCLExpression)callExp.getArgument().get(1));
            result = this.operationVisitor.visitSubstringOperation((String)sourceObject, (Integer)startIndex - 1, (Integer)endIndex);
        } else if (operationName.equals("trim")) {
            Object sourceObject = super.visitExpression(callExp.getSource());
            result = this.operationVisitor.visitTrimOperation((String)sourceObject);
        } else if (operationName.equals("first")) {
            Object sourceObject = super.visitExpression(callExp.getSource());
            Object endIndex = super.visitExpression((OCLExpression)callExp.getArgument().get(0));
            result = this.operationVisitor.visitFirstOperation((String)sourceObject, (Integer)endIndex);
        } else if (operationName.equals("last")) {
            Object sourceObject = super.visitExpression(callExp.getSource());
            Object charCount = super.visitExpression((OCLExpression)callExp.getArgument().get(0));
            result = this.operationVisitor.visitLastOperation((String)sourceObject, (Integer)charCount);
        } else if (operationName.equals("index")) {
            Object sourceObject = super.visitExpression(callExp.getSource());
            Object substring = super.visitExpression((OCLExpression)callExp.getArgument().get(0));
            result = this.operationVisitor.visitIndexOperation((String)sourceObject, (String)substring);
        } else if (operationName.equals("isAlpha")) {
            Object sourceObject = super.visitExpression(callExp.getSource());
            result = this.operationVisitor.visitIsAlphaOperation((String)sourceObject);
        } else if (operationName.equals("isAlphanum")) {
            Object sourceObject = super.visitExpression(callExp.getSource());
            result = this.operationVisitor.visitIsAlphanumOperation((String)sourceObject);
        } else if (operationName.equals("sep")) {
            Object sourceObject = super.visitExpression(callExp.getSource());
            ExpressionTrace<C> oldArgTrace = this.operationArgumentTrace;
            this.operationArgumentTrace = new ExpressionTrace((OCLExpression)callExp.getArgument().get(0));
            Object separator = super.visitExpression((OCLExpression)callExp.getArgument().get(0));
            result = this.operationVisitor.visitSepOperation((Collection)sourceObject, (String)separator);
            this.operationArgumentTrace = oldArgTrace;
        } else {
            result = super.visitOperationCallExp(callExp);
        }
        return result;
    }

    private boolean isOperationCallSource(OCLExpression<C> expression) {
        return expression == this.operationCallSourceExpression;
    }

    private boolean isPropertyCallSource(OCLExpression<C> expression) {
        return expression == this.propertyCallSourceExpression;
    }

    private boolean isTraceabilityImpactingOperation(OperationCallExp<C, O> operationCall) {
        boolean isImpacting = false;
        int operationCode = operationCall.getOperationCode();
        EClassifier operationEType = ((EOperation)operationCall.getReferredOperation()).getEType();
        if (operationEType == this.getEnvironment().getOCLStandardLibrary().getString() || operationEType.getName().equals("String")) {
            if (operationCode > 0) {
                isImpacting = operationCode == 22;
            } else {
                String operationName = ((EOperation)operationCall.getReferredOperation()).getName();
                isImpacting = isImpacting || operationName.equals("first");
                isImpacting = isImpacting || operationName.equals("index");
                isImpacting = isImpacting || operationName.equals("isAlpha");
                isImpacting = isImpacting || operationName.equals("isAlphanum");
                isImpacting = isImpacting || operationName.equals("last");
                isImpacting = isImpacting || operationName.equals("strcmp");
                isImpacting = isImpacting || operationName.equals("strstr");
                isImpacting = isImpacting || operationName.equals("strtok");
                isImpacting = isImpacting || operationName.equals("substitute");
                isImpacting = isImpacting || operationName.equals("contains");
                isImpacting = isImpacting || operationName.equals("endsWith");
                isImpacting = isImpacting || operationName.equals("replace");
                isImpacting = isImpacting || operationName.equals("replaceAll");
                isImpacting = isImpacting || operationName.equals("startsWith");
                isImpacting = isImpacting || operationName.equals("substituteAll");
                isImpacting = isImpacting || operationName.equals("tokenize");
                isImpacting = isImpacting || operationName.equals("trim");
                isImpacting = isImpacting || operationName.equals("sep");
            }
        }
        return isImpacting;
    }

    private EObject retrieveScopeEObjectValue() {
        return this.retrieveScopeEObjectValue(this.scopeEObjects.size() - 1);
    }

    private EObject retrieveScopeEObjectValue(int index) {
        EObject scopeValue = null;
        int i = index;
        while (i >= 0) {
            Object value;
            EObject scope = this.scopeEObjects.get(i);
            if (scope instanceof org.eclipse.ocl.expressions.Variable) {
                value = this.getEvaluationEnvironment().getValueOf(((org.eclipse.ocl.expressions.Variable)scope).getName());
                if (value instanceof EObject) {
                    scopeValue = (EObject)value;
                    break;
                }
            } else if (scope instanceof VariableExp) {
                value = this.getEvaluationEnvironment().getValueOf(((VariableExp)scope).getReferredVariable().getName());
                if (value instanceof EObject) {
                    scopeValue = (EObject)value;
                    break;
                }
            } else {
                scopeValue = scope;
                break;
            }
            --i;
        }
        return scopeValue;
    }

    private boolean shouldRecordTrace(EReference reference) {
        boolean generate = reference == MtlPackage.eINSTANCE.getBlock_Body();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getFileBlock_FileUrl();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_After();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_After();
        generate = generate || reference == MtlPackage.eINSTANCE.getProtectedAreaBlock_Marker();
        return generate;
    }

    private boolean shouldRecordTrace(OCLExpression<C> expression) {
        OperationCallExp call;
        EOperation op;
        boolean result = true;
        if (expression.eContainingFeature() == MtlPackage.eINSTANCE.getForBlock_IterSet() || !this.record) {
            return false;
        }
        if (this.isPropertyCallSource(expression)) {
            result = false;
        } else if (this.isOperationCallSource(expression) && (op = (EOperation)(call = (OperationCallExp)expression.eContainer()).getReferredOperation()).getEType() != this.getEnvironment().getOCLStandardLibrary().getString()) {
            result = false;
        }
        return result;
    }

    private String stripFileNameFrom(String filePath) {
        String fileName = filePath;
        if (fileName.indexOf(File.separator) != -1) {
            fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
        }
        if (fileName.indexOf(46) > 0) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }
}

