/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.partition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.ui.text.java.JavaAutoIndentStrategy;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.autoedit.JETTemplateAutoEditStrategy;
import org.eclipse.jet.internal.editor.configuration.JETTokenStyleManager;
import org.eclipse.jet.internal.editor.configuration.delegates.IJETDefaultTextColorerDelegate;
import org.eclipse.jet.internal.editor.contentassist.JETCustomTagAssistProcessor;
import org.eclipse.jet.internal.editor.contentassist.JETDirectiveAssistProcessor;
import org.eclipse.jet.internal.editor.contentassist.JETJavaDeclarationAssistProcessor;
import org.eclipse.jet.internal.editor.contentassist.JETJavaExpressionAssistProcessor;
import org.eclipse.jet.internal.editor.contentassist.JETJavaScriptletAssistProcessor;
import org.eclipse.jet.internal.editor.formatter.JETCustomTagFormattingStrategy;
import org.eclipse.jet.internal.editor.formatter.JETDirectiveFormattingStrategy;
import org.eclipse.jet.internal.editor.formatter.JETJavaDeclarationFormattingStrategy;
import org.eclipse.jet.internal.editor.formatter.JETJavaExpressionFormattingStrategy;
import org.eclipse.jet.internal.editor.formatter.JETJavaScriptletFormattingStrategy;
import org.eclipse.jet.internal.editor.partition.PartitionScannerBasedDamagerRepairer;
import org.eclipse.jet.internal.editor.rules.ASTElementScannerRule;
import org.eclipse.jet.internal.editor.rules.ASTJETCommentRule;
import org.eclipse.jet.internal.editor.rules.ASTJETCustomTagRule;
import org.eclipse.jet.internal.editor.rules.ASTJETDirectiveRule;
import org.eclipse.jet.internal.editor.rules.ASTJETJavaDeclarationRule;
import org.eclipse.jet.internal.editor.rules.ASTJETJavaExpressionRule;
import org.eclipse.jet.internal.editor.rules.ASTJETJavaScriptletRule;
import org.eclipse.jet.internal.editor.scanners.JETCommentScanner;
import org.eclipse.jet.internal.editor.scanners.JETCustomTagScanner;
import org.eclipse.jet.internal.editor.scanners.JETDirectiveScanner;
import org.eclipse.jet.internal.editor.scanners.JETJavaDeclarationScanner;
import org.eclipse.jet.internal.editor.scanners.JETJavaExpressionScanner;
import org.eclipse.jet.internal.editor.scanners.JETJavaScriptletScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class JETDocumentPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String JET_COMMENT = "__jet_comment";
    public static final String JET_CUSTOM_TAG = "__jet_xml_tag";
    public static final String JET_DIRECTIVE = "__jet_directive";
    public static final String JET_JAVA_DECLARATION = "__jet_java_declaration";
    public static final String JET_JAVA_EXPRESSION = "__jet_java_expression";
    public static final String JET_JAVA_SCRIPTLET = "__jet_java_scriptlet";
    private Map tokenScanners;
    private Map damagerRepairers;
    private Map damagersOnly;
    private Map repairersOnly;
    private Map completionProcessors;
    private Map formattingStrategies;
    private JETTextEditor editor;
    private List contentTypes;
    private JETCustomTagScanner tagScanner;
    private JETDirectiveScanner directiveScanner;
    private JETJavaDeclarationScanner declarationScanner;
    private JETJavaExpressionScanner expressionScanner;
    private JETJavaScriptletScanner scriptletScanner;
    private JETCommentScanner commentScanner;
    private IContentAssistProcessor tagAssistProcessor;
    private IContentAssistProcessor scriptletAssistProcessor;
    private IContentAssistProcessor expressionAssistProcessor;
    private IContentAssistProcessor declarationAssistProcessor;
    private IContentAssistProcessor directiveAssistProcessor;
    private IFormattingStrategy tagFormattingStrategy;
    private IFormattingStrategy scriptletFormattingStrategy;
    private IFormattingStrategy expressionFormattingStrategy;
    private IFormattingStrategy declarationFormattingStrategy;
    private IFormattingStrategy directiveFormattingStrategy;
    private PartitionScannerBasedDamagerRepairer jetTextContentDamagerRepairer;

    public JETDocumentPartitionScanner(JETTextEditor editor) {
        this.editor = editor;
        ArrayList<ASTElementScannerRule> rules = new ArrayList<ASTElementScannerRule>();
        Token jetComments = new Token((Object)JET_COMMENT);
        Token jetCustomTags = new Token((Object)JET_CUSTOM_TAG);
        Token jetDirective = new Token((Object)JET_DIRECTIVE);
        Token jetJavaDeclaration = new Token((Object)JET_JAVA_DECLARATION);
        Token jetJavaExpression = new Token((Object)JET_JAVA_EXPRESSION);
        Token jetJavaScriptlet = new Token((Object)JET_JAVA_SCRIPTLET);
        rules.add(new ASTJETCommentRule(editor, (IToken)jetComments));
        rules.add(new ASTJETCustomTagRule(editor, (IToken)jetCustomTags));
        rules.add(new ASTJETDirectiveRule(editor, (IToken)jetDirective));
        rules.add(new ASTJETJavaDeclarationRule(editor, (IToken)jetJavaDeclaration));
        rules.add(new ASTJETJavaExpressionRule(editor, (IToken)jetJavaExpression));
        rules.add(new ASTJETJavaScriptletRule(editor, (IToken)jetJavaScriptlet));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        result = rules.toArray(result);
        this.setPredicateRules(result);
    }

    public int getNextCharacterOffset() {
        return this.fOffset;
    }

    public String[] getContentTypes() {
        if (this.contentTypes == null) {
            this.contentTypes = new ArrayList();
            this.contentTypes.add("__dftl_partition_content_type");
            this.contentTypes.add(JET_COMMENT);
            this.contentTypes.add(JET_CUSTOM_TAG);
            this.contentTypes.add(JET_DIRECTIVE);
            this.contentTypes.add(JET_JAVA_DECLARATION);
            this.contentTypes.add(JET_JAVA_EXPRESSION);
            this.contentTypes.add(JET_JAVA_SCRIPTLET);
        }
        String[] result = new String[this.contentTypes.size()];
        result = this.contentTypes.toArray(result);
        return result;
    }

    private void initTokenScanners() {
        this.tokenScanners = new HashMap();
        this.tokenScanners.put(JET_COMMENT, this.getCommentScanner());
        this.tokenScanners.put(JET_CUSTOM_TAG, this.getCustomTagScanner());
        this.tokenScanners.put(JET_DIRECTIVE, this.getDirectiveScanner());
        this.tokenScanners.put(JET_JAVA_DECLARATION, this.getJavaDeclarationScanner());
        this.tokenScanners.put(JET_JAVA_EXPRESSION, this.getJavaExpressionScanner());
        this.tokenScanners.put(JET_JAVA_SCRIPTLET, this.getJavaScriptletScanner());
    }

    private void initCompletionProcessors(ContentAssistant assistant) {
        this.completionProcessors = new HashMap();
        this.completionProcessors.put("__dftl_partition_content_type", this.getTextElementAssistProcessor(assistant));
        this.completionProcessors.put(JET_COMMENT, this.getCommentAssistProcessor(assistant));
        this.completionProcessors.put(JET_CUSTOM_TAG, this.getCustomTagAssistProcessor(assistant));
        this.completionProcessors.put(JET_DIRECTIVE, this.getDirectiveAssistProcessor(assistant));
        this.completionProcessors.put(JET_JAVA_DECLARATION, this.getJavaDeclarationAssistProcessor(assistant));
        this.completionProcessors.put(JET_JAVA_EXPRESSION, this.getJavaExpressionAssistProcessor(assistant));
        this.completionProcessors.put(JET_JAVA_SCRIPTLET, this.getJavaScriptletAssistProcessor(assistant));
    }

    private void initFormattingStrategies() {
        this.formattingStrategies = new HashMap();
        this.formattingStrategies.put("__dftl_partition_content_type", this.getTextElementFormattingStrategy());
        this.formattingStrategies.put(JET_COMMENT, this.getCommentFormattingStrategy());
        this.formattingStrategies.put(JET_CUSTOM_TAG, this.getCustomTagFormattingStrategy());
        this.formattingStrategies.put(JET_DIRECTIVE, this.getDirectiveFormattingStrategy());
        this.formattingStrategies.put(JET_JAVA_DECLARATION, this.getJavaDeclarationFormattingStrategy());
        this.formattingStrategies.put(JET_JAVA_EXPRESSION, this.getJavaExpressionFormattingStrategy());
        this.formattingStrategies.put(JET_JAVA_SCRIPTLET, this.getJavaScriptletFormattingStrategy());
    }

    private void initDamagerRepairers() {
        this.damagerRepairers = new HashMap();
        this.damagerRepairers.put(JET_COMMENT, this.createDefaultDamagerRepairer(JET_COMMENT));
        this.damagerRepairers.put(JET_CUSTOM_TAG, this.createDefaultDamagerRepairer(JET_CUSTOM_TAG));
        this.damagerRepairers.put(JET_DIRECTIVE, this.createDefaultDamagerRepairer(JET_DIRECTIVE));
        this.damagerRepairers.put(JET_JAVA_DECLARATION, this.createDefaultDamagerRepairer(JET_JAVA_DECLARATION));
        this.damagerRepairers.put(JET_JAVA_EXPRESSION, this.createDefaultDamagerRepairer(JET_JAVA_EXPRESSION));
        this.damagerRepairers.put(JET_JAVA_SCRIPTLET, this.createDefaultDamagerRepairer(JET_JAVA_SCRIPTLET));
        if (this.createJETTextContentDamagerRepairer() != null) {
            this.damagerRepairers.put("__dftl_partition_content_type", this.jetTextContentDamagerRepairer);
        }
    }

    private void initDamagersOnly() {
        this.damagersOnly = new HashMap();
    }

    protected void initRepairersOnly() {
        this.repairersOnly = new HashMap();
    }

    protected IFormattingStrategy getTextElementFormattingStrategy() {
        return null;
    }

    protected IFormattingStrategy getCommentFormattingStrategy() {
        return null;
    }

    protected IFormattingStrategy getCustomTagFormattingStrategy() {
        if (this.tagFormattingStrategy == null) {
            this.tagFormattingStrategy = new JETCustomTagFormattingStrategy();
        }
        return this.tagFormattingStrategy;
    }

    protected IFormattingStrategy getJavaScriptletFormattingStrategy() {
        if (this.scriptletFormattingStrategy == null) {
            this.scriptletFormattingStrategy = new JETJavaScriptletFormattingStrategy();
        }
        return this.scriptletFormattingStrategy;
    }

    protected IFormattingStrategy getJavaExpressionFormattingStrategy() {
        if (this.expressionFormattingStrategy == null) {
            this.expressionFormattingStrategy = new JETJavaExpressionFormattingStrategy();
        }
        return this.expressionFormattingStrategy;
    }

    protected IFormattingStrategy getJavaDeclarationFormattingStrategy() {
        if (this.declarationFormattingStrategy == null) {
            this.declarationFormattingStrategy = new JETJavaDeclarationFormattingStrategy();
        }
        return this.declarationFormattingStrategy;
    }

    protected IFormattingStrategy getDirectiveFormattingStrategy() {
        if (this.directiveFormattingStrategy == null) {
            this.directiveFormattingStrategy = new JETDirectiveFormattingStrategy();
        }
        return this.directiveFormattingStrategy;
    }

    protected IContentAssistProcessor getTextElementAssistProcessor(ContentAssistant assistant) {
        return null;
    }

    protected IContentAssistProcessor getCommentAssistProcessor(ContentAssistant assistant) {
        return null;
    }

    protected IContentAssistProcessor getCustomTagAssistProcessor(ContentAssistant assistant) {
        if (this.tagAssistProcessor == null) {
            this.tagAssistProcessor = new JETCustomTagAssistProcessor(this.editor);
        }
        return this.tagAssistProcessor;
    }

    protected IContentAssistProcessor getJavaScriptletAssistProcessor(ContentAssistant assistant) {
        if (this.scriptletAssistProcessor == null) {
            this.scriptletAssistProcessor = new JETJavaScriptletAssistProcessor(this.editor);
        }
        return this.scriptletAssistProcessor;
    }

    protected IContentAssistProcessor getJavaExpressionAssistProcessor(ContentAssistant assistant) {
        if (this.expressionAssistProcessor == null) {
            this.expressionAssistProcessor = new JETJavaExpressionAssistProcessor(this.editor);
        }
        return this.expressionAssistProcessor;
    }

    protected IContentAssistProcessor getJavaDeclarationAssistProcessor(ContentAssistant assistant) {
        if (this.declarationAssistProcessor == null) {
            this.declarationAssistProcessor = new JETJavaDeclarationAssistProcessor(this.editor);
        }
        return this.declarationAssistProcessor;
    }

    protected IContentAssistProcessor getDirectiveAssistProcessor(ContentAssistant assistant) {
        if (this.directiveAssistProcessor == null) {
            this.directiveAssistProcessor = new JETDirectiveAssistProcessor(this.editor);
        }
        return this.directiveAssistProcessor;
    }

    protected ITokenScanner getCommentScanner() {
        JETTokenStyleManager tokenStyleManager = this.editor.getTokenStyleManager();
        IPreferenceStore preferenceStore = this.editor.getEditorPreferenceStore();
        if (this.commentScanner == null) {
            this.commentScanner = new JETCommentScanner(tokenStyleManager, preferenceStore);
        }
        return this.commentScanner;
    }

    protected ITokenScanner getCustomTagScanner() {
        JETTokenStyleManager tokenStyleManager = this.editor.getTokenStyleManager();
        IPreferenceStore preferenceStore = this.editor.getEditorPreferenceStore();
        if (this.tagScanner == null) {
            this.tagScanner = new JETCustomTagScanner(tokenStyleManager, preferenceStore);
        }
        return this.tagScanner;
    }

    protected ITokenScanner getJavaScriptletScanner() {
        JETTokenStyleManager tokenStyleManager = this.editor.getTokenStyleManager();
        IPreferenceStore preferenceStore = this.editor.getEditorPreferenceStore();
        if (this.scriptletScanner == null) {
            this.scriptletScanner = new JETJavaScriptletScanner(tokenStyleManager, preferenceStore);
        }
        return this.scriptletScanner;
    }

    protected ITokenScanner getJavaExpressionScanner() {
        JETTokenStyleManager tokenStyleManager = this.editor.getTokenStyleManager();
        IPreferenceStore preferenceStore = this.editor.getEditorPreferenceStore();
        if (this.expressionScanner == null) {
            this.expressionScanner = new JETJavaExpressionScanner(tokenStyleManager, preferenceStore);
        }
        return this.expressionScanner;
    }

    protected ITokenScanner getJavaDeclarationScanner() {
        JETTokenStyleManager tokenStyleManager = this.editor.getTokenStyleManager();
        IPreferenceStore preferenceStore = this.editor.getEditorPreferenceStore();
        if (this.declarationScanner == null) {
            this.declarationScanner = new JETJavaDeclarationScanner(tokenStyleManager, preferenceStore);
        }
        return this.declarationScanner;
    }

    protected ITokenScanner getDirectiveScanner() {
        JETTokenStyleManager tokenStyleManager = this.editor.getTokenStyleManager();
        IPreferenceStore preferenceStore = this.editor.getEditorPreferenceStore();
        if (this.directiveScanner == null) {
            this.directiveScanner = new JETDirectiveScanner(tokenStyleManager, preferenceStore);
        }
        return this.directiveScanner;
    }

    public ITokenScanner getTokenScanner(String contentType) {
        if (this.tokenScanners == null) {
            this.initTokenScanners();
        }
        ITokenScanner scanner = (ITokenScanner)this.tokenScanners.get(contentType);
        return scanner;
    }

    private PartitionScannerBasedDamagerRepairer createJETTextContentDamagerRepairer() {
        IJETDefaultTextColorerDelegate delegate;
        if (this.jetTextContentDamagerRepairer == null && (delegate = this.editor.getCurrentColorerDelegate()) != null) {
            RuleBasedPartitionScanner partitionScanner = new RuleBasedPartitionScanner();
            partitionScanner.setPredicateRules(delegate.getPartitioningRules());
            this.jetTextContentDamagerRepairer = new PartitionScannerBasedDamagerRepairer((IPartitionTokenScanner)partitionScanner, delegate);
        }
        return this.jetTextContentDamagerRepairer;
    }

    public void updateJETTextContentDamagerRepairer() {
        IJETDefaultTextColorerDelegate delegate;
        if (this.jetTextContentDamagerRepairer != null && (delegate = this.editor.getCurrentColorerDelegate()) != null) {
            RuleBasedPartitionScanner partitionScanner = new RuleBasedPartitionScanner();
            partitionScanner.setPredicateRules(delegate.getPartitioningRules());
            this.jetTextContentDamagerRepairer.setPartitionScanner((IPartitionTokenScanner)partitionScanner);
            this.jetTextContentDamagerRepairer.setTokenScannerProvider(delegate);
        }
    }

    private DefaultDamagerRepairer createDefaultDamagerRepairer(String contentType) {
        ITokenScanner tokenScanner = this.getTokenScanner(contentType);
        return tokenScanner != null ? new DefaultDamagerRepairer(tokenScanner) : null;
    }

    public IPresentationDamager getDamager(String contentType) {
        IPresentationDamager damager;
        if (this.damagerRepairers == null) {
            this.initDamagerRepairers();
        }
        if ((damager = (IPresentationDamager)this.damagerRepairers.get(contentType)) == null) {
            if (this.damagersOnly == null) {
                this.initDamagersOnly();
            }
            damager = (IPresentationDamager)this.damagersOnly.get(contentType);
        }
        return damager;
    }

    public IPresentationRepairer getRepairer(String contentType) {
        IPresentationRepairer repairer;
        if (this.damagerRepairers == null) {
            this.initDamagerRepairers();
        }
        if ((repairer = (IPresentationRepairer)this.damagerRepairers.get(contentType)) == null) {
            if (this.repairersOnly == null) {
                this.initRepairersOnly();
            }
            repairer = (IPresentationRepairer)this.repairersOnly.get(contentType);
        }
        return repairer;
    }

    public IContentAssistProcessor getCompletionProcessor(String contentType, ContentAssistant assistant) {
        if (this.completionProcessors == null) {
            this.initCompletionProcessors(assistant);
        }
        IContentAssistProcessor processor = (IContentAssistProcessor)this.completionProcessors.get(contentType);
        return processor;
    }

    public IFormattingStrategy getFormattingStrategy(String contentType) {
        if (this.formattingStrategies == null) {
            this.initFormattingStrategies();
        }
        IFormattingStrategy formatter = (IFormattingStrategy)this.formattingStrategies.get(contentType);
        return formatter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(String contentType) {
        IAutoEditStrategy[] result = null;
        if (JET_DIRECTIVE.equals(contentType)) {
            result = new IAutoEditStrategy[]{new JETTemplateAutoEditStrategy()};
        } else if (JET_JAVA_SCRIPTLET.equals(contentType)) {
            result = new IAutoEditStrategy[]{new JavaAutoIndentStrategy("__dftl_partitioning", this.editor.getJavaProject()), new JETTemplateAutoEditStrategy()};
        } else if (JET_JAVA_DECLARATION.equals(contentType)) {
            result = new IAutoEditStrategy[]{new JavaAutoIndentStrategy("__dftl_partitioning", this.editor.getJavaProject()), new JETTemplateAutoEditStrategy()};
        }
        return result;
    }
}

