/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.compiler.IJETCompilerState;
import org.eclipse.jet.compiler.JET2CompilationUnit;
import org.eclipse.jet.compiler.Problem;
import org.eclipse.jet.compiler.TagValidationVisitor;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.compiler.JETCompilerState;
import org.eclipse.jet.internal.compiler.LoaderGenerationParameters;
import org.eclipse.jet.internal.compiler.TemplateRunner;
import org.eclipse.jet.internal.compiler.TextTrimmingVisitor;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.parser.ParseProblemSeverity;
import org.eclipse.jet.taglib.TagLibraryReference;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.eclipse.jet.transform.IJETBundleManager;

public class JET2Compiler {
    public static final String RUNTIME_PROBLEM_MARKER = "org.eclipse.jet.runtimeProblem";
    public static final String COMPILE_PROBLEM_MARKER = "org.eclipse.jet.compileProblem";
    public static final String DEFAULT_COMPILED_TEMPLATE_PACKAGE = "org.eclipse.jet.compiled";
    public static final String DEFAULT_COMPILED_TEMPLATE_SRC_DIR = "jet2java";
    public static final String DEFAULT_TEMPLATE_EXT = "jet";
    public static final Boolean DEFAULT_SET_JAVA_FILES_AS_DERIVED = Boolean.TRUE;
    private static final String NS = "org.eclipse.jet.";
    public static final String OPTION_COMPILED_TEMPLATE_PACKAGE = "org.eclipse.jet.compiledTemplatePackage";
    public static final String OPTION_COMPILED_TEMPLATE_SRC_DIR = "org.eclipse.jet.compiledTemplateSrcDir";
    public static final String OPTION_TEMPLATE_EXT = "org.eclipse.jet.templateExt";
    public static final String OPTION_SET_JAVA_FILES_AS_DERIVED = "org.eclipse.jet.setJavaDerived";
    private static Map defaultCompileOptions = null;
    private static final Object defaultCompileOptionsLock = new Object();
    private final IProgressMonitor monitor;
    private final IProject project;
    private IJETCompilerState compilerState;
    private int noCompiles;
    private final Map options;
    private final Map predefinedLibraryMap;
    private final String templateLoaderPackage;
    private final String templateLoaderClassName;
    private Set sourceExtensions = null;
    private final TemplateRunner templateRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getDefaultCompilerOptions() {
        if (defaultCompileOptions == null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(OPTION_COMPILED_TEMPLATE_PACKAGE, DEFAULT_COMPILED_TEMPLATE_PACKAGE);
            map.put(OPTION_COMPILED_TEMPLATE_SRC_DIR, DEFAULT_COMPILED_TEMPLATE_SRC_DIR);
            map.put(OPTION_TEMPLATE_EXT, DEFAULT_TEMPLATE_EXT);
            map.put(OPTION_SET_JAVA_FILES_AS_DERIVED, DEFAULT_SET_JAVA_FILES_AS_DERIVED);
            Object object = defaultCompileOptionsLock;
            synchronized (object) {
                defaultCompileOptions = Collections.unmodifiableMap(map);
            }
        }
        return defaultCompileOptions;
    }

    public JET2Compiler(IProject project, Map options, IJETCompilerState compilerState, IProgressMonitor monitor) {
        this.project = project;
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.options = options == null ? JET2Compiler.getDefaultCompilerOptions() : options;
        this.compilerState = compilerState;
        this.noCompiles = 0;
        IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
        IJETBundleDescriptor descriptor = bundleManager.getDescriptorForProject(project.getName());
        Map map = this.predefinedLibraryMap = descriptor != null ? this.getPredefinedPrefixMap(descriptor) : Collections.EMPTY_MAP;
        if (descriptor != null && descriptor.getTemplateLoaderClass() != null) {
            String templateLoaderClass = descriptor.getTemplateLoaderClass();
            int index = templateLoaderClass.lastIndexOf(46);
            this.templateLoaderPackage = index >= 0 ? templateLoaderClass.substring(0, index) : "";
            this.templateLoaderClassName = index >= 0 ? templateLoaderClass.substring(index + 1) : templateLoaderClass;
        } else {
            this.templateLoaderClassName = null;
            this.templateLoaderPackage = null;
        }
        this.templateRunner = new TemplateRunner();
    }

    public JET2Compiler(IProject project, IProgressMonitor monitor, Map options) {
        this(project, options, new JETCompilerState(), monitor);
    }

    private Map getPredefinedPrefixMap(IJETBundleDescriptor descriptor) {
        TagLibraryReference[] tlRefs = descriptor.getTagLibraryReferences();
        HashMap<String, String> result = new HashMap<String, String>(tlRefs.length);
        int i = 0;
        while (i < tlRefs.length) {
            if (tlRefs[i].isAutoImport()) {
                result.put(tlRefs[i].getPrefix(), tlRefs[i].getTagLibraryId());
            }
            ++i;
        }
        return result;
    }

    public void createTransformFiles() {
        if (this.noCompiles > 0) {
            this.createTemplateLoaderClass();
        }
    }

    private void createTemplateLoaderClass() {
        if (this.templateLoaderClassName == null) {
            return;
        }
        LoaderGenerationParameters args = new LoaderGenerationParameters(this.templateLoaderPackage, this.templateLoaderClassName, this.compilerState.getTemplateMap());
        String src = this.templateRunner.generate("templates/jet2transform.jet", Collections.singletonMap("args", args));
        IPath targetPath = new Path(this.getSourceDirOption()).append(this.templateLoaderPackage.replace('.', '/')).append(this.templateLoaderClassName).addFileExtension("java");
        try {
            IFile file = this.project.getFile(targetPath);
            this.writeFile(src, file, file.getCharset());
        }
        catch (CoreException e) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, e);
        }
    }

    private String getSourceDirOption() {
        return this.getOption(OPTION_COMPILED_TEMPLATE_SRC_DIR, DEFAULT_COMPILED_TEMPLATE_SRC_DIR);
    }

    private String getOption(String key, String defaultValue) {
        Object value = this.options.get(key);
        return value == null ? defaultValue : value.toString();
    }

    private boolean getBooleanOption(String key, boolean defaultValue) {
        Object value = this.options.get(key);
        return value == null ? defaultValue : (value instanceof Boolean ? ((Boolean)value).booleanValue() : Boolean.valueOf(value.toString()).booleanValue());
    }

    private boolean isJETSource(IPath path) {
        if (this.sourceExtensions == null) {
            this.sourceExtensions = new HashSet();
            String[] extensions = this.getOption(OPTION_TEMPLATE_EXT, DEFAULT_TEMPLATE_EXT).split(",");
            int i = 0;
            while (i < extensions.length) {
                this.sourceExtensions.add(extensions[i]);
                ++i;
            }
        }
        return this.sourceExtensions.contains(path.getFileExtension());
    }

    public boolean isJET2SourceFile(IResource resource) {
        return resource.getType() == 1 && this.isJETSource(resource.getFullPath());
    }

    public void compile(IResource resource) {
        if (!this.isJET2SourceFile(resource)) {
            return;
        }
        ++this.noCompiles;
        IFile file = (IFile)resource;
        this.clean(resource.getProjectRelativePath().toString());
        this.removeMarkers(resource);
        JET2CompilationUnit cu = new JET2CompilationUnit(file);
        cu.setPredefinedTagLibraries(this.predefinedLibraryMap);
        try {
            cu.parse();
            cu.accept(new TagValidationVisitor(cu));
            this.markProblems(resource, cu);
            if (!cu.hasErrors()) {
                cu.accept(new TextTrimmingVisitor());
                this.writeCompiledOutput(file, cu);
            }
        }
        catch (CoreException e) {
            this.createParseExceptionMarker(resource, e);
        }
    }

    private void removeMarkers(IResource resource) {
        try {
            resource.deleteMarkers(COMPILE_PROBLEM_MARKER, false, 2);
            resource.deleteMarkers(RUNTIME_PROBLEM_MARKER, false, 2);
        }
        catch (CoreException e) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorRemovingMarkers, (Exception)((Object)e));
        }
    }

    private void createParseExceptionMarker(IResource resource, CoreException e) {
        try {
            IMarker marker = resource.createMarker(COMPILE_PROBLEM_MARKER);
            marker.setAttribute("message", (Object)e.getStatus().getMessage());
            marker.setAttribute("priority", 2);
            marker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorCreatingMarkers, (Exception)((Object)e));
        }
    }

    private void markProblems(IResource resource, JET2CompilationUnit cu) {
        try {
            Iterator i = cu.getProblems().iterator();
            while (i.hasNext()) {
                Problem problem = (Problem)i.next();
                IMarker marker = resource.createMarker(COMPILE_PROBLEM_MARKER);
                marker.setAttribute("lineNumber", problem.getLineNumber());
                marker.setAttribute("charStart", problem.getStart());
                marker.setAttribute("charEnd", problem.getEnd());
                marker.setAttribute("message", (Object)problem.getMessage());
                marker.setAttribute("priority", 2);
                if (problem.getSeverity() == ParseProblemSeverity.ERROR) {
                    marker.setAttribute("priority", 2);
                    marker.setAttribute("severity", 2);
                    continue;
                }
                if (problem.getSeverity() == ParseProblemSeverity.WARNING) {
                    marker.setAttribute("priority", 1);
                    marker.setAttribute("severity", 1);
                    continue;
                }
                marker.setAttribute("priority", 0);
                marker.setAttribute("severity", 0);
            }
        }
        catch (CoreException e) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, (Exception)((Object)e));
        }
    }

    private void writeCompiledOutput(IFile file, JET2CompilationUnit cu) {
        this.ensureJavaOutputSet(file, cu);
        String templatePath = file.getProjectRelativePath().toString();
        String qualifiedClassName = this.makeFullyQualifiedJavaName(cu.getOutputJavaPackage(), cu.getOutputJavaClassName());
        if (templatePath.equals(this.compilerState.getTemplateFromClass(qualifiedClassName))) {
            cu.createProblem(ParseProblemSeverity.ERROR, 10, JET2Messages.JET2Compiler_SameJavaClassAsOther, new Object[]{qualifiedClassName, this.compilerState.getTemplateFromClass(qualifiedClassName)}, -1, -1, -1, -1);
        }
        String javaSrc = this.templateRunner.generate("templates/jet2java.jet", Collections.singletonMap("cu", cu));
        IFile targetFile = file.getProject().getFile(this.javaClassProjectPath(qualifiedClassName));
        try {
            this.writeFile(javaSrc, targetFile, file.getCharset());
            this.compilerState.addTemplate(templatePath, qualifiedClassName);
            this.compilerState.addTemplateTagLibraryReferences(templatePath, cu.getTagLibraryReferences());
        }
        catch (CoreException e) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, e);
        }
    }

    private boolean ensureJavaOutputSet(IFile file, JET2CompilationUnit cu) {
        boolean inferedJavaPackage = false;
        String templatePath = file.getProjectRelativePath().toString();
        String existingQualifiedClass = (String)this.compilerState.getTemplateMap().get(templatePath);
        if (existingQualifiedClass == null) {
            if (cu.getOutputJavaPackage() == null) {
                cu.setOutputJavaPackage(this.getOption(OPTION_COMPILED_TEMPLATE_PACKAGE, DEFAULT_COMPILED_TEMPLATE_PACKAGE));
                inferedJavaPackage = true;
            }
            if (cu.getOutputJavaClassName() == null) {
                String baseClassName;
                String className = baseClassName = this.makeJavaClassName(file.getFullPath().removeFileExtension().lastSegment());
                String potentialQualifiedName = this.makeFullyQualifiedJavaName(cu.getOutputJavaPackage(), className);
                int i = 0;
                while (this.compilerState.getTemplateFromClass(potentialQualifiedName) != null) {
                    className = String.valueOf(baseClassName) + "_" + i;
                    potentialQualifiedName = this.makeFullyQualifiedJavaName(cu.getOutputJavaPackage(), className);
                    ++i;
                }
                cu.setOutputJavaClassName(className);
            }
        } else {
            String existingClass;
            int index = existingQualifiedClass.lastIndexOf(46);
            String existingPackage = index == -1 ? "" : existingQualifiedClass.substring(0, index);
            String string = existingClass = index == -1 ? existingQualifiedClass : existingQualifiedClass.substring(index + 1);
            if (cu.getOutputJavaPackage() == null) {
                cu.setOutputJavaPackage(existingPackage);
            }
            if (cu.getOutputJavaClassName() == null) {
                cu.setOutputJavaClassName(existingClass);
            }
        }
        return inferedJavaPackage;
    }

    private IPath javaClassProjectPath(String javaClassName) {
        IPath targetPath = new Path(this.getSourceDirOption()).append(javaClassName.replace('.', '/')).addFileExtension("java");
        return targetPath;
    }

    private String makeFullyQualifiedJavaName(String javaPackage, String javaClassName) {
        return javaPackage == null || javaPackage.trim().length() == 0 ? javaClassName : String.valueOf(javaPackage) + '.' + javaClassName;
    }

    private void writeFile(String javaSrc, IFile targetFile, String charset) throws CoreException, UnsupportedEncodingException {
        this.ensureDirsExist(targetFile.getParent());
        if (!targetFile.exists()) {
            targetFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        }
        if (!targetFile.getCharset().equals(charset)) {
            targetFile.setCharset(charset, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        }
        targetFile.setContents((InputStream)new ByteArrayInputStream(javaSrc.getBytes(charset)), true, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        targetFile.setDerived(this.getBooleanOption(OPTION_SET_JAVA_FILES_AS_DERIVED, DEFAULT_SET_JAVA_FILES_AS_DERIVED));
    }

    private void ensureDirsExist(IContainer container) throws CoreException {
        if (container != null && !container.exists() && container.getType() == 2) {
            this.ensureDirsExist(container.getParent());
            ((IFolder)container).create(false, true, this.monitor);
        }
    }

    private String makeJavaClassName(String name) {
        StringBuffer result = new StringBuffer("_jet_");
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public void removeDerivedResources(IResource resource) throws CoreException {
        this.removeDerivedResources(resource, false);
    }

    public void removeDerivedResources(IResource resource, boolean derivedOnly) throws CoreException {
        if (!this.isJET2SourceFile(resource)) {
            return;
        }
        String javaClassName = (String)this.compilerState.getTemplateMap().get(resource.getProjectRelativePath().toString());
        if (javaClassName != null) {
            ++this.noCompiles;
            this.removeJavaClass(javaClassName, derivedOnly);
        }
    }

    private void removeJavaClass(String javaClassName, boolean derivedOnly) throws CoreException {
        IPath javaSrcFile = this.javaClassProjectPath(javaClassName);
        IFile file = this.project.getFile(javaSrcFile);
        if (file.exists() && (file.isDerived() || !derivedOnly)) {
            file.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        }
    }

    public final int getNoCompiles() {
        return this.noCompiles;
    }

    public void clean() {
        HashSet templatePathSet = new HashSet(this.compilerState.getTemplateMap().keySet());
        this.monitor.beginTask("", templatePathSet.size() + 2);
        Iterator i = templatePathSet.iterator();
        while (i.hasNext()) {
            String templatePath = (String)i.next();
            this.clean(templatePath);
        }
        if (this.templateLoaderClassName != null) {
            try {
                this.removeJavaClass(String.valueOf(this.templateLoaderPackage) + "." + this.templateLoaderClassName, true);
            }
            catch (CoreException e) {
                JETActivatorWrapper.INSTANCE.log((Object)e);
            }
        }
        this.removeMarkers((IResource)this.project);
        this.monitor.done();
    }

    private void clean(String templatePath) {
        IFile templateResource = this.project.getFile(templatePath);
        try {
            this.removeDerivedResources((IResource)templateResource, true);
            this.compilerState.removeTemplate(templatePath);
        }
        catch (CoreException e) {
            JETActivatorWrapper.INSTANCE.log((Object)e);
        }
    }

    public final IJETCompilerState getCompilerState() {
        return this.compilerState;
    }
}

