/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.internal.xpath.ast.NumberExpr;
import org.eclipse.jet.internal.xpath.functions.NumberFunction;
import org.eclipse.jet.xpath.Context;

public abstract class BinaryOp
extends NumberExpr {
    private final ExprNode left;
    private final ExprNode right;

    public BinaryOp(ExprNode left, ExprNode right) {
        this.left = left;
        this.right = right;
    }

    public final double evalAsDouble(Context context) {
        double dLeft = this.evalAsNumber(context, this.left);
        double dRight = this.evalAsNumber(context, this.right);
        return this.doEval(dLeft, dRight);
    }

    private final double evalAsNumber(Context context, ExprNode node) {
        double result = Double.NaN;
        if (node instanceof NumberExpr) {
            result = ((NumberExpr)node).evalAsDouble(context);
        } else {
            Object obj = node.evalAsObject(context);
            result = NumberFunction.evaluate(obj);
        }
        return result;
    }

    protected abstract double doEval(double var1, double var3);

    protected abstract String opName();

    public String toString() {
        return "(" + this.left.toString() + this.opName() + this.right.toString() + ")";
    }

    public static final class Add
    extends BinaryOp {
        public Add(ExprNode left, ExprNode right) {
            super(left, right);
        }

        protected double doEval(double left, double right) {
            return left + right;
        }

        protected String opName() {
            return "+";
        }
    }

    public static final class Subtract
    extends BinaryOp {
        public Subtract(ExprNode left, ExprNode right) {
            super(left, right);
        }

        protected double doEval(double left, double right) {
            return left - right;
        }

        protected String opName() {
            return " - ";
        }
    }

    public static final class Multiply
    extends BinaryOp {
        public Multiply(ExprNode left, ExprNode right) {
            super(left, right);
        }

        protected double doEval(double left, double right) {
            return left * right;
        }

        protected String opName() {
            return "*";
        }
    }

    public static final class Div
    extends BinaryOp {
        public Div(ExprNode left, ExprNode right) {
            super(left, right);
        }

        protected double doEval(double left, double right) {
            return left / right;
        }

        protected String opName() {
            return " div ";
        }
    }

    public static final class Mod
    extends BinaryOp {
        public Mod(ExprNode left, ExprNode right) {
            super(left, right);
        }

        protected double doEval(double left, double right) {
            return left % right;
        }

        protected String opName() {
            return " mod ";
        }
    }
}

