/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.compiler.LoaderGenerationParameters;

public class JET2TransformGenerator
implements JET2Template {
    private static final String NL = System.getProperty("line.separator");

    public void generate(JET2Context context, JET2Writer __out) {
        JET2Writer out = __out;
        LoaderGenerationParameters parms = (LoaderGenerationParameters)context.getVariable("args");
        Map templateMap = parms.getTemplateMap();
        out.write("package ");
        out.write(parms.getPackageName());
        out.write(";");
        out.write(NL);
        out.write(NL);
        out.write("import java.util.HashMap;");
        out.write(NL);
        out.write("import java.util.Map;");
        out.write(NL);
        out.write(NL);
        out.write("import org.eclipse.jet.JET2TemplateLoader;");
        out.write(NL);
        out.write("import org.eclipse.jet.JET2TemplateLoaderExtension;");
        out.write(NL);
        out.write("import org.eclipse.jet.JET2Template;");
        out.write(NL);
        out.write(NL);
        out.write("public class ");
        out.write(parms.getClassName());
        out.write(" implements JET2TemplateLoader, JET2TemplateLoaderExtension {");
        out.write(NL);
        out.write(NL);
        out.write("    private static final class TemplateFactoryMethod {");
        out.write(NL);
        out.write(NL);
        out.write("        private final String templatePath;");
        out.write(NL);
        out.write("        private final String templateClass;");
        out.write(NL);
        out.write(NL);
        out.write("        public TemplateFactoryMethod(String templatePath, String templateClass) {");
        out.write(NL);
        out.write("            this.templatePath = templatePath;");
        out.write(NL);
        out.write("            this.templateClass = templateClass;");
        out.write(NL);
        out.write("            ");
        out.write(NL);
        out.write("        }");
        out.write(NL);
        out.write("        ");
        out.write(NL);
        out.write("        public String getTemplateClass() {");
        out.write(NL);
        out.write("            return this.templateClass;");
        out.write(NL);
        out.write("        }");
        out.write(NL);
        out.write(NL);
        out.write("        public String getTemplatePath() {");
        out.write(NL);
        out.write("            return this.templatePath;");
        out.write(NL);
        out.write("        }");
        out.write(NL);
        out.write(NL);
        out.write("        public JET2Template newTemplate() {");
        out.write(NL);
        out.write("            JET2Template template = null;");
        out.write(NL);
        out.write("            try {");
        out.write(NL);
        out.write("                template = (JET2Template) Class.forName(this.templateClass).newInstance();");
        out.write(NL);
        out.write("            } catch (InstantiationException e) {");
        out.write(NL);
        out.write("                // ignore");
        out.write(NL);
        out.write("            } catch (IllegalAccessException e) {");
        out.write(NL);
        out.write("                // ignore");
        out.write(NL);
        out.write("            } catch (ClassNotFoundException e) {");
        out.write(NL);
        out.write("                // ignore");
        out.write(NL);
        out.write("            }");
        out.write(NL);
        out.write("            return template;");
        out.write(NL);
        out.write("        }");
        out.write(NL);
        out.write("        ");
        out.write(NL);
        out.write("        ");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write(NL);
        out.write("    private Map pathToFactoryMap = null;");
        out.write(NL);
        out.write("    ");
        out.write(NL);
        out.write("    private JET2TemplateLoader delegate = null;");
        out.write(NL);
        out.write(NL);
        out.write("    public ");
        out.write(parms.getClassName());
        out.write("() {");
        out.write(NL);
        out.write("        super();");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write(NL);
        out.write("    public JET2Template getTemplate(String templatePath) {");
        out.write(NL);
        out.write("        if(this.pathToFactoryMap == null) {");
        out.write(NL);
        out.write("            initPathToFactoryMap();");
        out.write(NL);
        out.write("        }");
        out.write(NL);
        out.write("        TemplateFactoryMethod factory = (TemplateFactoryMethod)this.pathToFactoryMap.get(templatePath);");
        out.write(NL);
        out.write("        return factory == null ? this.delegate == null ? null : this.delegate.getTemplate(templatePath) : factory.newTemplate();");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write(NL);
        out.write("    private void addTemplate(String templatePath, String templateClass) {");
        out.write(NL);
        out.write("        this.pathToFactoryMap.put(templatePath,");
        out.write(NL);
        out.write("            new TemplateFactoryMethod(templatePath, templateClass));");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write("    ");
        out.write(NL);
        out.write("    private void initPathToFactoryMap() {");
        out.write(NL);
        out.write("        this.pathToFactoryMap = new HashMap(");
        out.write(templateMap.size());
        out.write(");");
        out.write(NL);
        ArrayList templatePaths = new ArrayList(templateMap.keySet());
        Collections.sort(templatePaths);
        Iterator i = templatePaths.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)templateMap.get(key);
            out.write("            addTemplate(\"");
            out.write(key);
            out.write("\", \"");
            out.write(value);
            out.write("\" ); //$NON-NLS-1$  //$NON-NLS-2$");
            out.write(NL);
        }
        out.write("    }");
        out.write(NL);
        out.write(NL);
        out.write("    public void setDelegateLoader(JET2TemplateLoader loader) {");
        out.write(NL);
        out.write("        this.delegate = loader;");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write("    ");
        out.write(NL);
        out.write("    public JET2TemplateLoader getDelegateLoader() {");
        out.write(NL);
        out.write("        return this.delegate;");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write("}");
        out.write(NL);
        out.write(NL);
    }
}

