/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib;

import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.workspace.ActionsUtil;

public class TagUtil {
    private TagUtil() {
    }

    public static String getContents(IPath location) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
        if (file != null) {
            String encoding = file.getCharset();
            try {
                return ActionsUtil.readTextFile(file.getLocationURI().toURL(), encoding);
            }
            catch (JET2TagException e) {
                Exception cause = (Exception)e.getCause();
                throw new CoreException(InternalJET2Platform.newStatus(4, cause.getMessage(), cause));
            }
            catch (MalformedURLException e) {
                throw new CoreException(InternalJET2Platform.newStatus(4, e.getMessage(), e));
            }
        }
        throw new IllegalArgumentException(location.toString());
    }
}

