/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath;

import org.eclipse.jet.JET2Context;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.core.expressions.IEmbeddedExpression;
import org.eclipse.jet.internal.core.expressions.IEmbeddedExpressionScanner;
import org.eclipse.jet.internal.core.expressions.IEmbeddedLanguage;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.osgi.util.NLS;

public class EmbeddedXPath
implements IEmbeddedLanguage {
    public IEmbeddedExpression getExpression(final String expression) {
        return new IEmbeddedExpression(){

            public String evalAsString(JET2Context context) {
                String result = null;
                result = XPathContextExtender.getInstance(context).resolveAsString(expression);
                if (result == null) {
                    String fullExpr = "${" + expression + "}";
                    throw new JET2TagException(NLS.bind((String)"The expression {0} returned no value", (Object)fullExpr));
                }
                return result == null ? "" : result;
            }

            public String toString() {
                return "${" + expression + "}";
            }

            public boolean isText() {
                return false;
            }
        };
    }

    public IEmbeddedExpressionScanner getScanner() {
        return new XPathScanner();
    }

    public static class XPathScanner
    implements IEmbeddedExpressionScanner {
        private static State NOT_IN_STRING = new State(){

            public boolean isInXPathString() {
                return false;
            }

            public State nextState(int ch) {
                if (ch == 39) {
                    return XPathScanner.access$0();
                }
                if (ch == 34) {
                    return XPathScanner.access$1();
                }
                return this;
            }
        };
        private static State SINGLE_QUOTE_STRING = new State(){

            public boolean isInXPathString() {
                return true;
            }

            public State nextState(int ch) {
                return ch == 39 ? XPathScanner.access$2() : this;
            }
        };
        private static State POSSIBLE_ESCAPED_SINGLE_QUOTE = new State(){

            public boolean isInXPathString() {
                return true;
            }

            public State nextState(int ch) {
                return ch == 39 ? XPathScanner.access$0() : XPathScanner.access$3();
            }
        };
        private static State DOUBLE_QUOTE_STRING = new State(){

            public boolean isInXPathString() {
                return true;
            }

            public State nextState(int ch) {
                return ch == 34 ? XPathScanner.access$4() : this;
            }
        };
        private static State POSSIBLE_ESCAPED_DOUBLE_QUOTE = new State(){

            public boolean isInXPathString() {
                return true;
            }

            public State nextState(int ch) {
                return ch == 34 ? XPathScanner.access$1() : XPathScanner.access$3();
            }
        };
        private State state = NOT_IN_STRING;

        public void setNextChar(int ch) {
            this.state = this.state.nextState(ch);
        }

        public boolean ignoreChar() {
            return this.state.isInXPathString();
        }

        static /* synthetic */ State access$0() {
            return SINGLE_QUOTE_STRING;
        }

        static /* synthetic */ State access$1() {
            return DOUBLE_QUOTE_STRING;
        }

        static /* synthetic */ State access$2() {
            return POSSIBLE_ESCAPED_SINGLE_QUOTE;
        }

        static /* synthetic */ State access$3() {
            return NOT_IN_STRING;
        }

        static /* synthetic */ State access$4() {
            return POSSIBLE_ESCAPED_DOUBLE_QUOTE;
        }

        static interface State {
            public State nextState(int var1);

            public boolean isInXPathString();
        }
    }
}

