/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.transform;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.BodyContentWriter;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2TemplateLoader;
import org.eclipse.jet.JET2TemplateLoaderExtension;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.TagFactoryImpl;
import org.eclipse.jet.internal.runtime.model.TransformLoadContext;
import org.eclipse.jet.internal.runtime.model.WorkspaceLoadContext;
import org.eclipse.jet.runtime.model.ILoadContext;
import org.eclipse.jet.runtime.model.IModelLoader;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagFactory;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.eclipse.jet.transform.IJETBundleManager;
import org.eclipse.jet.transform.TransformContextListener;
import org.osgi.framework.BundleException;

public final class TransformContextExtender {
    private static String PRIVATE_CONTEXT_DATA_KEY;
    private final ContextData contextData;
    private final JET2Context context;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.transform.TransformContextExtender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PRIVATE_CONTEXT_DATA_KEY = clazz.getName();
    }

    public TransformContextExtender(JET2Context context) {
        this(context, TransformContextExtender.getInstance((JET2Context)context).contextData);
    }

    private TransformContextExtender(JET2Context context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        context.setTagFactory((TagFactory)new TagFactoryImpl(context));
    }

    public String getId() {
        return this.contextData.descriptor.getId();
    }

    public String getTemplatePath() {
        return this.contextData.templateStack.isEmpty() ? "" : (String)this.contextData.templateStack.peek();
    }

    public void execute(String templatePath, JET2Writer writer) throws JET2TagException {
        this.execute(templatePath, false, writer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeWithMonitor(String templatePath, boolean useSuper, JET2Writer writer, IProgressMonitor monitor) throws JET2TagException {
        IProgressMonitor savedMonitor = this.contextData.monitor;
        this.contextData.monitor = monitor;
        try {
            monitor.beginTask(JET2Messages.JET2Platform_ExecutingTemplates, -1);
            monitor.setTaskName(JET2Messages.JET2Platform_ExecutingTemplates);
            monitor.subTask(templatePath);
            this.doExecute(templatePath, useSuper, writer);
            this.checkCanceled();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            this.contextData.monitor = savedMonitor;
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
        this.contextData.monitor = savedMonitor;
    }

    public void checkCanceled() {
        if (this.contextData.monitor != null && this.contextData.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public boolean isCanceled() {
        return this.contextData.monitor != null && this.contextData.monitor.isCanceled();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        if (this.contextData.monitor != null) {
            throw new IllegalStateException();
        }
        this.contextData.monitor = monitor;
    }

    public void execute(String templatePath, boolean useSuper, JET2Writer writer) throws JET2TagException {
        if (this.contextData.monitor != null) {
            this.executeWithMonitor(templatePath, useSuper, writer, (IProgressMonitor)new SubProgressMonitor(this.contextData.monitor, 1));
        } else {
            this.doExecute(templatePath, useSuper, writer);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doExecute(String templatePath, boolean useSuper, JET2Writer writer) throws JET2TagException {
        this.contextData.templateStack.push(templatePath);
        this.context.setTemplatePath(this.getTemplatePath());
        try {
            JET2Template template;
            JET2TemplateLoader templateLoader = this.contextData.loader;
            if (useSuper) {
                templateLoader = templateLoader instanceof JET2TemplateLoaderExtension ? ((JET2TemplateLoaderExtension)templateLoader).getDelegateLoader() : null;
            }
            JET2Template jET2Template = template = templateLoader != null ? templateLoader.getTemplate(templatePath) : null;
            if (template == null) {
                String msg = JET2Messages.JET2Context_CouldNotFindTemplate;
                throw new JET2TagException(MessageFormat.format(msg, templatePath));
            }
            template.generate(this.context, writer);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.contextData.templateStack.pop();
            this.context.setTemplatePath(this.getTemplatePath());
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.contextData.templateStack.pop();
        }
        this.context.setTemplatePath(this.getTemplatePath());
    }

    public JET2TemplateLoader getLoader() {
        return this.contextData.loader;
    }

    public void setLoader(JET2TemplateLoader loader) {
        if (this.contextData.loader != null) {
            throw new IllegalStateException("loader already set");
        }
        this.contextData.loader = loader;
    }

    public void addListener(TransformContextListener listener) {
        if (!this.contextData.listeners.contains(listener)) {
            this.contextData.listeners.add(listener);
        }
    }

    public void removeListener(TransformContextListener listener) {
        this.contextData.listeners.remove(listener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(IProgressMonitor monitor) {
        monitor.beginTask(JET2Messages.JET2Context_CommittingActions, this.contextData.listeners.size());
        try {
            Iterator i = this.contextData.listeners.iterator();
            while (i.hasNext()) {
                this.checkCanceled();
                TransformContextListener listener = (TransformContextListener)i.next();
                try {
                    listener.commit(this.context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (JET2TagException e) {
                    this.context.logError((Throwable)e);
                }
                monitor.worked(1);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    public final Object getShellContext() {
        return this.contextData.shellContext;
    }

    public final void setShellContext(Object shellContext) {
        if (this.contextData.shellContext != null) {
            throw new IllegalStateException("shellContext already set");
        }
        this.contextData.shellContext = shellContext;
    }

    public void setBundleDescriptor(IJETBundleDescriptor descriptor) {
        if (this.contextData.descriptor != null) {
            throw new IllegalStateException();
        }
        this.contextData.descriptor = descriptor;
        this.context.setJETBundleId(descriptor.getId());
    }

    public IJETBundleDescriptor getBundleDescriptor() {
        return this.contextData.descriptor;
    }

    public URL getBaseURL(String urlContext) throws JET2TagException {
        ILoadContext definedContext = null;
        if (urlContext == null || "transform".equalsIgnoreCase(urlContext)) {
            try {
                definedContext = new TransformLoadContext(this.getBundleDescriptor().getBaseURL());
            }
            catch (MalformedURLException e) {
                throw new JET2TagException((Throwable)e);
            }
        } else if ("workspace".equalsIgnoreCase(urlContext)) {
            definedContext = new WorkspaceLoadContext();
        } else {
            String msg = JET2Messages.LoadTag_UnknownSrcContext;
            throw new JET2TagException(MessageFormat.format(msg, urlContext));
        }
        URL baseURL = definedContext.getContextUrl();
        return baseURL;
    }

    public static TransformContextExtender getInstance(JET2Context context) {
        if (context == null) {
            throw new NullPointerException();
        }
        TransformContextExtender ex = (TransformContextExtender)context.getPrivateData(PRIVATE_CONTEXT_DATA_KEY);
        if (ex == null) {
            ex = new TransformContextExtender(context, new ContextData());
            context.addPrivateData(PRIVATE_CONTEXT_DATA_KEY, (Object)ex);
        }
        return ex;
    }

    public static Object loadModel(URL modelURL, String modelLoaderID, String fileType) throws IOException, CoreJETException {
        IModelLoader loader = JETActivatorWrapper.INSTANCE.getLoaderManager().getLoader(modelURL.toExternalForm(), modelLoaderID, fileType);
        Object source = fileType == null ? loader.load(modelURL) : loader.load(modelURL, fileType);
        return source;
    }

    public static Object loadModelFromString(String modelContent, String modelLoaderID, String fileType) throws CoreJETException, IOException {
        IModelLoader loader = JETActivatorWrapper.INSTANCE.getLoaderManager().getLoader(null, modelLoaderID, fileType);
        Object source = loader.loadFromString(modelContent, fileType);
        return source;
    }

    public void setOverride(String id, IProgressMonitor monitor) throws JET2TagException {
        IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
        try {
            bundleManager.connect(id, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
            this.contextData.connectedTransforms.add(id);
            JET2TemplateLoader delegateLoader = bundleManager.getTemplateLoader(id);
            JET2TemplateLoader loader = this.getLoader();
            if (!(loader instanceof JET2TemplateLoaderExtension)) {
                String msg = JET2Messages.TransformContextExtender_NeedsRebuildForOverride;
                throw new JET2TagException(MessageFormat.format(msg, this.getId()));
            }
            JET2TemplateLoaderExtension ext = (JET2TemplateLoaderExtension)loader;
            ext.setDelegateLoader(delegateLoader);
        }
        catch (BundleException e) {
            throw new JET2TagException((Throwable)e);
        }
    }

    public void cleanup() {
        IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
        Iterator i = this.contextData.connectedTransforms.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            bundleManager.disconnect(id);
        }
    }

    public void runSubTransform(String id) throws JET2TagException {
        this.runSubTransform(id, new BodyContentWriter());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runSubTransform(String id, BodyContentWriter writer) throws JET2TagException {
        IJETBundleManager bundleManager = JET2Platform.getJETBundleManager();
        IJETBundleDescriptor savedDescriptor = this.contextData.descriptor;
        JET2TemplateLoader savedLoader = this.contextData.loader;
        try {
            try {
                bundleManager.connect(id, (IProgressMonitor)new NullProgressMonitor());
                this.contextData.connectedTransforms.add(id);
                JET2TemplateLoader loader = bundleManager.getTemplateLoader(id);
                IJETBundleDescriptor descriptor = bundleManager.getDescriptor(id);
                this.contextData.loader = loader;
                this.contextData.descriptor = descriptor;
                if (descriptor.getOverridesId() != null) {
                    this.setOverride(descriptor.getOverridesId(), (IProgressMonitor)new NullProgressMonitor());
                }
                this.execute(descriptor.getMainTemplate(), (JET2Writer)writer);
            }
            catch (BundleException e) {
                throw new JET2TagException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.contextData.descriptor = savedDescriptor;
            this.contextData.loader = savedLoader;
            throw throwable;
        }
        {
            Object var8_11 = null;
            this.contextData.descriptor = savedDescriptor;
            this.contextData.loader = savedLoader;
            return;
        }
    }

    private static final class ContextData {
        public final Stack templateStack = new Stack();
        public JET2TemplateLoader loader;
        public List listeners = new ArrayList();
        public Object shellContext = null;
        public IJETBundleDescriptor descriptor = null;
        public final List connectedTransforms = new ArrayList();
        public IProgressMonitor monitor;

        private ContextData() {
        }
    }
}

