/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath;

import org.eclipse.jet.internal.xpath.NodeSetImpl;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.internal.xpath.functions.BooleanFunction;
import org.eclipse.jet.internal.xpath.functions.NumberFunction;
import org.eclipse.jet.internal.xpath.functions.StringFunction;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.IAnnotationManager;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.XPathExpression;
import org.eclipse.jet.xpath.XPathFunctionResolver;
import org.eclipse.jet.xpath.XPathVariableResolver;

public class XPathExpressionImpl
implements XPathExpression {
    private final ExprNode node;
    private final XPathVariableResolver variableResolver;
    private final IAnnotationManager annotationManager;
    private final XPathFunctionResolver functionResolver;

    public XPathExpressionImpl(ExprNode node, XPathVariableResolver variableResolver, XPathFunctionResolver functionResolver, IAnnotationManager annotationManager) {
        this.node = node;
        this.variableResolver = variableResolver;
        this.functionResolver = functionResolver;
        this.annotationManager = annotationManager;
    }

    public Object evaluate(Object contextObject) {
        return this.node.evalAsObject(new Context(contextObject, this.variableResolver, this.annotationManager, this.functionResolver));
    }

    public String evaluateAsString(Object contextObject) {
        return StringFunction.evaluate(this.evaluate(contextObject));
    }

    public boolean evaluateAsBoolean(Object contextObject) {
        return BooleanFunction.evaluate(this.evaluate(contextObject));
    }

    public double evaluateAsNumber(Object contextObject) {
        return NumberFunction.evaluate(this.evaluate(contextObject));
    }

    public NodeSet evaluateAsNodeSet(Object contextObject) {
        Object result = this.evaluate(contextObject);
        if (result instanceof NodeSet) {
            return (NodeSet)result;
        }
        return NodeSetImpl.EMPTY_SET;
    }

    public Object evaluateAsSingleNode(Object contextObject) {
        NodeSet nodeSet = this.evaluateAsNodeSet(contextObject);
        return nodeSet.size() > 0 ? nodeSet.iterator().next() : null;
    }

    public String toString() {
        return this.node.toString();
    }
}

