/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.compiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.compiler.BackendCompilerFacade;
import org.eclipse.xtend.backend.compiler.FdcHolder;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.MiddleEndFactory;
import org.eclipse.xtend.middleend.NoMiddleEndForResourceException;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBackendCompilerFacade
implements BackendCompilerFacade {
    private static final Log _log = LogFactory.getLog(AbstractBackendCompilerFacade.class);
    protected BackendTypesystem _typeSystem;
    protected List<LanguageSpecificMiddleEnd> _languageHandlers;

    public AbstractBackendCompilerFacade(BackendTypesystem typeSystem) {
        this._typeSystem = typeSystem;
    }

    @Override
    public void compile(Collection<String> resources, String contributorNamespace, String contributorName, String outputDir, Map<Class<?>, Object> specificParams, String fileEncoding) {
        MiddleEnd me = this.createMiddleEnd(specificParams);
        HashMap<String, FunctionDefContext> fdcs = new HashMap<String, FunctionDefContext>();
        for (String res : resources) {
            try {
                _log.debug((Object)("Creating FDC for " + res));
                FunctionDefContext fdc = me.getFunctions(res);
                for (NamedFunction f : fdc.getAllFunctions()) {
                    _log.debug((Object)("Function " + f.getName()));
                }
                fdcs.put(res, fdc);
            }
            catch (NoMiddleEndForResourceException noMiddleEndForResourceException) {
                // empty catch block
            }
        }
        FdcHolder fdcHolder = new FdcHolder(fdcs);
        this.compileInternal(fdcHolder, this._typeSystem, contributorNamespace, contributorName, outputDir, fileEncoding);
    }

    protected abstract void compileInternal(FdcHolder var1, BackendTypesystem var2, String var3, String var4, String var5, String var6);

    protected MiddleEnd createMiddleEnd(Map<Class<?>, Object> specificParams) {
        if (MiddleEndFactory.canCreateFromExtentions()) {
            return MiddleEndFactory.createFromExtensions((BackendTypesystem)this._typeSystem, specificParams);
        }
        return MiddleEndFactory.create((BackendTypesystem)this._typeSystem, this._languageHandlers);
    }
}

