/*
Copyright (c) 2008 Arno Haase.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html

Contributors:
    Arno Haase - initial API and implementation
 */
package org.eclipse.xtend.backend.types.builtin;

import java.util.HashSet;

import org.eclipse.xtend.backend.types.AbstractType;


/**
 * 
 * @author Arno Haase (http://www.haase-consulting.com)
 */
public final class SetType extends AbstractType {
    private SetType () {
        super ("Set", "{builtin}Set", CollectionType.INSTANCE);
    }
    
    public static final SetType INSTANCE = new SetType ();
    
    @Override
    public Object create() {
        return new HashSet<Object>();
    }

    @Override
    public boolean equals (Object other) {
        return other == this;
    }
}
