/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaCompositor;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xtend.typesystem.xsd.builder.OawXSDEcoreBuilder;
import org.eclipse.xtend.typesystem.xsd.builder.OawXSDResourceSet;
import org.eclipse.xtend.typesystem.xsd.util.Msg;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OawXSDResource
extends XSDResourceImpl {
    protected OawXSDEcoreBuilder builder;
    private EPackage ePackage = null;
    private boolean fileDirty = true;
    private boolean generatePackage = false;
    protected Log log = XSDLog.getLog(((Object)((Object)this)).getClass());
    private boolean schemaDirty = true;

    public OawXSDResource(URI uri) {
        super(uri);
    }

    private void collectImportedSchemas(Set<OawXSDResource> visited, List<OawXSDResource> list) {
        if (visited.contains((Object)this) || this.getSchema() == null) {
            return;
        }
        visited.add(this);
        for (XSDSchemaContent c : this.getSchema().getContents()) {
            if (!(c instanceof XSDSchemaDirective)) continue;
            XSDSchema s = ((XSDSchemaDirective)c).getResolvedSchema();
            if (s != null) {
                OawXSDResource res = (OawXSDResource)s.eResource();
                if (c instanceof XSDImport) {
                    list.add(res);
                    continue;
                }
                if (!(c instanceof XSDSchemaCompositor)) continue;
                res.collectImportedSchemas(visited, list);
                continue;
            }
            this.log.warn((Object)Msg.create("Include ").path((EObject)c).txt(" ").uri(((XSDSchemaDirective)c).getSchemaLocation()).txt(" has not been resolved. ").schema(this.getSchema()));
        }
    }

    public void collectPackages(Set<EPackage> pkgs, Set<OawXSDResource> res) {
        if (res.contains((Object)this)) {
            return;
        }
        res.add(this);
        if (this.ePackage != null) {
            pkgs.add(this.ePackage);
        }
        for (OawXSDResource r : this.findImportedSchemas()) {
            r.collectPackages(pkgs, res);
        }
    }

    protected void doLoad(InputSource inputSource, Map<?, ?> options) throws IOException {
        super.doLoad(inputSource, options);
        this.fileDirty = false;
        this.resolveImports();
        this.markSchemaDirty();
        this.logDiagnostics(this.getSchema());
        this.logResDiagnostics();
    }

    protected void doUnload() {
        this.log.info((Object)Msg.create("Unloading ").schema(this.getSchema()));
        this.unloadReferrencingDirectives();
        super.doUnload();
        this.unloadPackage();
    }

    protected List<OawXSDResource> findImportedSchemas() {
        ArrayList<OawXSDResource> list = new ArrayList<OawXSDResource>();
        this.collectImportedSchemas(new HashSet<OawXSDResource>(), list);
        return list;
    }

    protected List<OawXSDResource> findReferencingSchemas() {
        if (this.getSchema() == null) {
            return Collections.emptyList();
        }
        ArrayList<OawXSDResource> r = new ArrayList<OawXSDResource>();
        for (XSDSchemaDirective s : this.getSchema().getReferencingDirectives()) {
            r.add((OawXSDResource)s.eResource());
        }
        return r;
    }

    public OawXSDEcoreBuilder generateECore() {
        if (this.builder != null) {
            return this.builder;
        }
        this.builder = new OawXSDEcoreBuilder(this.getResourceSet().extendedMetadata);
        for (OawXSDResource r : this.findImportedSchemas()) {
            this.builder.copy(r.generateECore());
        }
        if (this.getSchema() == null) {
            this.log.error((Object)Msg.create("Schema of file ").uri((Resource)this).txt(" has not yet been loaded, but the generating of EPackage has been requested."));
        } else {
            this.builder.generate(this.getSchema());
            this.logDiagnostics(this.getSchema());
        }
        return this.builder;
    }

    public EPackage getEPackage() {
        return this.ePackage;
    }

    public OawXSDResourceSet getResourceSet() {
        return (OawXSDResourceSet)super.getResourceSet();
    }

    public boolean isEcorePackageGenerated() {
        return this.ePackage != null;
    }

    public boolean isFileDirty() {
        return this.fileDirty;
    }

    public boolean isGeneratePackage() {
        return this.generatePackage;
    }

    public boolean isSchemaDirty() {
        return this.schemaDirty;
    }

    private void logDiagnostics(XSDSchema schema) {
        if (schema.getAllDiagnostics().isEmpty()) {
            schema.validate();
        }
        for (XSDDiagnostic d : schema.getAllDiagnostics()) {
            switch (d.getSeverity()) {
                case ERROR_LITERAL: {
                    this.log.error((Object)Msg.create("XSDDiagnostic: ").diag(d));
                    break;
                }
                case FATAL_LITERAL: {
                    this.log.equals(Msg.create("FATAL: XSDDiagnostic: ").diag(d));
                    break;
                }
                case INFORMATION_LITERAL: {
                    this.log.info((Object)Msg.create("XSDDiagnostic: ").diag(d));
                    break;
                }
                case WARNING_LITERAL: {
                    this.log.warn((Object)Msg.create("XSDDiagnostic: ").diag(d));
                }
            }
        }
        schema.clearDiagnostics();
    }

    private void logResDiagnostics() {
        for (Resource.Diagnostic d : this.getErrors()) {
            this.log.error((Object)Msg.create("Diagnostic: ").diag(d));
        }
        for (Resource.Diagnostic d : this.getWarnings()) {
            this.log.warn((Object)Msg.create("Diagnostic: ").diag(d));
        }
    }

    public void markFileDirty() {
        if (this.fileDirty) {
            return;
        }
        this.fileDirty = true;
        for (OawXSDResource r : this.findReferencingSchemas()) {
            r.markFileDirty();
        }
    }

    public void markSchemaDirty() {
        if (this.schemaDirty) {
            return;
        }
        this.schemaDirty = true;
        for (OawXSDResource r : this.findReferencingSchemas()) {
            r.markSchemaDirty();
        }
    }

    protected void resolveImports() {
        for (Object content : this.getSchema().getContents()) {
            if (!(content instanceof XSDImport)) continue;
            XSDImport imp = (XSDImport)content;
            imp.resolveTypeDefinition(imp.getNamespace(), "");
        }
    }

    public void setEcorePackage(EPackage pkg) {
        if (this.ePackage == pkg) {
            return;
        }
        if (this.ePackage != null) {
            this.log.warn((Object)Msg.create("Overwriting ").pkg(this.ePackage).txt(" with ").pkg(pkg));
        }
        this.ePackage = pkg;
        this.schemaDirty = false;
        String ns = this.getSchema().getTargetNamespace() == null || this.getSchema().getTargetNamespace().equals("") ? null : pkg.getNsURI();
        this.getResourceSet().getPackageRegistry().put((Object)ns, (Object)pkg);
    }

    public void setGeneratePackage(boolean generatePackage) {
        this.generatePackage = generatePackage;
    }

    public void unloadPackage() {
        this.getResourceSet().getPackageRegistry().remove((Object)this.ePackage);
        this.ePackage = null;
        this.builder = null;
    }

    protected void unloadReferrencingDirectives() {
        XSDSchema s = this.getSchema();
        if (s == null) {
            return;
        }
        for (XSDSchemaContent c : s.getContents()) {
            XSDSchemaDirective sd;
            if (!(c instanceof XSDSchemaDirective) || (sd = (XSDSchemaDirective)c).getResolvedSchema() == null) continue;
            sd.getResolvedSchema().getReferencingDirectives().remove((Object)sd);
        }
    }

    public static class OawXSDResourceFactory
    extends ResourceFactoryImpl {
        public Resource createResource(URI uri) {
            return new OawXSDResource(uri);
        }
    }
}

