/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableReader;
import prefuse.data.io.DataIOException;
import prefuse.data.io.TableReadListener;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ParserFactory;
import prefuse.data.parser.TypeInferencer;
import prefuse.util.collections.ByteArrayList;
import prefuse.util.io.IOLib;

public abstract class AbstractTextTableReader
extends AbstractTableReader {
    private ParserFactory m_pfactory;
    private boolean m_hasHeader;

    public AbstractTextTableReader() {
        this(ParserFactory.getDefaultFactory());
    }

    public AbstractTextTableReader(ParserFactory parserFactory) {
        this.m_pfactory = parserFactory;
        this.m_hasHeader = true;
    }

    public void setHasHeader(boolean hasHeaderRow) {
        this.m_hasHeader = hasHeaderRow;
    }

    public Table readTable(InputStream is) throws DataIOException {
        ByteArrayList buf = null;
        if (is.markSupported()) {
            is.mark(Integer.MAX_VALUE);
        } else {
            try {
                buf = IOLib.readAsBytes(is);
            }
            catch (IOException ioe) {
                throw new DataIOException(ioe);
            }
            is = buf.getAsInputStream();
        }
        final TypeInferencer di = new TypeInferencer(this.m_pfactory);
        final ArrayList headers = this.getColumnNames();
        final int[] dim = new int[2];
        TableReadListener scanner = new TableReadListener(){
            int prevLine = -1;

            public void readValue(int line, int col, String value) throws DataParseException {
                if (line > 1 || !AbstractTextTableReader.this.m_hasHeader) {
                    di.sample(col - 1, value);
                    if (line != this.prevLine) {
                        this.prevLine = line;
                        dim[0] = dim[0] + 1;
                    }
                } else if (line == 1 && AbstractTextTableReader.this.m_hasHeader) {
                    headers.add(value);
                }
                if (col > dim[1]) {
                    dim[1] = col;
                }
            }
        };
        try {
            this.read(is, scanner);
        }
        catch (IOException ioe) {
            throw new DataIOException(ioe);
        }
        catch (DataParseException ioe) {
            // empty catch block
        }
        int nrows = dim[0];
        int ncols = dim[1];
        final Table table = new Table(nrows, ncols);
        int i = 0;
        while (i < ncols) {
            String header = this.m_hasHeader || i < headers.size() ? (String)headers.get(i) : AbstractTextTableReader.getDefaultHeader(i);
            table.addColumn(header, di.getType(i));
            table.getColumn(i).setParser(di.getParser(i));
            ++i;
        }
        dim[1] = -1;
        dim[0] = -1;
        TableReadListener parser = new TableReadListener(){
            int prevLine = -1;

            public void readValue(int line, int col, String value) throws DataParseException {
                if (line == 1 && AbstractTextTableReader.this.m_hasHeader) {
                    return;
                }
                if (line != this.prevLine) {
                    this.prevLine = line;
                    dim[0] = dim[0] + 1;
                }
                dim[1] = col - 1;
                DataParser dp = di.getParser(dim[1]);
                table.set(dim[0], dim[1], dp.parse(value));
            }
        };
        try {
            if (is.markSupported()) {
                is.reset();
            } else {
                is = buf.getAsInputStream();
            }
            this.read(is, parser);
        }
        catch (IOException ioe) {
            throw new DataIOException(ioe);
        }
        catch (DataParseException de) {
            throw new DataIOException("Parse exception for column \"" + dim[1] + '\"' + " at row: " + dim[0], de);
        }
        return table;
    }

    protected ArrayList getColumnNames() {
        return new ArrayList();
    }

    public static String getDefaultHeader(int idx) {
        if (idx == 0) {
            return "A";
        }
        int len = (int)(Math.log(idx) / Math.log(26.0)) + 1;
        char[] h = new char[len];
        int p = len;
        h[--p] = (char)(65 + idx % 26);
        idx /= 26;
        while (idx > 26) {
            h[--p] = (char)(65 + idx % 26);
            idx /= 26;
        }
        if (idx > 0) {
            h[--p] = (char)(65 + (idx - 1) % 26);
        }
        return new String(h, p, len);
    }

    protected abstract void read(InputStream var1, TableReadListener var2) throws IOException, DataParseException;
}

