/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay;

import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.data.DiscovererParameterDisplay;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay.ColumnViewerSorter;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay.ParametersTableContentProvider;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay.ParametersTableEditingSupport;
import org.eclipse.modisco.infra.discovery.ui.internal.util.DiscovererParameterDescriptionTooltip;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ParametersTableComposite
extends Composite {
    private static final int VALUE_MINIMUM_WIDTH = 100;
    private static final int VALUE_WEIGHT = 35;
    private static final int REQUIRED_MINIMUM_WIDTH = 50;
    private static final int REQUIRED_WEIGHT = 10;
    private static final int TYPE_MINIMUM_WIDTH = 50;
    private static final int TYPE_WEIGHT = 30;
    private static final int NAME_MINIMUM_WIDTH = 100;
    private static final int NAME_WEIGHT = 25;
    protected static final int VALUE_COLUMN_INDEX = 1;
    private TableViewer tableViewer = null;
    private ParametersTableContentProvider contentProvider = null;
    private ParametersTableEditingSupport editingSupport = null;
    private ColumnViewerSorter sorter = null;
    private final boolean editable;

    public ParametersTableComposite(Composite parent, int style, List<DiscovererParameterDisplay> discoveryParameters, boolean editable) {
        super(parent, style);
        this.editable = editable;
        this.initialize();
        this.initializeTableProviders();
        this.initializeTableContents(discoveryParameters);
    }

    private final void initializeTableContents(List<DiscovererParameterDisplay> discoveryParameters) {
        DiscovererParameterDisplay[] parameters = new DiscovererParameterDisplay[discoveryParameters.size()];
        discoveryParameters.toArray(parameters);
        this.tableViewer.setInput((Object)parameters);
    }

    private final void initialize() {
        this.tableViewer = new TableViewer((Composite)this, 68096);
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessVerticalSpace = true;
        this.tableViewer.getTable().setLayoutData((Object)gridData1);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.setLayout((Layout)columnLayout);
        TableViewerColumn columnName = new TableViewerColumn(this.tableViewer, 0);
        columnName.getColumn().setText(Messages.ParametersTableComposite_name);
        columnName.getColumn().setMoveable(true);
        columnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DiscovererParameterDisplay)element).getParameterDescription().getId();
            }
        });
        this.sorter = new ColumnViewerSorter((ColumnViewer)this.tableViewer, columnName);
        columnLayout.setColumnData((Widget)columnName.getColumn(), (ColumnLayoutData)new ColumnWeightData(25, 100));
        if (this.editable) {
            TableViewerColumn columnValue = new TableViewerColumn(this.tableViewer, 0);
            columnValue.getColumn().setText(Messages.ParametersTableComposite_value);
            columnValue.getColumn().setMoveable(true);
            columnValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    String result = null;
                    if (((DiscovererParameterDisplay)element).getValue() != null) {
                        result = ((DiscovererParameterDisplay)element).getValue().toString();
                    }
                    return result;
                }
            });
            this.editingSupport = new ParametersTableEditingSupport(this.tableViewer);
            columnValue.setEditingSupport((EditingSupport)this.editingSupport);
            columnLayout.setColumnData((Widget)columnValue.getColumn(), (ColumnLayoutData)new ColumnWeightData(35, 100));
        }
        if (this.editable) {
            TableViewerColumn columnRequired = new TableViewerColumn(this.tableViewer, 0);
            columnRequired.getColumn().setText(Messages.ParametersTableComposite_usage);
            columnRequired.getColumn().setMoveable(true);
            columnRequired.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    String result = null;
                    result = ((DiscovererParameterDisplay)element).getParameterDescription().isRequiredInput() ? Messages.ParametersTableComposite_required : Messages.ParametersTableComposite_optional;
                    return result;
                }
            });
            columnLayout.setColumnData((Widget)columnRequired.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 50));
        }
        TableViewerColumn columnType = new TableViewerColumn(this.tableViewer, 0);
        columnType.getColumn().setText(Messages.ParametersTableComposite_type);
        columnType.getColumn().setMoveable(true);
        columnType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = null;
                if (((DiscovererParameterDisplay)element).getParameterDescription().getType() != null) {
                    result = ((DiscovererParameterDisplay)element).getParameterDescription().getType().getName();
                }
                return result;
            }
        });
        columnLayout.setColumnData((Widget)columnType.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 50));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    IStructuredSelection selection = (IStructuredSelection)ParametersTableComposite.this.tableViewer.getSelection();
                    Object firstElement = selection.getFirstElement();
                    ParametersTableComposite.this.tableViewer.editElement(firstElement, 1);
                }
            }
        });
        ParametersTableComposite.createDescriptionTooltip(this.tableViewer.getTable());
    }

    private static void createDescriptionTooltip(final Table table) {
        DiscovererParameterDescriptionTooltip tooltip = new DiscovererParameterDescriptionTooltip(table){

            @Override
            protected DiscovererParameter getDiscovererParameterAt(Event event) {
                TableItem item = table.getItem(new Point(event.x, event.y));
                if (item == null) {
                    return null;
                }
                DiscovererParameterDisplay parameter = (DiscovererParameterDisplay)item.getData();
                if (parameter == null) {
                    return null;
                }
                return parameter.getParameterDescription();
            }
        };
        tooltip.activate();
    }

    private final void initializeTableProviders() {
        this.contentProvider = new ParametersTableContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    public void updateDisplayParameters(List<DiscovererParameterDisplay> discoveryParameters) {
        this.initializeTableContents(discoveryParameters);
        this.tableViewer.refresh();
        this.setSize(this.tableViewer.getTable().getSize());
        this.pack();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public ParametersTableEditingSupport getEditingSupport() {
        return this.editingSupport;
    }
}

