/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.tests;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.internal.delegate.OCLValidationDelegateMapping;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.internal.delegate.ValidationDelegate;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.GlobalEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.utilities.PivotDiagnostician;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.DebugTimestamp;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotStandaloneSetup;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.validation.ValidationContext;
import org.eclipse.ocl.pivot.validation.ValidationRegistryAdapter;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.pivot.values.Value;
import org.eclipse.ocl.xtext.base.BaseStandaloneSetup;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.ocl.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.ocl.xtext.idioms.IdiomsStandaloneSetup;
import org.eclipse.ocl.xtext.markup.MarkupStandaloneSetup;
import org.eclipse.ocl.xtext.oclinecore.OCLinEcoreStandaloneSetup;
import org.eclipse.ocl.xtext.oclstdlib.OCLstdlibStandaloneSetup;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.Rule;
import org.junit.rules.TestName;

public class PivotTestCase
extends TestCase {
    public static final @NonNull String @NonNull [] NO_MESSAGES = new String[0];
    public static final @NonNull String @NonNull [] SUPPRESS_VALIDATION = new String[]{"FIXME"};
    public static final @NonNull String PLUGIN_ID = "org.eclipse.ocl.examples.xtext.tests";
    public static final @NonNull TracingOption TEST_START = new TracingOption("org.eclipse.ocl.examples.xtext.tests", "test/start");
    private static Writer testLog = null;
    public static boolean DEBUG_GC = false;
    public static boolean DEBUG_ID = false;
    @Rule
    public TestName testName = new TestName();
    private GlobalStateMemento makeCopyOfGlobalState = null;

    protected static void appendChildren(StringBuilder s, List<Diagnostic> children, int depth) {
        for (Diagnostic child : children) {
            s.append("\n");
            int i = 0;
            while (i < depth) {
                s.append("    ");
                ++i;
            }
            s.append(child.getMessage());
            PivotTestCase.appendChildren(s, child.getChildren(), depth + 1);
        }
    }

    public static void appendLog(String name, Object context, String testExpression, String parseVerdict, String evaluationVerdict, String evaluationTolerance) {
        if (testLog != null) {
            try {
                testLog.append("\"" + name.replace("\"", "\"\"") + "\"");
                testLog.append(";");
                try {
                    if (context instanceof EObject) {
                        URI contextURI = EcoreUtil.getURI((EObject)((EObject)context));
                        testLog.append("\"" + contextURI.toString().replace("\"", "\"\"") + "\"");
                    }
                }
                catch (Throwable e) {
                    testLog.append("\"null\"");
                }
                testLog.append(";");
                if (testExpression != null) {
                    testLog.append("\"" + StringUtil.convertToOCLString((String)testExpression) + "\"");
                }
                testLog.append(";");
                if (parseVerdict != null) {
                    testLog.append("\"" + StringUtil.convertToOCLString((String)parseVerdict) + "\"");
                }
                testLog.append(";");
                if (evaluationVerdict != null) {
                    testLog.append("\"" + StringUtil.convertToOCLString((String)evaluationVerdict) + "\"");
                }
                testLog.append(";");
                if (evaluationTolerance != null) {
                    testLog.append("\"" + evaluationTolerance.replace("\"", "\"\"") + "\"");
                }
                testLog.append("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static @NonNull XtextResource as2cs(@NonNull OCL ocl, @NonNull ASResource asResource, @NonNull URI outputURI) throws IOException {
        @NonNull ResourceSet resourceSet = ocl.getResourceSet();
        XtextResource xtextResource = (XtextResource)ClassUtil.nonNullState((Object)((XtextResource)resourceSet.createResource(outputURI, "org.eclipse.ocl.xtext.oclinecore")));
        ocl.as2cs(asResource, (CSResource)xtextResource);
        PivotTestCase.assertNoResourceErrors("Conversion failed", (Resource)xtextResource);
        URI savedURI = (URI)ClassUtil.nonNullState((Object)asResource.getURI());
        if (asResource.isSaveable()) {
            asResource.setURI(outputURI.trimFileExtension().trimFileExtension().appendFileExtension("oclas"));
            asResource.save(null);
            asResource.setURI(savedURI);
        }
        PivotTestCase.assertNoDiagnosticErrors("Concrete Syntax validation failed", xtextResource);
        try {
            DebugTimestamp debugTimestamp = new DebugTimestamp((String)ClassUtil.nonNullState((Object)xtextResource.getURI().toString()));
            xtextResource.save(null);
            debugTimestamp.log("Serialization save done");
        }
        catch (Exception e) {
            e.printStackTrace();
            URI xmiURI = outputURI.appendFileExtension(".xmi");
            Resource xmiResource = resourceSet.createResource(xmiURI);
            xmiResource.getContents().addAll((Collection)xtextResource.getContents());
            xmiResource.save(null);
            throw e;
        }
        return xtextResource;
    }

    public static @NonNull Resource as2ecore(@NonNull EnvironmentFactory environmentFactory, @NonNull Resource asResource, @NonNull URI ecoreURI, @NonNull String @NonNull [] asValidationMessages) throws IOException {
        assert (ThreadLocalExecutor.basicGetEnvironmentFactory() == environmentFactory);
        XMLResource ecoreResource = AS2Ecore.createResource((EnvironmentFactoryInternal)((EnvironmentFactoryInternal)environmentFactory), (Resource)asResource, (URI)ecoreURI, null);
        ecoreResource.save(null);
        if (asValidationMessages != SUPPRESS_VALIDATION) {
            PivotTestCase.assertValidationDiagnostics("AS2Ecore invalid", (Resource)ecoreResource, asValidationMessages);
        }
        return ecoreResource;
    }

    @Deprecated
    public static @NonNull List<Diagnostic> assertDiagnostics(@NonNull String prefix, @NonNull List<Diagnostic> diagnostics, String ... messages) {
        return PivotTestCase.assertDiagnostics(prefix, null, diagnostics, messages);
    }

    /*
     * Unable to fully structure code
     */
    public static @NonNull List<Diagnostic> assertDiagnostics(@NonNull String prefix, @Nullable Resource resource, @NonNull List<Diagnostic> diagnostics, String ... messages) {
        expected = new HashMap<String, Integer>();
        var8_5 = messages;
        var7_6 = messages.length;
        var6_8 = 0;
        while (var6_8 < var7_6) {
            message = var8_5[var6_8];
            count = (Integer)expected.get(message);
            count = count == null ? 1 : count + 1;
            expected.put(message, count);
            ++var6_8;
        }
        s1 = null;
        for (Diagnostic diagnostic : diagnostics) {
            actual = diagnostic.getMessage();
            expectedCount = (Integer)expected.get(actual);
            if (expectedCount == null || expectedCount <= 0) {
                if (s1 == null) {
                    s1 = new StringBuilder();
                    s1.append("\nUnexpected errors");
                    if (resource != null) {
                        s1.append(" in '");
                        s1.append(resource.getURI());
                        s1.append("'");
                    }
                }
                s1.append("\n");
                s1.append(actual);
                continue;
            }
            expected.put(actual, expectedCount - 1);
        }
        s2 = null;
        for (String key : expected.keySet()) {
            count = (Integer)expected.get(key);
            if (PivotTestCase.$assertionsDisabled || count != null) ** GOTO lbl57
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                if (s2 == null) {
                    s2 = new StringBuilder();
                    s2.append("\nMissing errors");
                    if (resource != null) {
                        s2.append(" in '");
                        s2.append(resource.getURI());
                        s2.append("'");
                    }
                }
                s2.append("\n");
                s2.append(key);
lbl57:
                // 2 sources

                v0 = count;
                count = v0 - 1;
                ** while (v0.intValue() > 0)
            }
lbl60:
            // 1 sources

        }
        if (s1 == null) {
            if (s2 != null) {
                PivotTestCase.fail((String)s2.toString());
            }
        } else if (s2 == null) {
            PivotTestCase.fail((String)s1.toString());
        } else {
            PivotTestCase.fail((String)(String.valueOf(s1.toString()) + s2.toString()));
        }
        return diagnostics;
    }

    public static void assertNoDiagnosticErrors(@NonNull String message, @NonNull XtextResource xtextResource) {
        List diagnostics = xtextResource.validateConcreteSyntax();
        if (diagnostics.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(message);
            for (Diagnostic diagnostic : diagnostics) {
                s.append("\n");
                s.append(diagnostic.toString());
            }
            PivotTestCase.fail((String)s.toString());
        }
    }

    public static void assertNoResourceErrors(@NonNull String prefix, @NonNull Resource resource) {
        String message = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)resource.getErrors())), (String)prefix, (String)"\n\t");
        if (message != null) {
            PivotTestCase.fail((String)message);
        }
    }

    public static void assertNoResourceErrorsOrWarnings(@NonNull String prefix, @NonNull Resource resource) {
        String message = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)resource.getErrors())), (String)prefix, (String)"\n\t");
        if (message != null) {
            PivotTestCase.fail((String)message);
        }
        if ((message = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)resource.getWarnings())), (String)prefix, (String)"\n\t")) != null) {
            PivotTestCase.fail((String)message);
        }
    }

    public static void assertNoUnresolvedProxies(@NonNull String message, @NonNull Resource resource) {
        Map unresolvedProxies = EcoreUtil.UnresolvedProxyCrossReferencer.find((Resource)resource);
        if (unresolvedProxies.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(unresolvedProxies.size());
            s.append(" unresolved proxies in ");
            s.append(message);
            for (Map.Entry unresolvedProxy : unresolvedProxies.entrySet()) {
                s.append("\n");
                BasicEObjectImpl key = (BasicEObjectImpl)unresolvedProxy.getKey();
                s.append(key.eProxyURI());
                for (EStructuralFeature.Setting setting : (Collection)unresolvedProxy.getValue()) {
                    s.append("\n\t");
                    EObject eObject = setting.getEObject();
                    try {
                        s.append(eObject.toString());
                    }
                    catch (Exception e) {
                        s.append(EcoreUtil.getURI((EObject)eObject).toString());
                    }
                }
            }
            PivotTestCase.fail((String)s.toString());
        }
    }

    public static void assertNoValidationErrors(@NonNull String string, @NonNull Resource resource) {
        Executor savedExecutor = ThreadLocalExecutor.basicGetExecutor();
        ExecutorInternal savedInterpretedExecutor = savedExecutor != null ? savedExecutor.basicGetInterpretedExecutor() : null;
        try {
            for (EObject eObject : resource.getContents()) {
                PivotTestCase.assertNoValidationErrorsInternal(string, (EObject)ClassUtil.nonNullEMF((Object)eObject));
            }
        }
        finally {
            if (savedExecutor != ThreadLocalExecutor.basicGetExecutor()) {
                ThreadLocalExecutor.setExecutor(null);
            } else if (savedExecutor != null && savedInterpretedExecutor != savedExecutor.basicGetInterpretedExecutor()) {
                savedExecutor.setInterpretedExecutor(null);
            }
        }
    }

    public static void assertNoValidationErrors(@NonNull String string, @NonNull EObject eObject) {
        Executor savedExecutor = ThreadLocalExecutor.basicGetExecutor();
        ExecutorInternal savedInterpretedExecutor = savedExecutor != null ? savedExecutor.basicGetInterpretedExecutor() : null;
        try {
            PivotTestCase.assertNoValidationErrorsInternal(string, eObject);
        }
        finally {
            if (savedExecutor != ThreadLocalExecutor.basicGetExecutor()) {
                ThreadLocalExecutor.setExecutor(null);
            } else if (savedExecutor != null && savedInterpretedExecutor != savedExecutor.basicGetInterpretedExecutor()) {
                savedExecutor.setInterpretedExecutor(null);
            }
        }
    }

    protected static void assertNoValidationErrorsInternal(@NonNull String string, @NonNull EObject eObject) {
        ValidationRegistryAdapter validationRegistry = ValidationRegistryAdapter.getAdapter((Notifier)eObject);
        ValidationContext validationContext = new ValidationContext((EValidator.Registry)validationRegistry);
        BasicDiagnostic diagnostics = PivotDiagnostician.BasicDiagnosticWithRemove.validate((EObject)eObject, (Map)validationContext);
        List children = diagnostics.getChildren();
        if (children.size() <= 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(children.size()) + " validation errors");
        PivotTestCase.appendChildren(s, children, 0);
        PivotTestCase.fail((String)s.toString());
    }

    public static void assertResourceErrors(@NonNull String prefix, @NonNull Resource resource, String ... messages) {
        PivotTestCase.assertResourceDiagnostics(prefix, (List)ClassUtil.nonNullEMF((Object)resource.getErrors()), messages);
    }

    /*
     * Unable to fully structure code
     */
    public static void assertResourceDiagnostics(@NonNull String prefix, @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    Resource.Diagnostic> resourceDiagnostics, String ... messages) {
        expected = new HashMap<String, Integer>();
        if (messages != null) {
            var7_4 = messages;
            var6_5 = messages.length;
            var5_7 = 0;
            while (var5_7 < var6_5) {
                message = var7_4[var5_7];
                count = (Integer)expected.get(message);
                count = count == null ? 1 : count + 1;
                expected.put(message, count);
                ++var5_7;
            }
        }
        s1 = null;
        for (Resource.Diagnostic error : resourceDiagnostics) {
            actual = error.getMessage();
            expectedCount = (Integer)expected.get(actual);
            if (expectedCount == null || expectedCount <= 0) {
                if (s1 == null) {
                    s1 = new StringBuilder();
                    s1.append("\nUnexpected errors");
                }
                s1.append("\n");
                s1.append(actual);
                continue;
            }
            expected.put(actual, expectedCount - 1);
        }
        s2 = null;
        for (String key : expected.keySet()) {
            count = (Integer)expected.get(key);
            if (PivotTestCase.$assertionsDisabled || count != null) ** GOTO lbl44
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                if (s2 == null) {
                    s2 = new StringBuilder();
                    s2.append("\nMissing errors");
                }
                s2.append("\n");
                s2.append(key);
lbl44:
                // 2 sources

                v0 = count;
                count = v0 - 1;
                ** while (v0.intValue() > 0)
            }
lbl47:
            // 1 sources

        }
        if (s1 == null) {
            if (s2 == null) {
                return;
            }
            PivotTestCase.fail((String)s2.toString());
        } else if (s2 == null) {
            PivotTestCase.fail((String)s1.toString());
        } else {
            PivotTestCase.fail((String)(String.valueOf(s1.toString()) + s2.toString()));
        }
    }

    public static @NonNull List<Diagnostic> assertValidationDiagnostics(@NonNull String prefix, @NonNull Resource resource, @NonNull String @Nullable [] messages) {
        ValidationRegistryAdapter validationRegistry = ValidationRegistryAdapter.getAdapter((Notifier)resource);
        ValidationContext validationContext = new ValidationContext((EValidator.Registry)validationRegistry);
        validationContext.put(EnvironmentFactory.class, (Object)PivotUtilInternal.getEnvironmentFactory(null));
        return PivotTestCase.assertValidationDiagnostics(prefix, resource, validationContext, messages);
    }

    public static @NonNull List<Diagnostic> assertValidationDiagnostics(@NonNull String prefix, @NonNull Resource resource, @NonNull ValidationContext validationContext, @NonNull String @Nullable [] messages) {
        Executor savedExecutor = ThreadLocalExecutor.basicGetExecutor();
        ExecutorInternal savedInterpretedExecutor = savedExecutor != null ? savedExecutor.basicGetInterpretedExecutor() : null;
        try {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            for (EObject eObject : resource.getContents()) {
                BasicDiagnostic diagnostic = PivotDiagnostician.BasicDiagnosticWithRemove.validate((EObject)eObject, (Map)validationContext);
                diagnostics.addAll(diagnostic.getChildren());
            }
            List<Diagnostic> list = messages != null ? PivotTestCase.assertDiagnostics(prefix, resource, diagnostics, messages) : Collections.emptyList();
            return list;
        }
        finally {
            if (savedExecutor != ThreadLocalExecutor.basicGetExecutor()) {
                ThreadLocalExecutor.setExecutor(null);
            } else if (savedExecutor != null && savedInterpretedExecutor != savedExecutor.basicGetInterpretedExecutor()) {
                savedExecutor.setInterpretedExecutor(null);
            }
        }
    }

    public static @Nullable StandaloneProjectMap basicGetProjectMap() {
        GlobalEnvironmentFactory globalEnvironmentFactory = GlobalEnvironmentFactory.basicGetInstance();
        return globalEnvironmentFactory != null ? (StandaloneProjectMap)globalEnvironmentFactory.getProjectManager() : null;
    }

    public static void closeTestLog() {
        if (testLog != null) {
            try {
                testLog.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void configurePlatformResources() {
        if (!PivotTestCase.eclipseIsRunning()) {
            File[] files;
            String urlString = System.getProperty("WORKSPACE_LOC");
            File workspaceLoc = urlString != null ? new File(urlString) : new File(System.getProperty("user.dir")).getParentFile();
            File[] fileArray = files = workspaceLoc.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    String name = file.getName();
                    EcorePlugin.getPlatformResourceMap().put(name, URI.createFileURI((String)(String.valueOf(file.toString()) + "/")));
                }
                ++n2;
            }
        }
    }

    public static void createTestLog(File file) {
        try {
            Writer writer = testLog = file != null ? new FileWriter(file) : null;
            if (testLog != null) {
                try {
                    testLog.append("Test Group");
                    testLog.append(";");
                    testLog.append("Context Object");
                    testLog.append(";");
                    testLog.append("Test Expression");
                    testLog.append(";");
                    testLog.append("Parser Result");
                    testLog.append(";");
                    testLog.append("Evaluation Result");
                    testLog.append(";");
                    testLog.append("Result Tolerance");
                    testLog.append("\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static @NonNull Resource cs2ecore(@NonNull EnvironmentFactory environmentFactory, @NonNull String testDocument, @NonNull URI ecoreURI) throws IOException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testDocument, "UTF-8");
        URI xtextURI = URI.createURI((String)"test.oclinecore");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EssentialOCLCSResource xtextResource = (EssentialOCLCSResource)ClassUtil.nonNullState((Object)((EssentialOCLCSResource)resourceSet.createResource(xtextURI, null)));
        environmentFactory.adapt((Notifier)xtextResource);
        xtextResource.load((InputStream)inputStream, null);
        PivotTestCase.assertNoResourceErrors("Loading Xtext", (Resource)xtextResource);
        Resource asResource = PivotTestCase.cs2as((CSResource)xtextResource, null);
        Resource ecoreResource = PivotTestCase.as2ecore(environmentFactory, asResource, ecoreURI, NO_MESSAGES);
        return ecoreResource;
    }

    public static @NonNull Resource cs2as(@NonNull OCL ocl, @NonNull String testDocument) throws IOException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(testDocument, "UTF-8");
        URI xtextURI = URI.createURI((String)"test.oclinecore");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EssentialOCLCSResource xtextResource = (EssentialOCLCSResource)ClassUtil.nonNullState((Object)((EssentialOCLCSResource)resourceSet.createResource(xtextURI, null)));
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load((InputStream)inputStream, null);
        PivotTestCase.assertNoResourceErrors("Loading Xtext", (Resource)xtextResource);
        Resource asResource = PivotTestCase.cs2as((CSResource)xtextResource, null);
        return asResource;
    }

    public static @NonNull Resource cs2as(@NonNull CSResource xtextResource, @Nullable URI pivotURI) throws IOException {
        ASResource asResource = xtextResource.getASResource();
        PivotTestCase.assertNoUnresolvedProxies("Unresolved proxies", (Resource)asResource);
        if (pivotURI != null && asResource.isSaveable()) {
            asResource.setURI(pivotURI);
            asResource.save(null);
        }
        return asResource;
    }

    public static void disposeResourceSet(@NonNull ResourceSet resourceSet) {
        for (Resource next : resourceSet.getResources()) {
            next.unload();
            next.eAdapters().clear();
        }
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    @Deprecated
    public static void doCompleteOCLSetup() {
        TestUtil.doCompleteOCLSetup();
    }

    @Deprecated
    public static void doEssentialOCLSetup() {
        TestUtil.doEssentialOCLSetup();
    }

    @Deprecated
    public static void doOCLinEcoreSetup() {
        TestUtil.doOCLinEcoreSetup();
    }

    @Deprecated
    public static void doOCLstdlibSetup() {
        TestUtil.doOCLstdlibSetup();
    }

    public static boolean eclipseIsRunning() {
        try {
            Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
            Method isRunningMethod = platformClass.getDeclaredMethod("isRunning", new Class[0]);
            return Boolean.TRUE.equals(isRunningMethod.invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static Value failOn(@NonNull String expression, @Nullable Throwable e) {
        if (e instanceof EvaluationException) {
            Throwable eCause = e.getCause();
            if (eCause != null) {
                return PivotTestCase.failOn(expression, eCause);
            }
            throw new Error(StringUtil.bind((String)"Failed to evaluate ''{0}'' : {1}", (Object[])new Object[]{expression, e.getMessage()}), e);
        }
        if (e instanceof EvaluationException) {
            throw new Error("Failed to parse or evaluate \"" + expression + "\"", e);
        }
        throw new Error("Failure for \"" + expression + "\"", e);
    }

    public static String formatMessageDifferences(Bag<String> expectedMessages, @NonNull Bag<String> actualMessages) {
        HashSet<String> allMessages = new HashSet<String>((Collection<String>)expectedMessages);
        allMessages.addAll((Collection<String>)actualMessages);
        StringBuilder s = null;
        for (String message : allMessages) {
            int expectedCount;
            int actualCount = actualMessages.count((Object)message);
            if (actualCount == (expectedCount = expectedMessages.count((Object)message))) continue;
            if (s == null) {
                s = new StringBuilder();
            }
            s.append("\n  (" + expectedCount + "/" + actualCount + ") " + message);
        }
        return s != null ? s.toString() : null;
    }

    public static @NonNull String @NonNull [] getMessages(String ... messages) {
        @NonNull String[] messageArray = new String[messages.length];
        int i = 0;
        while (i < messages.length) {
            String message = messages[i];
            assert (message != null);
            messageArray[i] = message;
            ++i;
        }
        return messageArray;
    }

    public static @NonNull StandaloneProjectMap getProjectMap() {
        return (StandaloneProjectMap)ProjectManager.CLASS_PATH;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void unloadResourceSet(@NonNull ResourceSet resourceSet) {
        EnvironmentFactoryAdapter environmentFactoryAdapter;
        StandaloneProjectMap projectMap = StandaloneProjectMap.findAdapter((ResourceSet)resourceSet);
        if (projectMap != null) {
            projectMap.unload(resourceSet);
        }
        if ((environmentFactoryAdapter = EnvironmentFactoryAdapter.find((Notifier)resourceSet)) != null) {
            EnvironmentFactoryInternal environmentFactory = environmentFactoryAdapter.getMetamodelManager().getEnvironmentFactory();
            ProjectManager projectManager = environmentFactory.getProjectManager();
            projectManager.unload(resourceSet);
        }
        @NonNull EList resources = resourceSet.getResources();
        int i = 0;
        while (i < resources.size()) {
            Resource resource = (Resource)resources.get(i);
            resource.unload();
            ++i;
        }
        resourceSet.eAdapters().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestRunnable(@NonNull TestRunnable testRunnable) throws Throwable {
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            testRunnable.run();
        } else {
            Thread testThread = new Thread((Runnable)testRunnable, testRunnable.name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    catch (Throwable throwable) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.notify();
                        }
                        throw throwable;
                    }
                    1 var2_3 = this;
                    synchronized (var2_3) {
                        this.notify();
                    }
                }
            };
            testThread.start();
            Thread thread = testThread;
            synchronized (thread) {
                try {
                    testThread.wait(1000000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DEBUG_GC) {
                    System.gc();
                    System.runFinalization();
                }
                if (testRunnable.throwable != null) {
                    throw testRunnable.throwable;
                }
            }
        }
    }

    @Deprecated
    protected @NonNull File getProjectFile() {
        String projectName = this.getProjectName();
        URL projectURL = this.getTestResource(projectName);
        PivotTestCase.assertNotNull((Object)projectURL);
        return new File(projectURL.getFile());
    }

    @Deprecated
    protected @NonNull URI getProjectFileURI(@NonNull String referenceName) {
        throw new UnsupportedOperationException();
    }

    protected @NonNull String getProjectName() {
        return String.valueOf(((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/')) + "/models";
    }

    public @NonNull String getName() {
        return TestUtil.getName(this.getTestName());
    }

    public @NonNull String getTestName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        String methodName = this.testName.getMethodName();
        return methodName != null ? methodName : "<unnamed>";
    }

    public static @NonNull URI getTestModelURI(@NonNull String localFileName) {
        String testPlugInPrefix = "org.eclipse.ocl.examples.xtext.tests/";
        URI testPlugURI = EcorePlugin.IS_ECLIPSE_RUNNING ? URI.createPlatformPluginURI((String)testPlugInPrefix, (boolean)true) : URI.createPlatformResourceURI((String)testPlugInPrefix, (boolean)true);
        URI localURI = URI.createURI((String)(localFileName.startsWith("/") ? localFileName.substring(1) : localFileName));
        return localURI.resolve(testPlugURI);
    }

    @Deprecated
    protected @NonNull URL getTestResource(@NonNull String resourceName) {
        URL projectURL;
        block5: {
            projectURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
            try {
                if (projectURL == null || !Platform.isRunning()) break block5;
                try {
                    projectURL = FileLocator.resolve((URL)projectURL);
                }
                catch (IOException e) {
                    TestCase.fail((String)e.getMessage());
                    assert (false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (URL)ClassUtil.nonNullState((Object)projectURL);
    }

    public void resetRegistries() {
        Object object = ValidationDelegate.Factory.Registry.INSTANCE.get((Object)"http://www.eclipse.org/emf/2002/Ecore/OCL");
        if (object instanceof OCLValidationDelegateMapping) {
            ((OCLValidationDelegateMapping)object).reset();
        }
    }

    protected void setUp() throws Exception {
        PivotUtilInternal.debugReset();
        GlobalEnvironmentFactory.resetSafeNavigationValidations();
        ThreadLocalExecutor.reset();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            TestUIUtil.closeIntro();
            TestUIUtil.flushEvents();
        }
        ASResourceImpl.CHECK_IMMUTABILITY.setState(true);
        if (DEBUG_GC) {
            XMLNamespacePackage.eINSTANCE.getClass();
            this.makeCopyOfGlobalState = new GlobalStateMemento();
        }
        super.setUp();
        if (DEBUG_ID) {
            PivotUtilInternal.debugPrintln((Object)("-----Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName() + "-----"));
        }
        TEST_START.println("-----Starting " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName() + "-----");
        EcorePackage.eINSTANCE.getClass();
    }

    protected void tearDown() throws Exception {
        OCLstdlib oclstdlib;
        ThreadLocalExecutor.reset();
        if (DEBUG_GC) {
            this.uninstall();
            this.makeCopyOfGlobalState.restoreGlobalState();
            this.makeCopyOfGlobalState = null;
            System.gc();
            System.runFinalization();
        }
        if (DEBUG_ID) {
            PivotUtilInternal.debugPrintln((Object)("==> Finish " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName()));
        }
        if ((oclstdlib = OCLstdlib.basicGetDefault()) != null) {
            TreeIterator tit = oclstdlib.getAllContents();
            while (tit.hasNext()) {
                PivotObjectImpl asObject;
                EObject eTarget;
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof PivotObjectImpl) || (eTarget = (asObject = (PivotObjectImpl)eObject).getESObject()) == null || !eTarget.eIsProxy()) continue;
                asObject.setESObject(null);
            }
        }
        super.tearDown();
    }

    protected void uninstall() {
        IdiomsStandaloneSetup.doTearDown();
        PivotStandaloneSetup.doTearDown();
        BaseStandaloneSetup.doTearDown();
        CompleteOCLStandaloneSetup.doTearDown();
        EssentialOCLStandaloneSetup.doTearDown();
        MarkupStandaloneSetup.doTearDown();
        OCLinEcoreStandaloneSetup.doTearDown();
        OCLstdlibStandaloneSetup.doTearDown();
        GlobalEnvironmentFactory.disposeInstance();
        GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.removeDescriptors("http://www.eclipse.org/emf/2002/GenModel");
        GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.removeDescriptors("http://www.eclipse.org/uml2/2.2.0/GenModel");
    }

    public static class GlobalStateMemento {
        private @NonNull HashMap<EPackage, Object> validatorReg = new HashMap(EValidator.Registry.INSTANCE);
        private @NonNull HashMap<String, Object> epackageReg = new HashMap(EPackage.Registry.INSTANCE);
        private @NonNull HashMap<String, Object> protocolToFactoryMap = new HashMap(Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap());
        private @NonNull HashMap<String, Object> extensionToFactoryMap = new HashMap(Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap());
        private @NonNull HashMap<String, Object> contentTypeIdentifierToFactoryMap = new HashMap(Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap());
        private @NonNull HashMap<String, Object> protocolToServiceProviderMap = new HashMap(IResourceServiceProvider.Registry.INSTANCE.getProtocolToFactoryMap());
        private @NonNull HashMap<String, Object> extensionToServiceProviderMap = new HashMap(IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap());
        private @NonNull HashMap<String, Object> contentTypeIdentifierToServiceProviderMap = new HashMap(IResourceServiceProvider.Registry.INSTANCE.getContentTypeToFactoryMap());

        public void restoreGlobalState() {
            GlobalStateMemento.clearGlobalRegistries();
            EValidator.Registry.INSTANCE.putAll(this.validatorReg);
            EPackage.Registry.INSTANCE.putAll(this.epackageReg);
            Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().putAll(this.protocolToFactoryMap);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().putAll(this.extensionToFactoryMap);
            Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().putAll(this.contentTypeIdentifierToFactoryMap);
            IResourceServiceProvider.Registry.INSTANCE.getProtocolToFactoryMap().putAll(this.protocolToServiceProviderMap);
            IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().putAll(this.extensionToServiceProviderMap);
            IResourceServiceProvider.Registry.INSTANCE.getContentTypeToFactoryMap().putAll(this.contentTypeIdentifierToServiceProviderMap);
        }

        public static void clearGlobalRegistries() {
            EValidator.Registry.INSTANCE.clear();
            EPackage.Registry.INSTANCE.clear();
            Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().clear();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().clear();
            Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().clear();
            IResourceServiceProvider.Registry.INSTANCE.getProtocolToFactoryMap().clear();
            IResourceServiceProvider.Registry.INSTANCE.getExtensionToFactoryMap().clear();
            IResourceServiceProvider.Registry.INSTANCE.getContentTypeToFactoryMap().clear();
            GlobalStateMemento.initializeDefaults();
        }

        public static void initializeDefaults() {
            if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("ecore")) {
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            }
            if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("xmi")) {
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
            }
            if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/emf/2002/Ecore")) {
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
            }
            if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/2008/Xtext")) {
                EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/2008/Xtext", (Object)XtextPackage.eINSTANCE);
            }
        }
    }

    protected static abstract class TestRunnable
    implements Runnable {
        static int count = 0;
        String name = "test" + count++;
        Throwable throwable = null;

        protected TestRunnable() {
        }

        @Override
        public void run() {
            try {
                this.runWithThrowable();
            }
            catch (Throwable t) {
                this.throwable = t;
            }
        }

        protected abstract void runWithThrowable() throws Throwable;
    }
}

