/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystem;
import org.eclipse.ocl.examples.xtext.tests.TestFileSystemHelper;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUIUtil;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.xtext.base.ui.messages.BaseUIMessages;
import org.eclipse.ocl.xtext.base.ui.utilities.BaseUIUtil;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileNewWizardPage;
import org.eclipse.ocl.xtext.completeocl.ui.messages.CompleteOCLUIMessages;
import org.eclipse.ocl.xtext.completeocl.ui.wizards.CompleteOCLFileDialog;
import org.eclipse.ocl.xtext.completeocl.ui.wizards.CompleteOCLFileNewWizard;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.EcoreWithOCLFileNewWizard;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.OCLinEcoreFileNewWizard;
import org.eclipse.ocl.xtext.oclstdlib.ui.wizards.OCLstdlibFileNewWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class FileNewWizardTest
extends TestCase {
    private static final String PAGE_NAME = BaseUIMessages.NewWizardPage_pageName;
    private static final @NonNull String TEST_ECORE_NAME = "Test.ecore";
    private static final @NonNull String EXPECTED_OCL_NAME = "Test.ocl";
    private static final @NonNull String EXPECTED_OCLINECORE_NAME = "Test.oclinecore";
    private static final @NonNull String EXPECTED_OCLSTDLIB_NAME = "Test.oclstdlib";
    private static final @NonNull String EXPECTED_PACKAGE_NAME = "test_package";
    private static final @NonNull String EXPECTED_CLASS_NAME = "TestClass";
    private static final @NonNull String EXPECTED_FEATURE_NAME = "testFeature";
    private static final boolean SUPPRESS_OCL_NATURE = false;
    @Rule
    public @NonNull TestName testName = new TestName();
    public @Nullable TestFileSystem testFileSystem = null;
    public @Nullable TestProject testProject = null;
    public @Nullable TestFile testFile = null;
    private IProject testIProject = null;
    private IFile testIFile = null;

    public static String getExpectedContents() {
        StringBuilder s = new StringBuilder();
        s.append("import 'Test.ecore'\n\n");
        s.append("package test_package\n\n");
        s.append("context TestClass\n");
        s.append("--\n");
        s.append("-- example invariant with a custom error message to verify that\n");
        s.append("-- the 'testFeature' property of all 'test_package::TestClass' instances is non-null\n");
        s.append("--\n");
        s.append("inv NonNull_testFeature('The \\'testFeature\\' property of \"' + self.toString() + '\" is null'):\n");
        s.append("\ttestFeature <> null\n\n");
        s.append("endpackage\n");
        return s.toString();
    }

    private static @NonNull URIConverter getURIConverter() {
        URIConverter uriConverter = URIConverter.INSTANCE;
        if (!EcorePlugin.IS_ECLIPSE_RUNNING && uriConverter.getURIMap().isEmpty()) {
            EcorePlugin.ExtensionProcessor.process(null);
            uriConverter.getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        }
        return uriConverter;
    }

    public FileNewWizardTest(String name) {
        super(name);
    }

    protected int createAndFinishWizardDialog(@NonNull IWorkbenchWizard wizard) {
        WizardDialog dialog = new WizardDialog(new Shell(), (IWizard)wizard){

            public int open() {
                Thread thread = new Thread("Press Finish"){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Shell shell = this.getShell();
                        if (shell != null && !shell.isDisposed()) {
                            shell.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    this.finishPressed();
                                }
                            });
                        }
                    }
                };
                thread.start();
                return super.open();
            }
        };
        return dialog.open();
    }

    protected XtextEditor getActiveEditor() {
        IWorkbenchPage currentPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return (XtextEditor)currentPage.getActiveEditor();
    }

    public String getName() {
        return TestUtil.getName((String)ClassUtil.nonNullState((Object)super.getName()));
    }

    protected final @NonNull TestFileSystem getTestFileSystem() {
        return this.getTestFileSystem("");
    }

    protected @NonNull TestFileSystem getTestFileSystem(@NonNull String pathFromCurrentWorkingDirectoryToFileSystem) {
        TestFileSystem testFileSystem2 = this.testFileSystem;
        if (testFileSystem2 == null) {
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                File testBundleFile = new File(".project");
                assert (!testBundleFile.exists()) : "Default working directory should be the workspace rather than a project: " + testBundleFile.getAbsolutePath();
            }
            this.testFileSystem = testFileSystem2 = TestFileSystem.create(this.getTestFileSystemHelper(), pathFromCurrentWorkingDirectoryToFileSystem);
        }
        return testFileSystem2;
    }

    protected @NonNull TestFileSystemHelper getTestFileSystemHelper() {
        return new TestFileSystemHelper();
    }

    protected @NonNull TestFile getTestFile(@NonNull String filePath, @NonNull InputStream inputStream) throws IOException {
        TestProject testProject = this.getTestProject();
        return testProject.getOutputFile(filePath, inputStream);
    }

    public @NonNull String getTestName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        String methodName = this.testName.getMethodName();
        return methodName != null ? methodName : "<unnamed>";
    }

    protected final @NonNull TestProject getTestProject() {
        return this.getTestProject("");
    }

    protected @NonNull TestProject getTestProject(@NonNull String pathFromCurrentWorkingDirectoryToFileSystem) {
        TestProject testProject2 = this.testProject;
        if (testProject2 == null) {
            String testProjectName = "_OCL_" + ((Object)((Object)this)).getClass().getSimpleName() + "__" + this.getTestName();
            this.testProject = testProject2 = this.getTestFileSystem(pathFromCurrentWorkingDirectoryToFileSystem).getTestProject(testProjectName, true);
        }
        return testProject2;
    }

    protected @NonNull String readNewFile(String fileName) throws CoreException, IOException {
        IFile oclFile = this.getTestProject().getIProject().getFile(fileName);
        FileNewWizardTest.assertTrue((boolean)oclFile.exists());
        InputStream inputStream = oclFile.getContents();
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuilder s = new StringBuilder();
        char[] cbuf = new char[4096];
        int len = 0;
        while ((len = reader.read(cbuf)) > 0) {
            s.append(cbuf, 0, len);
        }
        ((Reader)reader).close();
        return s.toString();
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestProject testProject = this.getTestProject();
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        prefs.putBoolean("refresh.lightweight.enabled", true);
        this.testIProject = testProject.getIProject();
        FileNewWizardTest.assertTrue((boolean)this.testIProject.exists());
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        IProjectDescription description = (IProjectDescription)ClassUtil.nonNullState((Object)this.testIProject.getDescription());
        BaseUIUtil.toggleNature((IProjectDescription)description, (String)"org.eclipse.ocl.pivot.ui.oclnature");
        this.testIProject.setDescription(description, 3, (IProgressMonitor)nullMonitor);
        URI inputURI = URI.createPlatformPluginURI((String)"org.eclipse.ocl.examples.xtext.tests/models/wizard/Test.ecore", (boolean)true);
        InputStream inputStream = FileNewWizardTest.getURIConverter().createInputStream(inputURI);
        assert (inputStream != null);
        this.testFile = this.getTestFile(TEST_ECORE_NAME, inputStream);
        this.testIFile = this.testIProject.getFile(TEST_ECORE_NAME);
        FileNewWizardTest.assertTrue((boolean)this.testIFile.exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test_CompleteOCLFile_Dialog() {
        CompleteOCLFileNewWizard wizard = new CompleteOCLFileNewWizard();
        AbstractFileNewWizardPage wizardPage = wizard.createNewWizardPage((IResource)this.testIFile);
        CompleteOCLFileDialog dialog = new CompleteOCLFileDialog(wizard, wizardPage, (IResource)this.testIFile);
        dialog.createDialogArea((Composite)new Shell());
        FileNewWizardTest.assertEquals((String)"ocl", (String)wizard.getNewFileExtension());
        FileNewWizardTest.assertEquals((String)CompleteOCLUIMessages.NewWizardPage_fileNameLabel, (String)wizard.getNewFileLabel());
        FileNewWizardTest.assertEquals((String)("/" + this.getTestProject().getName() + "/" + EXPECTED_OCL_NAME), (String)dialog.getNewFilePath().toString());
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(URI.createPlatformResourceURI((String)(String.valueOf(this.getTestProject().getName()) + "/" + TEST_ECORE_NAME), (boolean)true));
        FileNewWizardTest.assertEquals(uris, (Object)dialog.getURIs());
        wizard.dispose();
    }

    @Test
    public void test_CompleteOCLFile_NewWizardPage() {
        CompleteOCLFileNewWizard wizard = new CompleteOCLFileNewWizard();
        AbstractFileNewWizardPage wizardPage = wizard.createNewWizardPage((IResource)this.testIFile);
        FileNewWizardTest.assertEquals((String)PAGE_NAME, (String)wizardPage.getName());
        FileNewWizardTest.assertEquals((String)CompleteOCLUIMessages.NewWizardPage_pageSummary, (String)wizardPage.getTitle());
        FileNewWizardTest.assertEquals((String)CompleteOCLUIMessages.NewWizardPage_pageDescription, (String)wizardPage.getDescription());
        FileNewWizardTest.assertNull((Object)wizardPage.getErrorMessage());
        wizard.dispose();
    }

    @Test
    public void test_CompleteOCL_NewFileCreation() throws Exception {
        CompleteOCLFileNewWizard wizard = new CompleteOCLFileNewWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.testIFile));
        this.createAndFinishWizardDialog((IWorkbenchWizard)wizard);
        String actualContents = this.readNewFile(EXPECTED_OCL_NAME);
        StringBuilder s = new StringBuilder();
        s.append("import 'Test.ecore'\n\n");
        s.append("package test_package\n\n");
        s.append("context TestClass\n");
        s.append("--\n");
        s.append("-- example invariant with a custom error message to verify that\n");
        s.append("-- the 'testFeature' property of all 'test_package::TestClass' instances is non-null\n");
        s.append("--\n");
        s.append("inv NonNull_testFeature('The \\'testFeature\\' property of \"' + self.toString() + '\" is null'):\n");
        s.append("\ttestFeature <> null\n\n");
        s.append("endpackage\n");
        String expectedContents = s.toString();
        FileNewWizardTest.assertEquals((String)expectedContents, (String)actualContents);
        XtextEditor activeEditor = this.getActiveEditor();
        FileNewWizardTest.assertEquals((String)"org.eclipse.ocl.xtext.completeocl.CompleteOCL", (String)activeEditor.getLanguageName());
        activeEditor.close(false);
    }

    @Test
    public void test_OCLinEcore_NewFileCreation() throws Exception {
        OCLinEcoreFileNewWizard wizard = new OCLinEcoreFileNewWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.testIFile));
        this.createAndFinishWizardDialog((IWorkbenchWizard)wizard);
        String actualContents = this.readNewFile(EXPECTED_OCLINECORE_NAME);
        StringBuilder s = new StringBuilder();
        s.append("import 'Test.ecore';\n");
        s.append("\n");
        s.append("package example : ex = 'http://www.example.org/examples/example.ecore'\n");
        s.append("{\n");
        s.append("\t-- Example Class with hierarchical properties and an invariant\n");
        s.append("\tclass Example\n");
        s.append("\t{\n");
        s.append("\t\tproperty name : String[?];\n");
        s.append("\t\tproperty children#parent : Example[*] { composes, ordered } ;\n");
        s.append("\t\tproperty parent#children : Example[?];\n");
        s.append("\t\toperation ucName() : String[?] {\n");
        s.append("\t\t\tbody: name?.toUpperCase();\n");
        s.append("\t\t}\n");
        s.append("\t\tinvariant NameIsLowerCase('Expected a lowercase name rather than '' + name + '''):\n");
        s.append("\t\t\tname = name?.toLowerCase();\n");
        s.append("\t}\n");
        s.append("}\n");
        String expectedContents = s.toString();
        FileNewWizardTest.assertEquals((String)expectedContents, (String)actualContents);
        XtextEditor activeEditor = this.getActiveEditor();
        FileNewWizardTest.assertEquals((String)"org.eclipse.ocl.xtext.oclinecore.OCLinEcore", (String)activeEditor.getLanguageName());
        activeEditor.close(false);
    }

    @Test
    public void test_EcoreWithOCL_NewFileCreation() throws Exception {
        IFile testIFile = this.getTestProject().getIProject().getFile("Testing.xxx");
        EcoreWithOCLFileNewWizard wizard = new EcoreWithOCLFileNewWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)testIFile));
        this.createAndFinishWizardDialog((IWorkbenchWizard)wizard);
        TestUIUtil.wait(1000);
        XtextEditor activeEditor = this.getActiveEditor();
        FileNewWizardTest.assertEquals((String)"org.eclipse.ocl.xtext.oclinecore.OCLinEcore", (String)activeEditor.getLanguageName());
        IXtextDocument document = activeEditor.getDocument();
        String actualContents = document.get();
        StringBuilder s = new StringBuilder();
        s.append("package example : ex = 'http://www.example.org/examples/example.ecore' {\n");
        s.append("\tclass Example {\n");
        s.append("\t\toperation ucName() : String[?] {\n");
        s.append("\t\t\tbody: name?.toUpperCase();\n");
        s.append("\t\t}\n");
        s.append("\t\tattribute name : String[?];\n");
        s.append("\t\tproperty children#parent : Example[*] { ordered composes };\n");
        s.append("\t\tproperty parent#children : Example[?];\n");
        s.append("\t\tinvariant NameIsLowerCase('Expected a lowercase name rather than '' + name + '''):\n");
        s.append("\t\t\tname = name?.toLowerCase();\n");
        s.append("\t}\n");
        s.append("}\n");
        String expectedContents = s.toString();
        FileNewWizardTest.assertEquals((String)expectedContents.trim().replaceAll("\\s+", " "), (String)actualContents.trim().replaceAll("\\s+", " "));
        activeEditor.close(false);
    }

    @Test
    public void test_OCLstdlib_NewFileCreation() throws Exception {
        OCLstdlibFileNewWizard wizard = new OCLstdlibFileNewWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.testIFile));
        this.createAndFinishWizardDialog((IWorkbenchWizard)wizard);
        String actualContents = this.readNewFile(EXPECTED_OCLSTDLIB_NAME);
        StringBuilder s = new StringBuilder();
        s.append("-- import an existing library to be extended\n");
        s.append("import 'http://www.eclipse.org/ocl/2015/Library';\n");
        s.append("\n");
        s.append("-- import an extension library re-using the imported library nsURI\n");
        s.append("library lib : lib = 'http://www.eclipse.org/ocl/2015/Library' {\n");
        s.append("    type String : PrimitiveType {\n");
        s.append("    \t-- define an additional operation accessed by my.strings.ExtraOperation.INSTANCE.evaluate\n");
        s.append("    \toperation extraOperation(elem : Boolean) : Boolean => 'my.strings.ExtraOperation';\n");
        s.append("    }\n");
        s.append("}\n");
        String expectedContents = s.toString();
        FileNewWizardTest.assertEquals((String)expectedContents, (String)actualContents);
        XtextEditor activeEditor = this.getActiveEditor();
        FileNewWizardTest.assertEquals((String)"org.eclipse.ocl.xtext.oclstdlib.OCLstdlib", (String)activeEditor.getLanguageName());
        activeEditor.close(false);
    }
}

