/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.operations.GeneratorConfigurationOperations;
import org.eclipse.papyrus.model2doc.emf.documentstructure.edit.validators.StringVersionValidator;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.Activator;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.command.GenerateDocumentStructureCommand;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.messages.Messages;
import org.eclipse.swt.widgets.Display;

public class GenerateDocumentStructureUtils {
    public static final String DIALOG_TITLE = "Papyrus-Model2Doc";
    private static final String PROPERTIES_FILE_EXTENSION = "versions";
    private static final String VERSION_FILE_NAME = "LastGeneratedDocumentVersion";
    private static final String MODEL2DOC_PREFERENCE_FOLDER_NAME = "model2doc";

    public static Collection<?> generateDocumentStructure(TransactionalEditingDomain domain, Command command, DocumentTemplate documentTemplate) {
        if (documentTemplate == null) {
            return null;
        }
        String previousVersion = GenerateDocumentStructureUtils.getPreviousGeneratedVersion(documentTemplate);
        String dialogMessage = previousVersion == null || previousVersion.isEmpty() ? Messages.GenerateDocumentStructureHandler_EnterTheDocumentVersion : NLS.bind((String)Messages.GenerateDocumentStructureHandler_EnterTheDocumentVersionWithLastVersion, (Object)previousVersion);
        InputDialog defineVersion = new InputDialog(Display.getDefault().getActiveShell(), DIALOG_TITLE, dialogMessage, "", (IInputValidator)new StringVersionValidator());
        if (defineVersion.open() != 0) {
            return null;
        }
        return GenerateDocumentStructureUtils.generateDocumentStructure(domain, command, documentTemplate, defineVersion.getValue());
    }

    public static Collection<?> generateDocumentStructure(TransactionalEditingDomain domain, Command command, DocumentTemplate documentTemplate, String version) {
        if (documentTemplate == null) {
            return null;
        }
        Collection result = null;
        if (version != null && !version.isEmpty() && command instanceof GenerateDocumentStructureCommand) {
            ((GenerateDocumentStructureCommand)command).setVersion(version);
        }
        if (domain != null && command != null && command.canExecute()) {
            domain.getCommandStack().execute(command);
            GenerateDocumentStructureUtils.saveLastGeneratedDocumentVersion(documentTemplate, version);
            result = command.getResult();
            GenerateDocumentStructureUtils.refreshProjects(documentTemplate);
        }
        return result;
    }

    private static String getPreviousGeneratedVersion(DocumentTemplate docTemplate) {
        String xmiID = GenerateDocumentStructureUtils.getXMI_ID((EObject)docTemplate);
        if (xmiID == null) {
            return "";
        }
        File f = GenerateDocumentStructureUtils.getVersionFile();
        String lastVersion = "";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream input = new FileInputStream(f);){
                Properties prop = new Properties();
                prop.load(input);
                lastVersion = prop.getProperty(xmiID);
                ((InputStream)input).close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return lastVersion;
    }

    private static void saveLastGeneratedDocumentVersion(DocumentTemplate docTemplate, String version) {
        String xmiID = GenerateDocumentStructureUtils.getXMI_ID((EObject)docTemplate);
        if (xmiID == null) {
            return;
        }
        File f = GenerateDocumentStructureUtils.getVersionFile();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream output = new FileOutputStream(f);){
                Properties prop = new Properties();
                prop.setProperty(xmiID, version);
                prop.store(output, null);
                ((OutputStream)output).close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            Activator.log.error((Throwable)io);
        }
    }

    private static String getXMI_ID(EObject eobject) {
        if (eobject.eResource() instanceof XMIResource) {
            return ((XMIResource)eobject.eResource()).getID(eobject);
        }
        return null;
    }

    private static File getVersionFile() {
        File f;
        IPath preferencePath = Activator.getDefault().getStateLocation();
        preferencePath.append(MODEL2DOC_PREFERENCE_FOLDER_NAME);
        File folder = preferencePath.toFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(f = (preferencePath = preferencePath.append(VERSION_FILE_NAME).addFileExtension(PROPERTIES_FILE_EXTENSION)).toFile()).exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    private static void refreshProjects(DocumentTemplate documentTemplate) {
        Collection projectsToRefresh = GeneratorConfigurationOperations.getWorkspaceProjectToRefresh((IDocumentStructureGeneratorConfiguration)documentTemplate.getDocumentStructureGeneratorConfiguration());
        for (String current : projectsToRefresh) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(current);
            if (project == null) continue;
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log.error(NLS.bind((String)"An exception occurred refresh the project {0}", (Object)current), (Throwable)e);
            }
        }
    }
}

