/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.ieee.requirements.odt.transcriber;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrus.model2doc.core.transcription.Transcription;
import org.eclipse.papyrus.model2doc.integration.ieee.requirements.utils.IEEERequirementsDocumentationProfileHelper;
import org.eclipse.papyrus.sysml14.requirements.Requirement;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class IEEERequirementsTranscriber {
    private Package root = null;
    private Transcription transcription = null;
    private UMLLabelInternationalization umlLabelInternationalization = null;
    private List<Requirement> requirements = new ArrayList<Requirement>();

    public IEEERequirementsTranscriber(Package rootPackage, Transcription transcription) {
        this.root = rootPackage;
        this.transcription = transcription;
        this.umlLabelInternationalization = UMLLabelInternationalization.getInstance();
    }

    public void transcribe() {
        if (this.transcription.canExecute()) {
            Collection softwareSystemAttributes;
            Collection designConstraints;
            Collection performanceRequirements;
            this.transcription.writeCoverPage(null);
            IEEERequirementsDocumentationProfileHelper ieeReqProfileHelper = new IEEERequirementsDocumentationProfileHelper(this.root);
            this.transcription.writeSectionTitle("Specific Requirements", 1);
            this.transcribeExternalInterfaceRequirements(ieeReqProfileHelper);
            Map functionalRequirements = ieeReqProfileHelper.getFunctionalRequirementsWithMode();
            if (!functionalRequirements.isEmpty()) {
                this.transcription.writeSectionTitle("Functional Requirements", 2);
                for (Integer mode : functionalRequirements.keySet()) {
                    this.transcription.writeSectionTitle("Mode " + mode, 3);
                    this.transcribeRequirements((Collection)functionalRequirements.get(mode), 4);
                }
            }
            if (!(performanceRequirements = ieeReqProfileHelper.getPerformanceRequirements()).isEmpty()) {
                this.transcription.writeSectionTitle("Performance Requirements", 2);
                this.transcribeRequirements(performanceRequirements, 3);
            }
            if (!(designConstraints = ieeReqProfileHelper.getDesignConstraints()).isEmpty()) {
                this.transcription.writeSectionTitle("Design Constraints", 2);
                this.transcribeRequirements(designConstraints, 3);
            }
            if (!(softwareSystemAttributes = ieeReqProfileHelper.getSoftwareSystemAttributes()).isEmpty()) {
                this.transcription.writeSectionTitle("Software System Attributes", 2);
                this.transcribeRequirements(softwareSystemAttributes, 3);
            }
            Collection otherRequirements = ieeReqProfileHelper.getOtherRequirements();
            if (!softwareSystemAttributes.isEmpty()) {
                this.transcription.writeSectionTitle("Other Requirements", 2);
                this.transcribeRequirements(otherRequirements, 3);
            }
            this.transcription.save(this.umlLabelInternationalization.getLabel((NamedElement)this.root));
        }
    }

    private void transcribeExternalInterfaceRequirements(IEEERequirementsDocumentationProfileHelper ieeReqProfileHelper) {
        Collection userInterfaces = ieeReqProfileHelper.getUserInterfaces();
        Collection hardwaresInterfaces = ieeReqProfileHelper.getHardwaresInterfaces();
        Collection softwareInterfaces = ieeReqProfileHelper.getSoftwareInterfaces();
        Collection communicationInterfaces = ieeReqProfileHelper.getCommunicationInterfaces();
        if (!(userInterfaces.isEmpty() && hardwaresInterfaces.isEmpty() && softwareInterfaces.isEmpty() && communicationInterfaces.isEmpty())) {
            this.transcription.writeSectionTitle("External Interface Requirements", 2);
            if (!userInterfaces.isEmpty()) {
                this.transcription.writeSectionTitle("User Interfaces", 3);
                this.transcribeRequirements(userInterfaces, 4);
            }
            if (!hardwaresInterfaces.isEmpty()) {
                this.transcription.writeSectionTitle("Hardwares Interfaces", 3);
                this.transcribeRequirements(hardwaresInterfaces, 4);
            }
            if (!softwareInterfaces.isEmpty()) {
                this.transcription.writeSectionTitle("Software Interfaces", 3);
                this.transcribeRequirements(softwareInterfaces, 4);
            }
            if (!communicationInterfaces.isEmpty()) {
                this.transcription.writeSectionTitle("Communication Interfaces", 3);
                this.transcribeRequirements(communicationInterfaces, 4);
            }
        }
    }

    private void transcribeRequirements(Collection<Package> packages, int level) {
        for (Package pack : packages) {
            for (Type type : pack.getOwnedTypes()) {
                if (UMLUtil.getStereotypeApplication((Element)type, Requirement.class) == null) continue;
                this.requirements.add((Requirement)UMLUtil.getStereotypeApplication((Element)type, Requirement.class));
            }
            for (Requirement requirement : this.requirements) {
                this.transcription.writeSectionTitle(this.umlLabelInternationalization.getLabel((NamedElement)requirement.getBase_Class()), level);
                this.transcription.writeParagraph(requirement.getText(), false);
            }
        }
        this.requirements.clear();
    }
}

