/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.papyrus.infra.sync.SyncItem;

class SyncItemList<M, T>
implements Iterable<SyncItem<M, T>> {
    private List<SyncItem<M, T>> items = new ArrayList<SyncItem<M, T>>();

    @Override
    public Iterator<SyncItem<M, T>> iterator() {
        return new AbstractIterator<SyncItem<M, T>>(){
            private final Iterator<SyncItem<M, T>> delegate;
            {
                this.delegate = SyncItemList.this.items.iterator();
            }

            protected SyncItem<M, T> computeNext() {
                while (this.delegate.hasNext()) {
                    SyncItem item = this.delegate.next();
                    if (!item.isActive()) {
                        this.delegate.remove();
                        continue;
                    }
                    return item;
                }
                return (SyncItem)this.endOfData();
            }
        };
    }

    public Iterator<T> backendIterator() {
        return new AbstractIterator<T>(){
            private final Iterator<SyncItem<M, T>> delegate;
            {
                this.delegate = SyncItemList.this.items.iterator();
            }

            protected T computeNext() {
                while (this.delegate.hasNext()) {
                    Object backend = this.delegate.next().getBackend();
                    if (backend == null) {
                        this.delegate.remove();
                        continue;
                    }
                    return backend;
                }
                return this.endOfData();
            }
        };
    }

    public boolean contains(T item) throws IllegalArgumentException {
        if (item == null) {
            throw new IllegalArgumentException("The specified element must not be null");
        }
        int i = 0;
        while (i != this.items.size()) {
            SyncItem<M, T> potential = this.items.get(i);
            T backend = potential.getBackend();
            if (backend == null) {
                this.items.remove(i);
                --i;
            } else if (backend == item) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SyncItem<M, T> get(T item) throws IllegalArgumentException {
        if (item == null) {
            throw new IllegalArgumentException("The specified element must not be null");
        }
        int i = 0;
        while (i != this.items.size()) {
            SyncItem<M, T> potential = this.items.get(i);
            T backend = potential.getBackend();
            if (backend == null) {
                this.items.remove(i);
                --i;
            } else if (backend == item) {
                return potential;
            }
            ++i;
        }
        return null;
    }

    public void add(SyncItem<M, T> item) throws IllegalArgumentException {
        if (item == null) {
            throw new IllegalArgumentException("null item");
        }
        if (!item.isActive()) {
            throw new IllegalArgumentException("item is not enabled");
        }
        this.items.add(item);
    }

    public void remove(SyncItem<M, T> item) {
        if (item == null) {
            throw new IllegalArgumentException("null item");
        }
        int i = 0;
        while (i != this.items.size()) {
            SyncItem<M, T> potential = this.items.get(i);
            if (!potential.isActive()) {
                this.items.remove(i);
                --i;
            } else if (potential == item) {
                this.items.remove(i);
                return;
            }
            ++i;
        }
    }

    public void clear() {
        this.items.clear();
    }
}

