/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync.policy;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.papyrus.infra.sync.SyncFeature;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.policy.ISyncPolicy;
import org.eclipse.papyrus.infra.sync.policy.ISyncPolicyDelegate;

public class DefaultSyncPolicy
implements ISyncPolicy {
    private final ISyncPolicyDelegate.Registry delegateRegistry;

    public DefaultSyncPolicy(ISyncPolicyDelegate.Registry delegateRegistry) {
        this.delegateRegistry = delegateRegistry;
    }

    @Override
    public <M, T> boolean shouldSynchronize(SyncItem<M, T> from, SyncItem<M, T> to, SyncFeature<M, T, ?> feature) {
        ISyncPolicyDelegate<M, T> delegate = this.delegateRegistry.get(feature);
        return delegate == null || delegate.shouldSynchronize(from, to);
    }

    @Override
    public <M, T> Iterable<? extends SyncItem<M, T>> filter(final SyncItem<M, T> from, Iterable<? extends SyncItem<M, T>> to, SyncFeature<M, T, ?> feature) {
        final ISyncPolicyDelegate<M, T> delegate = this.delegateRegistry.get(feature);
        return delegate == null ? to : Iterables.filter(to, (Predicate)new Predicate<SyncItem<M, T>>(){

            public boolean apply(SyncItem<M, T> input) {
                return delegate.shouldSynchronize(from, input);
            }
        });
    }

    @Override
    public <M, T, X> Iterable<? extends SyncFeature<M, T, X>> filter(final SyncItem<M, T> from, final SyncItem<M, T> to, Iterable<? extends SyncFeature<M, T, X>> features) {
        return Iterables.filter(features, (Predicate)new Predicate<SyncFeature<M, T, X>>(){

            public boolean apply(SyncFeature<M, T, X> input) {
                return DefaultSyncPolicy.this.shouldSynchronize(from, to, input);
            }
        });
    }

    @Override
    public <M, T> void observe(SyncItem<M, T> syncTarget, SyncFeature<M, T, ?> feature) {
        ISyncPolicyDelegate<M, T> delegate = this.delegateRegistry.get(feature);
        if (delegate != null) {
            delegate.observe(syncTarget);
        }
    }
}

