/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.alf.AlfMapper;
import org.eclipse.papyrus.uml.alf.MappingError;
import org.eclipse.papyrus.uml.alf.ParsingError;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;

public class AlfCompiler
extends AlfMapper {
    protected NamedElement contextElement = null;
    protected IParser parser = (IParser)this.getInjector().getInstance(IParser.class);

    public AlfCompiler() {
    }

    public AlfCompiler(ResourceSet resourceSet) {
        super(resourceSet);
    }

    public AlfCompiler(NamedElement contextElement) {
        this(contextElement.eResource().getResourceSet());
        this.setContextElement(contextElement);
    }

    public AlfCompiler(NamedElement contextElement, Profile standardProfile, Profile actionLanguageProfile) {
        super(contextElement.eResource().getResourceSet(), standardProfile, actionLanguageProfile);
        this.setContextElement(contextElement);
    }

    public void setContextElement(NamedElement contextElement) {
        this.contextElement = contextElement;
    }

    public EObject parse(String textualRepresentation) throws ParsingError {
        IParseResult result = this.parser.parse((Reader)new StringReader(textualRepresentation));
        if (result.hasSyntaxErrors()) {
            throw new ParsingError(result.getSyntaxErrors());
        }
        return result.getRootASTElement();
    }

    public void compile(String textualRepresentation) throws ParsingError, MappingError {
        BasicEList alf = new BasicEList();
        alf.add(this.parse(textualRepresentation));
        this.map(this.contextElement, (List<EObject>)alf);
        this.clean();
    }
}

