/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.wizard;

import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.uml.m2m.qvto.common.Activator;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.AbstractImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages.AbstractDialogData;
import org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages.TransformationConfigPage;
import org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages.TransformationSelectionPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractTransformationWizard
extends Wizard
implements IImportWizard {
    protected IWizardPage currentPage;
    protected final AbstractDialogData dialogData;
    protected TransformationSelectionPage selectionPage;
    protected TransformationConfigPage configPage;

    public AbstractTransformationWizard(String wizardTitle, AbstractDialogData dialogData) {
        this.setWindowTitle(wizardTitle);
        this.dialogData = dialogData;
    }

    public void addPages() {
        this.selectionPage = this.createTransformationSelectionPage(this.dialogData);
        this.addPage((IWizardPage)this.selectionPage);
        this.configPage = this.createTransformationConfigPage(this.dialogData);
        this.addPage((IWizardPage)this.configPage);
    }

    protected TransformationSelectionPage createTransformationSelectionPage(AbstractDialogData dialogData) {
        return new TransformationSelectionPage(dialogData);
    }

    protected TransformationConfigPage createTransformationConfigPage(AbstractDialogData dialogData) {
        return new TransformationConfigPage(dialogData);
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage == this.selectionPage) {
            this.currentPage = this.configPage;
            this.configPage.resetViewerInput();
            return this.configPage;
        }
        if (this.currentPage == this.configPage) {
            this.currentPage = this.selectionPage;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.currentPage == this.configPage) {
            return super.canFinish();
        }
        return false;
    }

    public boolean performCancel() {
        this.removeWizardImportedProjects();
        return super.performCancel();
    }

    public boolean performFinish() {
        this.dialogData.setSelectionMap();
        this.importFiles();
        return true;
    }

    public void removeWizardImportedProjects() {
        if (this.dialogData.getImportedProjects() != null) {
            for (Object object : this.dialogData.getImportedProjects()) {
                if (!(object instanceof IProject)) continue;
                IProject project = (IProject)object;
                try {
                    project.delete(false, true, null);
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    protected void importFiles() {
        ThreadConfig config = this.dialogData.getConfig();
        if (config == null) {
            return;
        }
        LinkedList<URI> urisToImport = new LinkedList<URI>();
        for (Object selectedFile : this.dialogData.getTransformationFiles()) {
            String path = null;
            if (selectedFile instanceof IFile) {
                path = ((IFile)selectedFile).getFullPath().toString();
            }
            if (path == null) continue;
            URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
            urisToImport.add(uri);
        }
        AbstractImportTransformationLauncher launcher = this.createTransformationLauncher(config, (Control)this.getShell().getParent());
        launcher.run(urisToImport);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected abstract AbstractImportTransformationLauncher createTransformationLauncher(ThreadConfig var1, Control var2);
}

