/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.junit.utils.rules.PapyrusEditorFixture;
import org.eclipse.papyrus.sirius.editor.representation.SiriusDiagramPrototype;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.tools.internal.preferences.SiriusDiagramInternalPreferencesKeys;
import org.eclipse.sirius.tests.support.api.SiriusAssert;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.uml2.uml.Package;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractDiagramCreationTests
extends AbstractSiriusDiagramTests {
    private static final int DEFAULT_NUMBER_GRAPHICAL_ELEMENTS = 2;
    protected Package rootModel;
    private final HashMap<String, Object> oldValueDiagramPreferences = new HashMap();
    @Rule
    public final PapyrusEditorFixture fixture = new PapyrusEditorFixture();
    private int expectedGraphicalElementsAfterInit;

    @Before
    public void setUp() {
        this.rootModel = this.fixture.getModel();
        this.expectedGraphicalElementsAfterInit = 2;
        this.changeDiagramPreference(SiriusDiagramInternalPreferencesKeys.PREF_SYNCHRONIZE_DIAGRAM_ON_CREATION.name(), Boolean.FALSE);
    }

    protected final Resource getAIRDResourceForCurrentModel() {
        for (Resource current : this.fixture.getResourceSet().getResources()) {
            if (!"aird".equals(current.getURI().fileExtension()) || !this.fixture.getModelResourceURI().trimFileExtension().equals(current.getURI().trimFileExtension())) continue;
            return current;
        }
        return null;
    }

    protected Collection<ViewPrototype> getCreatableDiagramPrototype(EObject context) {
        ArrayList<ViewPrototype> viewPrototype = new ArrayList<ViewPrototype>();
        for (ViewPrototype proto : PolicyChecker.getFor((EObject)context).getPrototypesFor(context)) {
            viewPrototype.add(proto);
        }
        return viewPrototype;
    }

    protected final ViewPrototype getDiagramPrototype(EObject context, String type) {
        for (ViewPrototype current : this.getCreatableDiagramPrototype(context)) {
            SiriusDiagramPrototype pdp;
            if (!(current.getRepresentationKind() instanceof SiriusDiagramPrototype) || !type.equals((pdp = (SiriusDiagramPrototype)current.getRepresentationKind()).getId())) continue;
            return current;
        }
        return null;
    }

    protected void checkDiagramCreationFromSiriusDiagramPrototype(EObject diagramInstantiaterOwner, String diagramName, String type) {
        this.checkDiagramCreationFromSiriusDiagramPrototypeWithRootOrNot(diagramInstantiaterOwner, diagramName, type, null);
    }

    protected void checkDiagramCreationFromSiriusDiagramPrototypeWithRootCreation(EObject diagramInstantiaterOwner, String diagramName, String type, Class<?> semanticOwnerType) {
        this.checkDiagramCreationFromSiriusDiagramPrototypeWithRootOrNot(diagramInstantiaterOwner, diagramName, type, semanticOwnerType);
    }

    private void checkDiagramCreationFromSiriusDiagramPrototypeWithRootOrNot(EObject diagramInstantiaterOwner, String diagramName, String type, Class<?> semanticOwnerType) {
        ViewPrototype diagramPrototype = this.getDiagramPrototype(this.fixture.getRoot(), type);
        Assert.assertNotNull((String)NLS.bind((String)"The DiagramPrototype to create a diagram of type {0} is not found.", (Object)type), (Object)diagramPrototype);
        Resource airdResource = this.getAIRDResourceForCurrentModel();
        Assert.assertNotNull((String)"The aird resource is not in the ModelSet.", (Object)airdResource);
        EList initialAirdContents = airdResource.getContents();
        Assert.assertEquals((String)"The aird resource must contains only one element", (long)1L, (long)initialAirdContents.size());
        Assert.assertTrue((boolean)(initialAirdContents.get(0) instanceof DAnalysis));
        boolean airdFileExists = airdResource.getResourceSet().getURIConverter().exists(airdResource.getURI(), null);
        Assert.assertTrue((String)"The aird file doesn't exist, but it should already be created.", (boolean)airdFileExists);
        boolean succeed = diagramPrototype.instantiateOn(diagramInstantiaterOwner, diagramName, true);
        this.fixture.flushDisplayEvents();
        Assert.assertTrue((String)"The instantiation of the diagram failed", (boolean)succeed);
        EList airdContents = airdResource.getContents();
        Assert.assertEquals((long)2L, (long)airdContents.size());
        Assert.assertTrue((boolean)(airdContents.get(0) instanceof DAnalysis));
        Assert.assertTrue((boolean)(airdContents.get(1) instanceof DSemanticDiagram));
        DSemanticDiagram dDiagram = (DSemanticDiagram)airdContents.get(1);
        EObject semanticOwner = null;
        if (semanticOwnerType == null) {
            Assert.assertEquals((String)"The created diagram must be empty", (long)0L, (long)dDiagram.getDiagramElements().size());
            semanticOwner = diagramInstantiaterOwner;
        } else {
            Assert.assertEquals((String)"The created diagram must contain the root (and its compartment)", (long)this.getExpectedGraphicalElementsAfterInit(), (long)dDiagram.getDiagramElements().size());
            semanticOwner = this.getSemanticOwner(diagramInstantiaterOwner, semanticOwnerType);
        }
        Assert.assertEquals((String)"The created diagram hasn't the expected semanticOwner", (Object)semanticOwner, (Object)dDiagram.getTarget());
        Assert.assertEquals((String)"The created diagram hasn't the expected name", (Object)diagramName, (Object)dDiagram.getName());
        DAnnotation annotation = dDiagram.getDAnnotation("Papyrus-SiriusDiagram");
        String implementationId = (String)annotation.getDetails().get((Object)"Papyrus-SiriusDiagram-ImplementationId");
        Assert.assertEquals((String)"The created diagram hasn't the expected implementationId", (Object)type, (Object)implementationId);
        Diagram diagram = this.fixture.getActiveDiagram().getDiagramView();
        Assert.assertNotNull((String)"The created GMF Diagram must not be null", (Object)diagram);
        Assert.assertEquals((String)"The element associated to the GMF Diagram must be the DSemanticDiagram", (Object)dDiagram, (Object)diagram.getElement());
    }

    protected int getExpectedGraphicalElementsAfterInit() {
        return this.expectedGraphicalElementsAfterInit;
    }

    protected void setExpectedGraphicalElementsAfterInit(int expectedGraphicalElementsAfterInit) {
        this.expectedGraphicalElementsAfterInit = expectedGraphicalElementsAfterInit;
    }

    private EObject getSemanticOwner(EObject parentSemanticOwner, Class<?> class1) {
        if (class1.isAssignableFrom(parentSemanticOwner.getClass())) {
            return parentSemanticOwner;
        }
        List potentialSemanticOwner = parentSemanticOwner.eContents().stream().filter(class1::isInstance).map(class1::cast).collect(Collectors.toList());
        return (EObject)potentialSemanticOwner.get(potentialSemanticOwner.size() - 1);
    }

    protected void changeDiagramPreference(String preferenceKey, Boolean newValue) {
        SiriusAssert.assertNoDiagramUIPreferenceChangedinDiagramCoreStore((String)preferenceKey);
        boolean oldValue = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", preferenceKey, false, null);
        this.oldValueDiagramPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences diagramCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        diagramCorePreferences.putBoolean(preferenceKey, newValue.booleanValue());
        boolean valueToCheck = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", preferenceKey, false, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius.diagram"), (boolean)newValue, (boolean)valueToCheck);
    }

    private String getErrorMessage(String preferenceKey, String pluginId) {
        return "The " + preferenceKey + " preference value was not changed for plugin " + pluginId;
    }

    private void resetDiagramPreference(String preferenceKey, IEclipsePreferences diagramCorePreferences) {
        Object initialValue = this.oldValueDiagramPreferences.get(preferenceKey);
        if (initialValue instanceof Boolean) {
            diagramCorePreferences.putBoolean(preferenceKey, ((Boolean)initialValue).booleanValue());
        } else if (initialValue instanceof Integer) {
            diagramCorePreferences.putInt(preferenceKey, ((Integer)initialValue).intValue());
        }
    }

    @After
    public void tearDown() {
        this.rootModel = null;
        IEclipsePreferences diagamCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        for (String key : this.oldValueDiagramPreferences.keySet()) {
            this.resetDiagramPreference(key, diagamCorePreferences);
        }
    }
}

