/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet.chooser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.uml2.diagram.common.Messages;
import org.eclipse.uml2.diagram.common.sheet.chooser.ElementChooserPage;
import org.eclipse.uml2.diagram.common.sheet.chooser.ElementFilteredListChooser;
import org.eclipse.uml2.diagram.common.sheet.chooser.ElementTreeChooser;
import org.eclipse.uml2.diagram.common.sheet.chooser.QualifiedNameLabelProvider;
import org.eclipse.uml2.uml.ElementImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedElementChooser {
    private final AdapterFactory myItemProvidersAdapterFactory;
    private final EObject mySourceObject;
    private final EStructuralFeature myFeature;
    private final IDialogSettings myDialogSettings;
    private ElementChooserPage myCurrentPage;
    private final String mySettingsKeyLastFocus = "ReferencedElementDialog.KeyLastFocus";
    private TabFolder myTabFolder;
    private CLabel myDetailLabel;
    private LabelProviderWithContext myDetailLabelProvider;
    private final ElementChooserPage.Validator myValidator;
    private ElementTreeChooser myTreeChooserTab;
    private ElementFilteredListChooser myListChooserPage;
    private final TransactionalEditingDomain myEditingDomain;

    public TabbedElementChooser(IDialogSettings settings, AdapterFactory itemProvidersAdapterFactory, EObject sourceObject, EStructuralFeature feature, TransactionalEditingDomain editingDomain) {
        this.myDialogSettings = settings;
        this.myItemProvidersAdapterFactory = itemProvidersAdapterFactory;
        this.mySourceObject = sourceObject;
        this.myFeature = feature;
        this.myEditingDomain = editingDomain;
        this.myValidator = new FeatureValueValidator(feature);
        this.myDetailLabelProvider = this.getDetailLabelProvider();
    }

    public Control createDialogArea(Composite composite) {
        Composite plate = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        plate.setLayout((Layout)layout);
        this.createTabFolder(plate);
        this.myTreeChooserTab = new ElementTreeChooser(this.myItemProvidersAdapterFactory, this.mySourceObject, this.myFeature, this.myEditingDomain);
        TabbedElementChooser.addTabPage(Messages.TabbedElementChooser_tab_choose_from_a_tree, this.myTabFolder, this.myTreeChooserTab);
        this.myListChooserPage = new ElementFilteredListChooser(this.myItemProvidersAdapterFactory, this.mySourceObject, this.myFeature, this.myValidator, this.myEditingDomain);
        TabbedElementChooser.addTabPage(Messages.TabbedElementChooser_tab_choose_from_a_list, this.myTabFolder, this.myListChooserPage);
        this.myCurrentPage = (ElementChooserPage)this.myTabFolder.getSelection()[0].getData();
        this.myTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabbedElementChooser.this.tabChanged((TabItem)e.item);
                TabbedElementChooser.this.myDialogSettings.put("ReferencedElementDialog.KeyLastFocus", TabbedElementChooser.this.myTabFolder.getSelectionIndex());
            }
        });
        this.createDetailLabel(plate);
        return plate;
    }

    private void createTabFolder(Composite plate) {
        this.myTabFolder = new TabFolder(plate, 0);
        this.myTabFolder.setFont(plate.getFont());
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 400;
        layoutData.heightHint = 400;
        this.myTabFolder.setLayoutData((Object)layoutData);
    }

    protected LabelProviderWithContext getDetailLabelProvider() {
        return new QualifiedNameLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.myItemProvidersAdapterFactory));
    }

    private void createDetailLabel(Composite parent) {
        GridData layoutData = new GridData();
        layoutData.grabExcessVerticalSpace = false;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 1;
        Composite plate = new Composite(parent, 0x800800);
        plate.setLayoutData((Object)layoutData);
        plate.setLayout((Layout)new FillLayout());
        this.myDetailLabel = new CLabel(plate, 0);
        this.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List<?> selection = TabbedElementChooser.this.getSelection();
                if (selection.size() == 1) {
                    Object selected = selection.get(0);
                    String text = TabbedElementChooser.this.myDetailLabelProvider.getText(selected);
                    if (text == null) {
                        text = "";
                    }
                    TabbedElementChooser.this.myDetailLabel.setText(text);
                    Image image = TabbedElementChooser.this.myDetailLabelProvider.getImage(selected);
                    TabbedElementChooser.this.myDetailLabel.setImage(image);
                }
            }
        });
    }

    public ElementChooserPage.Validator getValidator() {
        return this.myValidator;
    }

    private static void addTabPage(String title, TabFolder myTabFolder, ElementChooserPage tabPage) {
        TabItem tabItem = new TabItem(myTabFolder, 0);
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl(tabPage.createControl((Composite)myTabFolder));
    }

    private void tabChanged(TabItem tabItem) {
        ElementChooserPage newPage = (ElementChooserPage)tabItem.getData();
        tabItem.getControl().setFocus();
        if (this.myCurrentPage != null) {
            newPage.setSelection(this.myCurrentPage.getSelection());
        }
        this.myCurrentPage = newPage;
    }

    public void initSelection() {
        int lastFocusNr = 0;
        try {
            lastFocusNr = this.myDialogSettings.getInt("ReferencedElementDialog.KeyLastFocus");
            if (lastFocusNr < 0 || lastFocusNr > this.myTabFolder.getItemCount()) {
                lastFocusNr = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            lastFocusNr = 0;
        }
        this.myTabFolder.setSelection(lastFocusNr);
        this.myCurrentPage = (ElementChooserPage)this.myTabFolder.getSelection()[0].getData();
        this.myCurrentPage.setSelection(this.getInitialSelection());
    }

    protected List<?> getInitialSelection() {
        Object featureValue = this.mySourceObject.eGet(this.myFeature);
        if (this.myFeature.isMany()) {
            Collection a = (Collection)featureValue;
            return new ArrayList(a);
        }
        return Collections.singletonList(featureValue);
    }

    public List<?> getSelection() {
        return this.myCurrentPage.getSelection();
    }

    public void setSelection(List<?> selection) {
        this.myCurrentPage.setSelection(selection);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.myListChooserPage.addDoubleClickListener(listener);
        this.myTreeChooserTab.addDoubleClickListener(listener);
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.myListChooserPage.addSelectionListener(listener);
        this.myTreeChooserTab.addSelectionListener(listener);
    }

    private static class FeatureValueValidator
    implements ElementChooserPage.Validator {
        private final EStructuralFeature myFeature;

        public FeatureValueValidator(EStructuralFeature feature) {
            this.myFeature = feature;
        }

        public EObject validate(Object object) {
            if (!(object instanceof EObject)) {
                return null;
            }
            EObject eobject = (EObject)object;
            if (eobject instanceof ElementImport) {
                ElementImport _import = (ElementImport)eobject;
                eobject = _import.getImportedElement();
            }
            if (eobject != null && this.myFeature.getEType().isInstance((Object)eobject)) {
                return eobject;
            }
            return null;
        }
    }

    public static interface LabelProviderWithContext
    extends ILabelProvider {
        public void setContext(Object ... var1);
    }
}

