/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.component.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;

public class AssemblyConnectorEndRoleReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public AssemblyConnectorEndRoleReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Connector)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        return false;
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ConnectableElement) || !(this.newEnd instanceof ConnectableElement)) {
            return false;
        }
        return this.findConectorEnd((ConnectableElement)this.oldEnd) != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        throw new IllegalStateException("Source is fixed");
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        ConnectorEnd end = this.findConectorEnd(this.getOldTarget());
        end.setRole(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected ConnectorEnd getOldSource() {
        throw new IllegalStateException();
    }

    protected ConnectorEnd getNewSource() {
        return (ConnectorEnd)this.newEnd;
    }

    protected ConnectableElement getOldTarget() {
        return (ConnectableElement)this.oldEnd;
    }

    protected ConnectableElement getNewTarget() {
        return (ConnectableElement)this.newEnd;
    }

    private Connector getAssemblyConnector() {
        return (Connector)this.referenceOwner;
    }

    private ConnectorEnd findConectorEnd(ConnectableElement diagramEnd) {
        for (ConnectorEnd nextEnd : this.getAssemblyConnector().getEnds()) {
            if (!diagramEnd.equals(nextEnd.getRole())) continue;
            return nextEnd;
        }
        return null;
    }
}

