/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.statemachine.edit.policies;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.uml2.diagram.statemachine.part.Messages;
import org.eclipse.uml2.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.statemachine.part.UMLDiagramEditorUtil;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.State;

public class OpenDiagramEditPolicy
extends OpenEditPolicy {
    protected Command getOpenCommand(Request request) {
        EditPart targetEditPart = this.getTargetEditPart(request);
        if (!(targetEditPart.getModel() instanceof View)) {
            return null;
        }
        View view = (View)targetEditPart.getModel();
        Style link = view.getStyle(NotationPackage.eINSTANCE.getHintedDiagramLinkStyle());
        if (!(link instanceof HintedDiagramLinkStyle)) {
            return null;
        }
        return new ICommandProxy((ICommand)new OpenDiagramCommand((HintedDiagramLinkStyle)link));
    }

    protected static String getDiagramName(EObject diagramDomainElement) {
        NamedElement named;
        String result = null;
        if (diagramDomainElement instanceof NamedElement && ((result = (named = (NamedElement)diagramDomainElement).getQualifiedName()) == null || result.length() == 0)) {
            result = named.getName();
        }
        return result;
    }

    private static class OpenDiagramCommand
    extends AbstractTransactionalCommand {
        private final HintedDiagramLinkStyle diagramFacet;

        OpenDiagramCommand(HintedDiagramLinkStyle linkStyle) {
            super(TransactionUtil.getEditingDomain((EObject)linkStyle), Messages.CommandName_OpenDiagram, null);
            this.diagramFacet = linkStyle;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.selectSubmachineOnOpenDiagrams(this.getDiagramDomainElement())) {
                return CommandResult.newOKCommandResult();
            }
            return this.doExecuteWithResultGen(monitor, info);
        }

        protected CommandResult doExecuteWithResultGen(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                Diagram diagram = this.getDiagramToOpen();
                if (diagram == null) {
                    diagram = this.intializeNewDiagram();
                }
                URI uri = diagram.eResource().getURI();
                uri = uri.appendFragment(diagram.eResource().getURIFragment((EObject)diagram));
                String diagramName = OpenDiagramEditPolicy.getDiagramName(this.getDiagramDomainElement());
                URIEditorInput editorInput = new URIEditorInput(uri, diagramName);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)editorInput, this.getEditorID());
                return CommandResult.newOKCommandResult();
            }
            catch (Exception ex) {
                throw new ExecutionException("Can't open diagram", (Throwable)ex);
            }
        }

        protected Diagram getDiagramToOpen() {
            return this.diagramFacet.getDiagramLink();
        }

        protected Diagram intializeNewDiagram() throws ExecutionException {
            Diagram d = ViewService.createDiagram((EObject)this.getDiagramDomainElement(), (String)this.getDiagramKind(), (PreferencesHint)this.getPreferencesHint());
            if (d == null) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind");
            }
            this.diagramFacet.setDiagramLink(d);
            assert (this.diagramFacet.eResource() != null);
            this.diagramFacet.eResource().getContents().add((Object)d);
            try {
                new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            for (Resource nextResource : OpenDiagramCommand.this.diagramFacet.eResource().getResourceSet().getResources()) {
                                if (!nextResource.isLoaded() || OpenDiagramCommand.this.getEditingDomain().isReadOnly(nextResource)) continue;
                                nextResource.save(UMLDiagramEditorUtil.getSaveOptions());
                            }
                        }
                        catch (IOException ex) {
                            throw new InvocationTargetException(ex, "Save operation failed");
                        }
                    }
                }.run(null);
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind", (Throwable)e);
            }
            return d;
        }

        protected EObject getDiagramDomainElement() {
            EObject domainElement = this.getDiagramDomainElementGen();
            if (domainElement instanceof State) {
                State state = (State)domainElement;
                return state.getSubmachine();
            }
            return domainElement;
        }

        protected EObject getDiagramDomainElementGen() {
            return ((View)this.diagramFacet.eContainer()).getElement();
        }

        protected PreferencesHint getPreferencesHint() {
            return UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        }

        protected String getDiagramKind() {
            return "UMLStateMachine";
        }

        protected String getEditorID() {
            return "org.eclipse.uml2.diagram.statemachine.part.UMLDiagramEditorID";
        }

        private boolean selectSubmachineOnOpenDiagrams(EObject submachine) {
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] editorRefs = workbenchPage.getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                DiagramEditPart diagramEditPart;
                EditPart editPart;
                IEditorPart editorPart = editorRefs[i].getEditor(true);
                if (editorPart instanceof DiagramEditor && (editPart = this.findTopLevelElementInDiagram(diagramEditPart = ((DiagramEditor)editorPart).getDiagramEditPart(), submachine)) != null) {
                    if (this.getDiagramToOpen() == null) {
                        this.diagramFacet.setDiagramLink(((DiagramEditor)editorPart).getDiagram());
                    }
                    workbenchPage.activate((IWorkbenchPart)editorPart);
                    diagramEditPart.getViewer().select(editPart);
                    return true;
                }
                ++i;
            }
            return false;
        }

        private EditPart findTopLevelElementInDiagram(DiagramEditPart diagramEditPart, EObject element) {
            IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)diagramEditPart.getViewer();
            String elementID = EMFCoreUtil.getProxyID((EObject)element);
            List foundEditParts = viewer.findEditPartsForElement(elementID, IGraphicalEditPart.class);
            for (EditPart editPart : foundEditParts) {
                if (editPart instanceof DiagramEditPart) continue;
                return editPart;
            }
            return null;
        }
    }
}

