/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.action;

import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.clazz.edit.commands.ChangeDependencyTypeCommand;
import org.eclipse.uml2.diagram.clazz.providers.UMLElementTypes;

public class ChangeDependencyType
extends DiagramAction {
    EClass dependencyType;

    public ChangeDependencyType(IWorkbenchPage workbenchPage, EClass type, String actionId) {
        super(workbenchPage);
        this.setId(actionId);
        this.dependencyType = type;
    }

    public void init() {
        super.init();
        this.setText(this.dependencyType.getInstanceTypeName());
        this.setImageDescriptor(UMLElementTypes.getImageDescriptor(UMLElementTypes.getElement((IAdaptable)UMLElementTypes.Interface_2010)));
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean calculateEnabled() {
        return super.calculateEnabled() && this.dependencyType != null && !this.dependencyType.equals(this.getDependencyType());
    }

    protected Command getCommand() {
        ConnectionEditPart editPart = this.getSelectedEditPart();
        if (editPart == null) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand();
        ChangeDependencyTypeCommand changeTypeCommand = new ChangeDependencyTypeCommand(this.getSelectedEditPart(), this.dependencyType, this.getPreferencesHint());
        command.add((Command)changeTypeCommand);
        SelectEditPartCommand selectCommand = new SelectEditPartCommand((EditPartViewer)this.getDiagramGraphicalViewer(), changeTypeCommand.getElementDescriptor());
        command.add((Command)selectCommand);
        return command;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    private ConnectionEditPart getSelectedEditPart() {
        for (Object ob : this.getSelectedObjects()) {
            if (!(ob instanceof ConnectionEditPart)) continue;
            return (ConnectionEditPart)ob;
        }
        return null;
    }

    private EClass getDependencyType() {
        ConnectionEditPart editPart = this.getSelectedEditPart();
        if (editPart == null) {
            return null;
        }
        View view = (View)editPart.getModel();
        if (view == null) {
            return null;
        }
        return view.getElement().eClass();
    }

    private static class SelectEditPartCommand
    extends Command {
        private EditPartViewer viewer;
        private CreateConnectionViewRequest.ConnectionViewDescriptor descriptor;

        SelectEditPartCommand(EditPartViewer viewer, CreateConnectionViewRequest.ConnectionViewDescriptor descriptor) {
            this.viewer = viewer;
            this.descriptor = descriptor;
        }

        public void execute() {
            super.execute();
            EditPart editPart = this.getEditPart();
            if (this.viewer == null || editPart == null) {
                return;
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(Collections.singletonList(editPart)));
        }

        private EditPart getEditPart() {
            View view = (View)this.descriptor.getAdapter(View.class);
            EditPart editPart = (EditPart)this.viewer.getEditPartRegistry().get(view);
            return editPart;
        }
    }
}

