/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ConnectionManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EdgeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.IteratedEdge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingPartition;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class MappingPartitionAnalysis<P extends MappingPartition>
extends AbstractPartitionAnalysis<P> {
    private @Nullable Node dispatchNode = null;
    private final @NonNull List<@NonNull Node> constantInputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> constantOutputNodes = new ArrayList<Node>();
    private final @NonNull Set<@NonNull NavigableEdge> oldPrimaryNavigableEdges = new HashSet<NavigableEdge>();
    private final @NonNull List<@NonNull Node> loadedInputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Edge> predicatedEdges = new ArrayList<Edge>();
    private final @NonNull List<@NonNull NavigableEdge> predicatedMiddleEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> predicatedMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull NavigableEdge> predicatedOutputEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> predicatedOutputNodes = new ArrayList<Node>();
    private final @NonNull Set<@NonNull NavigableEdge> realizedEdges = new HashSet<NavigableEdge>();
    private final @NonNull List<@NonNull NavigableEdge> realizedMiddleEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> realizedMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull NavigableEdge> realizedOutputEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> realizedOutputNodes = new ArrayList<Node>();
    private final @NonNull Set<@NonNull SuccessEdge> successEdges = new HashSet<SuccessEdge>();
    private final @NonNull List<@NonNull Node> traceNodes = new ArrayList<Node>();
    private @Nullable List<@NonNull TraceClassPartitionAnalysis> consumedTraceClassAnalyses = null;
    private @Nullable List<@NonNull TracePropertyPartitionAnalysis> consumedTracePropertyAnalyses = null;
    private @Nullable List<@NonNull TraceClassPartitionAnalysis> producedTraceClassAnalyses = null;
    private @Nullable List<@NonNull TracePropertyPartitionAnalysis> producedTracePropertyAnalyses = null;
    private @Nullable Set<@NonNull TraceClassPartitionAnalysis> superProducedTraceClassAnalyses = null;

    protected MappingPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull P partition) {
        super(partitionedTransformationAnalysis, partition);
    }

    private void addCheckedEdge(@NonNull NavigableEdge checkedEdge) {
        Role role = ((MappingPartition)this.partition).getRole((Edge)checkedEdge);
        assert (role != null && role.isChecked());
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)checkedEdge.getEdgeSource());
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
        ((MappingPartition)this.partition).addCheckedEdge(typedModel, checkedEdge);
        QVTscheduleConstants.POLLED_PROPERTIES.println("    checked " + checkedEdge.getProperty() + " at " + ((MappingPartition)this.partition).getPassRangeText() + " in " + typedModel + " for " + this.partition);
    }

    private void addConstantNode(@NonNull Node node) {
        assert (this.isConstant(node));
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!edge.isComputation() && (!edge.isCast() && !edge.isNavigation() || this.isRealized(edge))) continue;
            this.constantOutputNodes.add(node);
            return;
        }
        this.constantInputNodes.add(node);
    }

    private void addConsumptionOfEdge(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull NavigableEdge edge) {
        Property property = QVTscheduleUtil.getProperty((NavigableEdge)edge);
        if (property == this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty()) {
            Node targetNode;
            Node castTarget = targetNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)castTarget);
            for (PropertyDatum propertyDatum : this.scheduleManager.getOclContainerPropertyDatums(classDatum)) {
                this.addConsumptionOfPropertyDatum(partitionedTransformationAnalysis, propertyDatum);
            }
        } else {
            PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(edge);
            this.addConsumptionOfPropertyDatum(partitionedTransformationAnalysis, propertyDatum);
        }
    }

    private void addConsumptionOfInputNode(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Node node) {
        if (node.isClass() && !this.loadedInputNodes.contains(node)) {
            this.loadedInputNodes.add(node);
            this.addConsumptionOfNode(partitionedTransformationAnalysis, node);
        }
    }

    private void addConsumptionOfMiddleEdge(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull NavigableEdge edge) {
        if (!this.predicatedMiddleEdges.contains(edge)) {
            this.predicatedMiddleEdges.add(edge);
            this.addConsumptionOfEdge(partitionedTransformationAnalysis, edge);
        }
    }

    private void addConsumptionOfMiddleNode(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Node node) {
        if (!this.predicatedMiddleNodes.contains(node)) {
            this.predicatedMiddleNodes.add(node);
            this.addConsumptionOfNode(partitionedTransformationAnalysis, node);
        }
    }

    private void addConsumptionOfNode(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Node node) {
        Node castNode = QVTscheduleUtil.getCastTarget((Node)node);
        TraceClassPartitionAnalysis consumedTraceAnalysis = partitionedTransformationAnalysis.addConsumer(QVTscheduleUtil.getClassDatum((Node)castNode), (PartitionAnalysis)this);
        List<@NonNull TraceClassPartitionAnalysis> consumedTraceClassAnalyses2 = this.consumedTraceClassAnalyses;
        if (consumedTraceClassAnalyses2 == null) {
            this.consumedTraceClassAnalyses = consumedTraceClassAnalyses2 = new ArrayList<TraceClassPartitionAnalysis>();
        }
        if (!consumedTraceClassAnalyses2.contains(consumedTraceAnalysis)) {
            consumedTraceClassAnalyses2.add(consumedTraceAnalysis);
        }
    }

    private void addConsumptionOfOutputEdge(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull NavigableEdge edge) {
        if (!this.predicatedOutputEdges.contains(edge)) {
            this.predicatedOutputEdges.add(edge);
            this.addConsumptionOfEdge(partitionedTransformationAnalysis, edge);
        }
    }

    private void addConsumptionOfOutputNode(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Node node) {
        if (!this.predicatedOutputNodes.contains(node)) {
            this.predicatedOutputNodes.add(node);
            this.addConsumptionOfNode(partitionedTransformationAnalysis, node);
        }
    }

    private void addConsumptionOfPropertyDatum(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull PropertyDatum propertyDatum) {
        TracePropertyPartitionAnalysis consumedTraceAnalysis = partitionedTransformationAnalysis.addConsumer(propertyDatum, (PartitionAnalysis)this);
        List<@NonNull TracePropertyPartitionAnalysis> consumedTracePropertyAnalyses2 = this.consumedTracePropertyAnalyses;
        if (consumedTracePropertyAnalyses2 == null) {
            this.consumedTracePropertyAnalyses = consumedTracePropertyAnalyses2 = new ArrayList<TracePropertyPartitionAnalysis>();
        }
        if (!consumedTracePropertyAnalyses2.contains(consumedTraceAnalysis)) {
            consumedTracePropertyAnalyses2.add(consumedTraceAnalysis);
        }
    }

    @Override
    public void addEnforcedEdge(@NonNull NavigableEdge realizedEdge) {
        Role role = ((MappingPartition)this.partition).getRole((Edge)realizedEdge);
        assert (role != null && role.isRealized());
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)realizedEdge.getEdgeSource());
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
        Property asProperty = ((MappingPartition)this.partition).addEnforcedEdge(typedModel, realizedEdge);
        QVTscheduleConstants.POLLED_PROPERTIES.println("    enforced " + asProperty + " at " + ((MappingPartition)this.partition).getPassRangeText() + " in " + typedModel + " for " + this.partition);
    }

    private void addProductionOfEdge(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull NavigableEdge edge) {
        TracePropertyPartitionAnalysis oppositeProducedTraceAnalysis;
        PropertyDatum oppositePropertyDatum;
        assert (this.isNew((Edge)edge));
        Property property = QVTscheduleUtil.getProperty((NavigableEdge)edge);
        assert (property != this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty());
        if (property.toString().contains("toA1") || property.toString().contains("ownsB")) {
            property.toString();
        }
        PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(edge);
        TracePropertyPartitionAnalysis producedTraceAnalysis = partitionedTransformationAnalysis.addProducer(propertyDatum, (PartitionAnalysis)this);
        List<@NonNull TracePropertyPartitionAnalysis> producedTracePropertyAnalyses2 = this.producedTracePropertyAnalyses;
        if (producedTracePropertyAnalyses2 == null) {
            this.producedTracePropertyAnalyses = producedTracePropertyAnalyses2 = new ArrayList<TracePropertyPartitionAnalysis>();
        }
        if (!producedTracePropertyAnalyses2.contains(producedTraceAnalysis)) {
            producedTracePropertyAnalyses2.add(producedTraceAnalysis);
        }
        if ((oppositePropertyDatum = propertyDatum.getOpposite()) != null && !producedTracePropertyAnalyses2.contains(oppositeProducedTraceAnalysis = partitionedTransformationAnalysis.addProducer(oppositePropertyDatum, (PartitionAnalysis)this))) {
            producedTracePropertyAnalyses2.add(oppositeProducedTraceAnalysis);
        }
    }

    private void addProductionOfMiddleEdge(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull NavigableEdge edge) {
        if (this.isRealized((Edge)edge) && !this.realizedMiddleEdges.contains(edge)) {
            this.realizedMiddleEdges.add(edge);
            this.addProductionOfEdge(partitionedTransformationAnalysis, edge);
        }
    }

    private void addProductionOfMiddleNode(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Node node) {
        if (this.isRealized(node) && !this.realizedMiddleNodes.contains(node)) {
            this.realizedMiddleNodes.add(node);
            this.addProductionOfNode(partitionedTransformationAnalysis, node);
        }
    }

    private void addProductionOfNode(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Node node) {
        assert (this.isNew(node));
        TraceClassPartitionAnalysis consumedTraceAnalysis = partitionedTransformationAnalysis.addProducer(QVTscheduleUtil.getClassDatum((Node)node), (PartitionAnalysis)this);
        List<@NonNull TraceClassPartitionAnalysis> producedTraceClassAnalyses2 = this.producedTraceClassAnalyses;
        if (producedTraceClassAnalyses2 == null) {
            this.producedTraceClassAnalyses = producedTraceClassAnalyses2 = new ArrayList<TraceClassPartitionAnalysis>();
        }
        if (!producedTraceClassAnalyses2.contains(consumedTraceAnalysis)) {
            producedTraceClassAnalyses2.add(consumedTraceAnalysis);
        }
    }

    private void addProductionOfOutputEdge(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull NavigableEdge edge) {
        if (this.isRealized((Edge)edge) && !this.realizedOutputEdges.contains(edge)) {
            this.realizedOutputEdges.add(edge);
            this.addProductionOfEdge(partitionedTransformationAnalysis, edge);
        }
    }

    private void addProductionOfOutputNode(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Node node) {
        if (this.isRealized(node) && !this.realizedOutputNodes.contains(node)) {
            this.realizedOutputNodes.add(node);
            this.addProductionOfNode(partitionedTransformationAnalysis, node);
        }
    }

    private void analyzeEdges(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        for (Edge edge : ((MappingPartition)this.partition).getPartialEdges()) {
            if (edge.isSecondary()) continue;
            if (this.isPredicated(edge)) {
                this.predicatedEdges.add(edge);
            }
            if (edge instanceof NavigableEdge) {
                Node sourceNode;
                NavigableEdge navigableEdge = (NavigableEdge)edge;
                if (navigableEdge.isSuccess()) {
                    this.successEdges.add((SuccessEdge)navigableEdge);
                }
                if (this.isRealized((Edge)navigableEdge)) {
                    this.realizedEdges.add(navigableEdge);
                } else {
                    this.oldPrimaryNavigableEdges.add(navigableEdge);
                }
                if (!this.isRealized((Edge)navigableEdge) && navigableEdge.isMatched() && !navigableEdge.isCast()) {
                    assert (!navigableEdge.isExpression());
                    assert (!navigableEdge.isComputation());
                }
                if (this.scheduleManager.isMiddle(sourceNode = navigableEdge.getEdgeSource())) {
                    if (this.isChecked((Edge)navigableEdge)) {
                        this.addConsumptionOfMiddleEdge(partitionedTransformationAnalysis, navigableEdge);
                        continue;
                    }
                    if (this.isRealized((Edge)navigableEdge)) {
                        this.addProductionOfMiddleEdge(partitionedTransformationAnalysis, navigableEdge);
                        continue;
                    }
                    throw new IllegalStateException("middle edge must be predicated or realized : " + navigableEdge);
                }
                if (this.isLoaded((Edge)navigableEdge) || this.isConstant((Edge)navigableEdge)) continue;
                if (this.isChecked((Edge)navigableEdge)) {
                    if (navigableEdge.isCast()) continue;
                    this.addConsumptionOfOutputEdge(partitionedTransformationAnalysis, navigableEdge);
                    continue;
                }
                if (this.isRealized((Edge)navigableEdge)) {
                    this.addProductionOfOutputEdge(partitionedTransformationAnalysis, navigableEdge);
                    continue;
                }
                throw new IllegalStateException("other edge must be predicated or realized : " + navigableEdge);
            }
            if (edge.isExpression() || edge instanceof IteratedEdge || edge.isDependency()) continue;
            throw new IllegalStateException("unsupported analyzeEdge : " + edge);
        }
    }

    private void analyzeNodes(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        String name = this.getName();
        if ("mapBooleanExp_qvtr".equals(name)) {
            this.getClass();
        }
        for (Node node : ((MappingPartition)this.partition).getPartialNodes()) {
            if (node.isNullLiteral()) {
                this.addConstantNode(node);
                continue;
            }
            if (node.isOperation()) {
                if (this.isConstant(node)) {
                    this.addConstantNode(node);
                    continue;
                }
                this.isRealized(node);
                continue;
            }
            if (node.isPattern()) {
                if (this.isConstant(node)) continue;
                if (this.isLoaded(node)) {
                    this.addConsumptionOfInputNode(partitionedTransformationAnalysis, node);
                    continue;
                }
                if (this.scheduleManager.isMiddle(node)) {
                    if (node.isDispatch()) {
                        if (this.dispatchNode != null) {
                            throw new IllegalStateException();
                        }
                        this.dispatchNode = node;
                    } else if (node.isTrace()) {
                        this.traceNodes.add(node);
                    }
                    if (this.isPredicated(node)) {
                        this.addConsumptionOfMiddleNode(partitionedTransformationAnalysis, node);
                        continue;
                    }
                    if (this.isSpeculated(node)) {
                        if (node.isHead()) continue;
                        this.addConsumptionOfMiddleNode(partitionedTransformationAnalysis, node);
                        continue;
                    }
                    if (this.isSpeculation(node)) {
                        this.addProductionOfMiddleNode(partitionedTransformationAnalysis, node);
                        continue;
                    }
                    if (this.isRealized(node)) {
                        this.addProductionOfMiddleNode(partitionedTransformationAnalysis, node);
                        continue;
                    }
                    throw new IllegalStateException("middle node must be predicated or realized : " + node);
                }
                if (this.isPredicated(node)) {
                    this.addConsumptionOfOutputNode(partitionedTransformationAnalysis, node);
                    continue;
                }
                if (this.isRealized(node)) {
                    this.addProductionOfOutputNode(partitionedTransformationAnalysis, node);
                    continue;
                }
                throw new IllegalStateException("other node must be predicated or realized : " + node);
            }
            if (node.isDependency()) {
                this.addConsumptionOfOutputNode(partitionedTransformationAnalysis, node);
                continue;
            }
            if (node.isIterator()) continue;
            throw new IllegalStateException("unsupported analyzeNode : " + node);
        }
    }

    @Override
    public void analyzePartition() {
        this.analyzeNodes(this.partitionedTransformationAnalysis);
        this.analyzeEdges(this.partitionedTransformationAnalysis);
    }

    @Override
    public void analyzePartitionEdges() {
        for (Edge edge : ((MappingPartition)this.partition).getPartialEdges()) {
            if (!edge.isNavigation()) continue;
            NavigationEdge navigationEdge = (NavigationEdge)edge;
            Node sourceNode = navigationEdge.getEdgeSource();
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)sourceNode);
            TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
            if (this.isPredicated(edge)) {
                assert (!navigationEdge.isCast());
                this.partitionedTransformationAnalysis.addCheckedEdge(typedModel, navigationEdge);
                continue;
            }
            if (!this.isRealized(edge)) continue;
            this.partitionedTransformationAnalysis.addRealizedEdge(typedModel, navigationEdge);
        }
        ((MappingPartition)this.partition).initTypedModelAnalysis();
    }

    public @Nullable Node basicGetDispatchNode() {
        return this.dispatchNode;
    }

    @Override
    public void computeCheckedOrEnforcedEdges() {
        boolean doDebug = QVTscheduleConstants.POLLED_PROPERTIES.isActive();
        if (doDebug) {
            QVTscheduleConstants.POLLED_PROPERTIES.println("analyzing " + this + " (" + ((MappingPartition)this.partition).getPassRangeText() + ")");
        }
        ConnectionManager connectionManager = this.scheduleManager.getConnectionManager();
        for (Edge edge : ((MappingPartition)this.partition).getPartialEdges()) {
            EdgeConnection edgeConnection;
            if (!edge.isNavigation() || !this.isChecked(edge)) continue;
            NavigationEdge checkedEdge = (NavigationEdge)edge;
            assert (!checkedEdge.isCast());
            Property property = checkedEdge.getProperty();
            if (doDebug) {
                QVTscheduleConstants.POLLED_PROPERTIES.println("  analyzing " + checkedEdge.getEdgeSource().getName() + "::" + property.getName() + " : " + checkedEdge.getEdgeSource().getCompleteClass());
            }
            if ((edgeConnection = checkedEdge.getIncomingConnection()) != null) {
                boolean isChecked = false;
                for (Partition usedPartition : edgeConnection.getSourcePartitions()) {
                    if (usedPartition.getLastPass() < ((MappingPartition)this.partition).getFirstPass()) continue;
                    this.addCheckedEdge((NavigableEdge)checkedEdge);
                    isChecked = true;
                }
                if (isChecked) {
                    for (NavigableEdge usedEdge : QVTscheduleUtil.getSourceEnds((EdgeConnection)edgeConnection)) {
                        Region sourceRegion = QVTscheduleUtil.getOwningRegion((ConnectionEnd)usedEdge);
                        RegionAnalysis sourceRegionAnalysis = this.scheduleManager.getRegionAnalysis(sourceRegion);
                        for (PartitionAnalysis sourcePartitionAnalysis : sourceRegionAnalysis.getPartitionAnalyses()) {
                            Role sourceRole = sourcePartitionAnalysis.getPartition().getRole((Edge)usedEdge);
                            if (sourceRole == null || sourceRole.isChecked()) continue;
                            sourcePartitionAnalysis.addEnforcedEdge(usedEdge);
                        }
                    }
                }
            }
            Node laterNode = checkedEdge.getEdgeSource();
            Node predicatedSourceNode = checkedEdge.getEdgeSource();
            Node predicatedTargetNode = checkedEdge.getEdgeTarget();
            NodeConnection usedConnection = connectionManager.getIncomingUsedConnection(predicatedTargetNode);
            if (usedConnection == null) continue;
            for (Partition usedPartition : usedConnection.getSourcePartitions()) {
                AbstractPartitionAnalysis<?> usedPartitionAnalysis;
                CompleteClass realizedTargetType;
                CompleteClass realizedSourceType;
                Node realizedTargetNode;
                Node realizedSourceNode;
                if (usedPartition.getLastPass() < ((MappingPartition)this.partition).getFirstPass()) continue;
                CompleteClass predicatedSourceType = predicatedSourceNode.getCompleteClass();
                CompleteClass predicatedTargetType = predicatedTargetNode.getCompleteClass();
                ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)laterNode);
                TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
                Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> property2realizedEdges = this.partitionedTransformationAnalysis.getProperty2RealizedEdges(typedModel);
                assert (property2realizedEdges != null);
                Property oclContainerProperty = this.scheduleManager.getStandardLibraryHelper().getOclContainerProperty();
                if (property == oclContainerProperty) {
                    for (Property candidateProperty : property2realizedEdges.keySet()) {
                        if (!candidateProperty.isIsComposite()) continue;
                        List<@NonNull NavigableEdge> realizedEdges = property2realizedEdges.get(candidateProperty);
                        assert (realizedEdges != null);
                        for (NavigableEdge realizedEdge : realizedEdges) {
                            realizedSourceNode = realizedEdge.getEdgeSource();
                            realizedTargetNode = realizedEdge.getEdgeTarget();
                            realizedSourceType = realizedSourceNode.getCompleteClass();
                            realizedTargetType = realizedTargetNode.getCompleteClass();
                            if (realizedSourceType.conformsTo(predicatedSourceType) && realizedTargetType.conformsTo(predicatedTargetType)) assert (((MappingPartition)this.partition).getLastPass() >= usedPartition.getFirstPass());
                            assert (((MappingPartition)this.partition).getLastPass() >= usedPartition.getFirstPass());
                            this.addCheckedEdge((NavigableEdge)checkedEdge);
                            usedPartitionAnalysis = this.partitionedTransformationAnalysis.getPartitionAnalysis(usedPartition);
                            usedPartitionAnalysis.addEnforcedEdge(realizedEdge);
                        }
                    }
                    continue;
                }
                assert (property2realizedEdges != null) : "No realized typed model for " + typedModel;
                List<@NonNull NavigableEdge> realizedEdges = property2realizedEdges.get(property);
                if (realizedEdges == null) {
                    System.err.println("No realized edges for " + typedModel + "!" + property + " in " + this);
                    continue;
                }
                for (NavigableEdge realizedEdge : realizedEdges) {
                    String enforceIsHazardFreeBecause;
                    String checkIsHazardFreeBecause;
                    realizedSourceNode = realizedEdge.getEdgeSource();
                    realizedTargetNode = realizedEdge.getEdgeTarget();
                    realizedSourceType = realizedSourceNode.getCompleteClass();
                    realizedTargetType = realizedTargetNode.getCompleteClass();
                    if (!realizedSourceType.conformsTo(predicatedSourceType)) {
                        checkIsHazardFreeBecause = "incompatible-source";
                        enforceIsHazardFreeBecause = "incompatible-source";
                    } else if (!QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)realizedTargetType, (CompleteClass)predicatedTargetType)) {
                        checkIsHazardFreeBecause = "incompatible-target";
                        enforceIsHazardFreeBecause = "incompatible-target";
                    } else if (usedPartition.getLastPass() < ((MappingPartition)this.partition).getFirstPass()) {
                        checkIsHazardFreeBecause = "later";
                        enforceIsHazardFreeBecause = null;
                    } else {
                        checkIsHazardFreeBecause = null;
                        enforceIsHazardFreeBecause = null;
                    }
                    if (checkIsHazardFreeBecause == null) {
                        this.addCheckedEdge((NavigableEdge)checkedEdge);
                    } else if (doDebug) {
                        QVTscheduleConstants.POLLED_PROPERTIES.println("    ignored check for " + this + "::" + laterNode.getName() + "(" + ((MappingPartition)this.partition).getPassRangeText() + ")" + " " + checkIsHazardFreeBecause + " (" + usedPartition.getPassRangeText() + ")" + usedPartition + "::" + realizedEdge.getEdgeSource().getName());
                    }
                    if (enforceIsHazardFreeBecause == null) {
                        usedPartitionAnalysis = this.partitionedTransformationAnalysis.getPartitionAnalysis(usedPartition);
                        usedPartitionAnalysis.addEnforcedEdge(realizedEdge);
                        continue;
                    }
                    if (!doDebug) continue;
                    QVTscheduleConstants.POLLED_PROPERTIES.println("    ignored enforce " + this + "::" + laterNode.getName() + "(" + ((MappingPartition)this.partition).getPassRangeText() + ")" + " " + enforceIsHazardFreeBecause + " (" + usedPartition.getPassRangeText() + ")" + usedPartition + "::" + realizedEdge.getEdgeSource().getName());
                }
            }
        }
    }

    public @NonNull Iterable<@NonNull Node> getConstantInputNodes() {
        return this.constantInputNodes;
    }

    public @NonNull Iterable<@NonNull Node> getConstantOutputNodes() {
        return this.constantOutputNodes;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getConsumedTraceClassAnalyses() {
        return this.consumedTraceClassAnalyses;
    }

    @Override
    public @Nullable Iterable<@NonNull TracePropertyPartitionAnalysis> getConsumedTracePropertyAnalyses() {
        return this.consumedTracePropertyAnalyses;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getOldPrimaryNavigableEdges() {
        return this.oldPrimaryNavigableEdges;
    }

    public @NonNull Iterable<@NonNull Edge> getPredicatedEdges() {
        return this.predicatedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedMiddleNodes() {
        return this.predicatedMiddleNodes;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedOutputNodes() {
        return this.predicatedOutputNodes;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getProducedTraceClassAnalyses() {
        return this.producedTraceClassAnalyses;
    }

    @Override
    public @Nullable Iterable<@NonNull TracePropertyPartitionAnalysis> getProducedTracePropertyAnalyses() {
        return this.producedTracePropertyAnalyses;
    }

    public abstract @NonNull ReachabilityForest getReachabilityForest();

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedEdges() {
        return this.realizedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedMiddleNodes() {
        return this.realizedMiddleNodes;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedOutputEdges() {
        return this.realizedOutputEdges;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedOutputNodes() {
        return this.realizedOutputNodes;
    }

    public @NonNull Iterable<@NonNull SuccessEdge> getSuccessEdges() {
        return this.successEdges;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getSuperProducedTraceClassAnalyses() {
        List<@NonNull TraceClassPartitionAnalysis> producedTraceClassAnalyses2 = this.producedTraceClassAnalyses;
        if (producedTraceClassAnalyses2 != null) {
            Set<@NonNull TraceClassPartitionAnalysis> superProducedTraceClassAnalyses2 = this.superProducedTraceClassAnalyses;
            if (superProducedTraceClassAnalyses2 == null) {
                this.superProducedTraceClassAnalyses = superProducedTraceClassAnalyses2 = new HashSet<TraceClassPartitionAnalysis>();
            }
            for (TraceClassPartitionAnalysis producedTraceClassAnalysis : producedTraceClassAnalyses2) {
                Iterables.addAll(superProducedTraceClassAnalyses2, producedTraceClassAnalysis.getSuperTraceClassAnalyses());
            }
        }
        return this.superProducedTraceClassAnalyses;
    }

    @Override
    public @NonNull List<@NonNull Node> getTraceNodes() {
        return this.traceNodes;
    }

    protected boolean isConstant(@NonNull Edge edge) {
        Role role = ((MappingPartition)this.partition).getRole(edge);
        assert (role != null);
        return role.isConstant();
    }

    protected boolean isConstant(@NonNull Node node) {
        Role role = ((MappingPartition)this.partition).getRole(node);
        assert (role != null);
        return role.isConstant();
    }

    protected boolean isLoaded(@NonNull Edge edge) {
        Role role = ((MappingPartition)this.partition).getRole(edge);
        assert (role != null);
        return role.isLoaded();
    }

    protected boolean isLoaded(@NonNull Node node) {
        Role role = ((MappingPartition)this.partition).getRole(node);
        assert (role != null);
        return role.isLoaded();
    }

    protected boolean isNew(@NonNull Edge edge) {
        Role role = ((MappingPartition)this.partition).getRole(edge);
        assert (role != null);
        return role.isNew();
    }

    protected boolean isNew(@NonNull Node node) {
        Role role = ((MappingPartition)this.partition).getRole(node);
        assert (role != null);
        return role.isNew();
    }

    protected boolean isOld(@NonNull Edge edge) {
        Role role = ((MappingPartition)this.partition).getRole(edge);
        assert (role != null);
        return role.isOld();
    }

    protected boolean isPredicated(@NonNull Edge edge) {
        Role role = ((MappingPartition)this.partition).getRole(edge);
        assert (role != null);
        return role.isPredicated();
    }

    protected boolean isPredicated(@NonNull Node node) {
        Role role = ((MappingPartition)this.partition).getRole(node);
        assert (role != null);
        return role.isPredicated();
    }

    protected boolean isRealized(@NonNull Edge edge) {
        Role role = ((MappingPartition)this.partition).getRole(edge);
        assert (role != null);
        return role.isRealized();
    }

    protected boolean isRealized(@NonNull Node node) {
        Role role = ((MappingPartition)this.partition).getRole(node);
        assert (role != null);
        return role.isRealized();
    }

    protected boolean isSpeculated(@NonNull Edge edge) {
        Role role = ((MappingPartition)this.partition).getRole(edge);
        assert (role != null);
        return role.isSpeculated();
    }

    protected boolean isSpeculated(@NonNull Node node) {
        Role role = ((MappingPartition)this.partition).getRole(node);
        assert (role != null);
        return role.isSpeculated();
    }

    protected boolean isSpeculation(@NonNull Node node) {
        Role role = ((MappingPartition)this.partition).getRole(node);
        assert (role != null);
        return role.isSpeculation();
    }
}

