/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtrelation.utilities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.resource.ASSaver;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.util.AbstractQVTrelationASSaverNormalizeVisitor;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;

public class QVTrelationASSaverNormalizeVisitor
extends AbstractQVTrelationASSaverNormalizeVisitor {
    public QVTrelationASSaverNormalizeVisitor(@NonNull ASSaver context) {
        super(context);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @Nullable Object visitDomainPattern(@NonNull DomainPattern object) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull NameUtil.NameableComparator nameableComparator = NameUtil.NAMEABLE_COMPARATOR;
        ClassUtil.sort(QVTrelationUtil.Internal.getBindsToList(object), (Comparator)nameableComparator);
        return null;
    }

    @Override
    public @Nullable Object visitRelation(@NonNull Relation object) {
        EList asOverrides;
        List asPredicates;
        Pattern asWhere;
        List asPredicates2;
        Pattern asWhen;
        List<@NonNull Variable> ownedVariablesList = QVTrelationUtil.Internal.getOwnedVariablesList(object);
        if (ownedVariablesList.size() > 1) {
            ClassUtil.sort(ownedVariablesList, (Comparator)new VariablesComparator(ownedVariablesList));
            int iNext = 1;
            for (Variable asVariable : ownedVariablesList) {
                if (!asVariable.isIsImplicit() || "$trace$".equals(asVariable.getName())) continue;
                asVariable.setName("_" + iNext++);
            }
        }
        if ((asWhen = object.getWhen()) != null && (asPredicates2 = QVTrelationUtil.Internal.getPredicatesList((Pattern)asWhen)).size() > 1) {
            ClassUtil.sort((List)asPredicates2, PredicateComparator.INSTANCE);
        }
        if ((asWhere = object.getWhere()) != null && (asPredicates = QVTrelationUtil.Internal.getPredicatesList((Pattern)asWhere)).size() > 1) {
            ClassUtil.sort((List)asPredicates, PredicateComparator.INSTANCE);
        }
        if ((asOverrides = object.getOverrides()).size() > 1) {
            ClassUtil.sort((List)asOverrides, (Comparator)NameUtil.NAMEABLE_COMPARATOR);
        }
        return null;
    }

    @Override
    public @Nullable Object visitRelationDomain(@NonNull RelationDomain object) {
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @Nullable Object visitRelationalTransformation(@NonNull RelationalTransformation object) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull NameUtil.NameableComparator nonNullNameableComparator = NameUtil.NAMEABLE_COMPARATOR;
        ClassUtil.sort(QVTrelationUtil.Internal.getOwnedRelationsList(object), (Comparator)nonNullNameableComparator);
        return super.visitRelationalTransformation(object);
    }

    protected static final class PredicateComparator
    implements Comparator<Predicate> {
        public static final @NonNull Comparator<@NonNull Predicate> INSTANCE = new PredicateComparator();

        protected PredicateComparator() {
        }

        @Override
        public int compare(@NonNull Predicate o1, @NonNull Predicate o2) {
            String n1 = o1.toString();
            String n2 = o2.toString();
            return n1.compareTo(n2);
        }
    }

    protected static final class RelationDomainComparator
    implements Comparator<Domain> {
        public static final @NonNull Comparator<@NonNull Domain> INSTANCE = new RelationDomainComparator();

        protected RelationDomainComparator() {
        }

        @Override
        public int compare(@NonNull Domain o1, @NonNull Domain o2) {
            TypedModel tm1 = o1.getTypedModel();
            TypedModel tm2 = o2.getTypedModel();
            if (tm1 == null) {
                if (tm2 == null) {
                    return System.identityHashCode(o1) - System.identityHashCode(o2);
                }
                return -1;
            }
            if (tm2 == null) {
                return 1;
            }
            String n1 = PivotUtil.getName((NamedElement)tm1);
            String n2 = PivotUtil.getName((NamedElement)tm2);
            return n1.compareTo(n2);
        }
    }

    protected static final class VariablesComparator
    implements Comparator<Variable> {
        private final @NonNull Map<@NonNull Variable, @NonNull Integer> variable2depth = new HashMap<Variable, Integer>();

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public VariablesComparator(@NonNull Iterable<@NonNull Variable> asVariables) {
            Set<VariableDeclaration> asReferences;
            HashMap<@NonNull Variable, @NonNull HashSet<@NonNull E>> variableDefinition2variableReferences = new HashMap();
            for (Variable asVariable : asVariables) {
                OCLExpression asExpression = asVariable.getOwnedInit();
                if (asExpression == null) continue;
                asReferences = new HashSet();
                variableDefinition2variableReferences.put(asVariable, asReferences);
                for (EObject eObject : new TreeIterable((EObject)asExpression, true)) {
                    if (!(eObject instanceof VariableExp)) continue;
                    asReferences.add(PivotUtil.getReferredVariable((VariableExp)((VariableExp)eObject)));
                }
            }
            boolean tryAgain = true;
            while (tryAgain) {
                tryAgain = false;
                for (Variable asVariableDefinition : variableDefinition2variableReferences.keySet()) {
                    asReferences = (Set)variableDefinition2variableReferences.get(asVariableDefinition);
                    assert (asReferences != null);
                    for (VariableDeclaration asVariableReference : new ArrayList(asReferences)) {
                        @NonNull Set asNestedReferences = (Set)variableDefinition2variableReferences.get(asVariableReference);
                        if (asNestedReferences == null || !asReferences.addAll(asNestedReferences)) continue;
                        tryAgain = true;
                    }
                }
            }
            HashSet<@NonNull K> residualVariables = new HashSet(variableDefinition2variableReferences.keySet());
            int depth = 1;
            while (!residualVariables.isEmpty()) {
                ArrayList<@NonNull Variable> thisDepth = new ArrayList<Variable>();
                for (Variable asVariableDefinition : residualVariables) {
                    @NonNull Set asReferences2 = (Set)variableDefinition2variableReferences.get(asVariableDefinition);
                    assert (asReferences2 != null);
                    boolean noReferences = true;
                    for (VariableDeclaration asVariableReference : asReferences2) {
                        if (!residualVariables.contains(asVariableReference)) continue;
                        noReferences = false;
                        break;
                    }
                    if (!noReferences) continue;
                    thisDepth.add(asVariableDefinition);
                    this.variable2depth.put(asVariableDefinition, depth);
                }
                if (thisDepth.isEmpty()) break;
                residualVariables.removeAll(thisDepth);
                ++depth;
            }
        }

        @Override
        public int compare(@NonNull Variable o1, @NonNull Variable o2) {
            if (o1.isIsImplicit()) {
                if (o2.isIsImplicit()) {
                    String n1 = o1.getType().toString();
                    String n2 = o2.getType().toString();
                    return n1.compareTo(n2);
                }
                return 1;
            }
            if (o2.isIsImplicit()) {
                return -1;
            }
            Integer d1 = this.variable2depth.get(o1);
            Integer d2 = this.variable2depth.get(o2);
            if (d1 == null) {
                d1 = 0;
            }
            if (d2 == null) {
                d2 = 0;
            }
            if (d1 != d2) {
                return d1 - d2;
            }
            String n1 = PivotUtil.getName((NamedElement)o1);
            String n2 = PivotUtil.getName((NamedElement)o2);
            return n1.compareTo(n2);
        }
    }
}

