/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr.ex.rt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.conversion.impl.AbstractIDValueConverter;
import org.eclipse.xtext.conversion.impl.IgnoreCaseIDValueConverter;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.parser.antlr.AntlrGrammarGenUtil;
import org.eclipse.xtext.generator.parser.antlr.ex.common.AbstractAntlrGeneratorFragmentEx;
import org.eclipse.xtext.generator.parser.antlr.ex.common.KeywordHelper;
import org.eclipse.xtext.generator.parser.antlr.ex.common.MutableTokenDefProvider;
import org.eclipse.xtext.parser.ITokenToStringConverter;
import org.eclipse.xtext.parser.antlr.AntlrTokenDefProvider;
import org.eclipse.xtext.parser.antlr.AntlrTokenToStringConverter;
import org.eclipse.xtext.parser.antlr.IAntlrParser;
import org.eclipse.xtext.parser.antlr.IAntlrTokenFileProvider;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.parser.antlr.UnorderedGroupHelper;
import org.eclipse.xtext.parsetree.reconstr.ITokenSerializer;
import org.eclipse.xtext.parsetree.reconstr.impl.IgnoreCaseKeywordSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrGeneratorFragment
extends AbstractAntlrGeneratorFragmentEx {
    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        String lexerBaseFileName;
        KeywordHelper helper = new KeywordHelper(grammar, this.getOptions().isIgnoreCase());
        super.generate(grammar, ctx);
        String srcGenPath = ctx.getOutput().getOutlet("SRC_GEN").getPath();
        String libPath = lexerBaseFileName = String.valueOf(srcGenPath) + "/" + this.getFragmentHelper().getLexerGrammarFileName(grammar).replace('.', '/');
        libPath = libPath.substring(0, libPath.lastIndexOf(47));
        String absoluteLexerFileName = String.valueOf(lexerBaseFileName) + ".g";
        String absoluteParserFileName = String.valueOf(srcGenPath) + "/" + this.getFragmentHelper().getParserGrammarFileName(grammar).replace('.', '/') + ".g";
        this.getAntlrTool().runWithParams(absoluteLexerFileName, this.getAntlrParams());
        this.cleanupLexerTokensFile(lexerBaseFileName);
        this.addAntlrParam("-lib");
        this.addAntlrParam(libPath);
        this.getAntlrTool().runWithParams(absoluteParserFileName, this.getAntlrParams());
        this.simplifyUnorderedGroupPredicatesIfRequired(grammar, absoluteParserFileName);
        this.splitParserAndLexerIfEnabled(absoluteLexerFileName, absoluteParserFileName);
        this.suppressWarnings(absoluteLexerFileName, absoluteParserFileName);
        MutableTokenDefProvider provider = this.createLexerTokensProvider(lexerBaseFileName);
        for (Map.Entry entry : provider.getTokenDefMap().entrySet()) {
            String value = (String)entry.getValue();
            if (helper.isKeywordRule(value)) {
                String keywordAsAntlrString = AntlrGrammarGenUtil.toAntlrString(helper.getKeywordValue(value));
                entry.setValue("'" + keywordAsAntlrString + "'");
                continue;
            }
            if (!value.startsWith("'")) continue;
            value = AntlrGrammarGenUtil.toAntlrString(value);
            entry.setValue("'" + value + "'");
        }
        try {
            provider.writeTokenFile(new PrintWriter(new File(String.valueOf(srcGenPath) + "/" + this.getFragmentHelper().getParserGrammarFileName(grammar).replace('.', '/') + ".tokens")));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        helper.discardHelper(grammar);
    }

    protected MutableTokenDefProvider createLexerTokensProvider(final String lexerBaseFileName) {
        MutableTokenDefProvider provider = new MutableTokenDefProvider();
        provider.setAntlrTokenFileProvider(new IAntlrTokenFileProvider(){

            public InputStream getAntlrTokenFile() {
                try {
                    return new FileInputStream(String.valueOf(lexerBaseFileName) + ".tokens");
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return provider;
    }

    protected void cleanupLexerTokensFile(String lexerBaseFileName) {
        if (this.getOptions().isBacktrackLexer()) {
            MutableTokenDefProvider provider = this.createLexerTokensProvider(lexerBaseFileName);
            Iterator entries = provider.getTokenDefMap().entrySet().iterator();
            while (entries.hasNext()) {
                String value = (String)entries.next().getValue();
                if (value.startsWith("KEYWORD_") || value.startsWith("RULE_")) continue;
                entries.remove();
            }
            try {
                provider.writeTokenFile(new PrintWriter(new File(String.valueOf(lexerBaseFileName) + ".tokens")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        return new String[]{String.valueOf(this.getNaming().basePackageRuntime(grammar)) + ".parser.antlr", String.valueOf(this.getNaming().basePackageRuntime(grammar)) + ".parser.antlr.internal", String.valueOf(this.getNaming().basePackageRuntime(grammar)) + ".parser.antlr.lexer"};
    }

    @Override
    public String[] getRequiredBundlesRt(Grammar grammar) {
        return new String[]{"org.antlr.runtime"};
    }

    @Override
    public Set<Binding> getGuiceBindingsRt(Grammar grammar) {
        BindFactory factory = new BindFactory().addTypeToType(IAntlrParser.class.getName(), this.getFragmentHelper().getParserClassName(grammar)).addTypeToType(ITokenToStringConverter.class.getName(), AntlrTokenToStringConverter.class.getName()).addTypeToType(IAntlrTokenFileProvider.class.getName(), this.getFragmentHelper().getAntlrTokenFileProviderClassName(grammar)).addTypeToType(Lexer.class.getName(), this.getFragmentHelper().getLexerClassName(grammar)).addTypeToProviderInstance(this.getFragmentHelper().getLexerClassName(grammar), "org.eclipse.xtext.parser.antlr.LexerProvider.create(" + this.getFragmentHelper().getLexerClassName(grammar) + ".class)").addConfiguredBinding("RuntimeLexer", "binder.bind(" + Lexer.class.getName() + ".class)" + ".annotatedWith(com.google.inject.name.Names.named(" + "org.eclipse.xtext.parser.antlr.LexerBindings.RUNTIME" + ")).to(" + this.getFragmentHelper().getLexerClassName(grammar) + ".class)").addTypeToType(ITokenDefProvider.class.getName(), AntlrTokenDefProvider.class.getName());
        if (this.containsUnorderedGroup(grammar)) {
            factory = factory.addTypeToType(IUnorderedGroupHelper.class.getName(), UnorderedGroupHelper.class.getName());
        }
        if (this.getOptions().isIgnoreCase()) {
            factory = factory.addTypeToType(ITokenSerializer.IKeywordSerializer.class.getName(), IgnoreCaseKeywordSerializer.class.getName()).addTypeToType(AbstractIDValueConverter.class.getName(), IgnoreCaseIDValueConverter.class.getName());
        }
        return factory.getBindings();
    }

    @Override
    public Set<Binding> getGuiceBindingsUi(Grammar grammar) {
        return new BindFactory().addTypeToType("org.eclipse.jface.text.rules.ITokenScanner", "org.eclipse.xtext.ui.editor.syntaxcoloring.antlr.AntlrTokenScanner").addTypeToType("org.eclipse.xtext.ui.editor.contentassist.IProposalConflictHelper", "org.eclipse.xtext.ui.editor.contentassist.antlr.AntlrProposalConflictHelper").addTypeToType("org.eclipse.xtext.ui.editor.IDamagerRepairer", "org.eclipse.xtext.ui.editor.FastDamagerRepairer").addConfiguredBinding("HighlightingLexer", "binder.bind(" + Lexer.class.getName() + ".class)" + ".annotatedWith(com.google.inject.name.Names.named(" + "org.eclipse.xtext.ui.LexerUIBindings.HIGHLIGHTING" + ")).to(" + this.getFragmentHelper().getLexerClassName(grammar) + ".class)").addConfiguredBinding("HighlightingTokenDefProvider", "binder.bind(" + ITokenDefProvider.class.getName() + ".class)" + ".annotatedWith(com.google.inject.name.Names.named(" + "org.eclipse.xtext.ui.LexerUIBindings.HIGHLIGHTING" + ")).to(" + AntlrTokenDefProvider.class.getName() + ".class)").getBindings();
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.getOptions().isBacktrackLexer() && this.getOptions().isIgnoreCase()) {
            issues.addError("Backtracking lexer and ignorecase cannot be combined for now.");
        }
    }
}

