/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.containers;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.containers.AbstractStorage2UriMapperClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceProjectsStateHelper
extends AbstractStorage2UriMapperClient {
    private static final Logger log = Logger.getLogger(WorkspaceProjectsStateHelper.class);
    @Inject
    private IWorkspace workspace;

    public String initHandle(URI uri) {
        if (!uri.isPlatform()) {
            return null;
        }
        IFile file = this.getWorkspaceRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        return project.getName();
    }

    public Collection<URI> initContainedURIs(String containerHandle) {
        block5: {
            try {
                IProject project = this.getWorkspaceRoot().getProject(containerHandle);
                if (project != null && this.isAccessibleXtextProject(project)) {
                    final ArrayList uris = Lists.newArrayList();
                    try {
                        project.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (resource instanceof IStorage) {
                                    URI uri = WorkspaceProjectsStateHelper.this.getUri((IStorage)resource);
                                    if (uri != null) {
                                        uris.add(uri);
                                    }
                                    return false;
                                }
                                return true;
                            }
                        });
                        return uris;
                    }
                    catch (CoreException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Cannot init contained URIs for containerHandle '" + containerHandle + "'"), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    public List<String> initVisibleHandles(String handle) {
        block7: {
            try {
                IProject project = this.getWorkspaceRoot().getProject(handle);
                if (this.isAccessibleXtextProject(project)) {
                    try {
                        IProject[] referencedProjects = project.getReferencedProjects();
                        ArrayList result = Lists.newArrayListWithExpectedSize((int)referencedProjects.length);
                        result.add(handle);
                        IProject[] iProjectArray = referencedProjects;
                        int n = referencedProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject referencedProject = iProjectArray[n2];
                            if (this.isAccessibleXtextProject(referencedProject)) {
                                result.add(referencedProject.getName());
                            }
                            ++n2;
                        }
                        return result;
                    }
                    catch (CoreException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)("Cannot init visible handles for containerHandle '" + handle + "'"), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    protected boolean isAccessibleXtextProject(IProject p) {
        return p != null && XtextProjectHelper.hasNature(p);
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.workspace.getRoot();
    }

    public void setWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
    }
}

