/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.transformer;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ui.editor.outline.ContentOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IContentOutlineNodeFactory;
import org.eclipse.xtext.ui.editor.outline.transformer.AbstractSemanticModelTransformer;

public class DefaultSemanticModelTransformer
extends AbstractSemanticModelTransformer {
    private static final Logger logger = Logger.getLogger(DefaultSemanticModelTransformer.class);
    @Inject
    private IContentOutlineNodeFactory contentOutlineNodeFactory;

    public void setContentOutlineNodeFactory(IContentOutlineNodeFactory contentOutlineNodeFactory) {
        this.contentOutlineNodeFactory = contentOutlineNodeFactory;
    }

    public boolean consumeSemanticNode(EObject semanticModelObject) {
        if (semanticModelObject != null) {
            String name = semanticModelObject.eClass().getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Consume semantic node type [" + name + "]?"));
            }
            return true;
        }
        return false;
    }

    public boolean consumeSemanticChildNodes(EObject semanticModelObject) {
        if (semanticModelObject != null) {
            String name = semanticModelObject.eClass().getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Consume semantic children of node type [" + name + "]?"));
            }
            return true;
        }
        return false;
    }

    protected ContentOutlineNode newOutlineNode(EObject semanticModelObject, ContentOutlineNode outlineParentNode) {
        return this.contentOutlineNodeFactory.create(this.getResourceAccess(), semanticModelObject, outlineParentNode);
    }

    protected ContentOutlineNode createOutlineNode(EObject semanticModelObject, ContentOutlineNode outlineParentNode) {
        return this.newOutlineNode(semanticModelObject, outlineParentNode);
    }

    public IContentOutlineNodeFactory getContentOutlineNodeFactory() {
        return this.contentOutlineNodeFactory;
    }
}

