/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.util.ReflectionUtil;
import org.eclipse.xtext.xbase.lib.BigDecimalExtensions;
import org.eclipse.xtext.xbase.lib.BigIntegerExtensions;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ComparableExtensions;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import org.eclipse.xtext.xbase.lib.FunctionExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.ProcedureExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.scoping.featurecalls.AbstractStaticMethodsFeatureForTypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticImplicitMethodsFeatureForTypeProvider
extends AbstractStaticMethodsFeatureForTypeProvider {
    @Inject
    private Primitives primitives;
    @Inject
    private ExtensionClassNameProvider extensionClassProvider;

    @Override
    protected Map<JvmTypeReference, Collection<String>> getVisibleTypesContainingStaticMethods(Iterable<JvmTypeReference> hierarchy) {
        if (hierarchy == null) {
            return Collections.singletonMap(null, this.getLiteralClassNames());
        }
        Iterator<JvmTypeReference> iterator = hierarchy.iterator();
        if (!iterator.hasNext()) {
            return Collections.singletonMap(null, this.getLiteralClassNames());
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        while (iterator.hasNext()) {
            JvmTypeReference reference = iterator.next();
            if (reference.getType() != null) {
                JvmTypeReference wrapped = this.primitives.asWrapperTypeIfPrimitive(reference);
                String typeName = wrapped.getType().getQualifiedName('.');
                Collection<String> extensionTypes = this.getExtensionClassNames().get(typeName);
                if (extensionTypes == null) continue;
                result.put(reference, extensionTypes);
                continue;
            }
            if (!result.isEmpty() || iterator.hasNext()) continue;
            return Collections.singletonMap(null, this.getLiteralClassNames());
        }
        return result;
    }

    protected Collection<String> getLiteralClassNames() {
        return this.extensionClassProvider.getLiteralClassNames();
    }

    protected Map<String, Collection<String>> getExtensionClassNames() {
        return this.extensionClassProvider.getExtensionClassNames();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    public static class ExtensionClassNameProvider {
        private final Collection<String> literalClassNames = this.computeLiteralClassNames();
        private final Map<String, Collection<String>> extensionClassNames = this.computeExtensionClassNames();

        protected Map<String, Collection<String>> computeExtensionClassNames() {
            return this.denormalize(this.simpleComputeExtensionClasses());
        }

        protected Map<String, Collection<String>> denormalize(Multimap<Class<?>, Class<?>> classMapping) {
            LinkedHashMultimap result = LinkedHashMultimap.create();
            for (Map.Entry entry : classMapping.entries()) {
                Class key = (Class)entry.getKey();
                Class keyObjectType = ReflectionUtil.getObjectType((Class)key);
                Class value = (Class)entry.getValue();
                Method[] methodArray = value.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> paramType;
                    Class paramObjectType;
                    Method method = methodArray[n2];
                    if (Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length > 0 && keyObjectType.isAssignableFrom(paramObjectType = ReflectionUtil.getObjectType(paramType = method.getParameterTypes()[0]))) {
                        result.put((Object)paramObjectType.getCanonicalName(), (Object)value.getCanonicalName());
                    }
                    ++n2;
                }
            }
            return ImmutableMultimap.copyOf((Multimap)result).asMap();
        }

        protected Collection<String> getLiteralClassNames() {
            return this.literalClassNames;
        }

        protected Map<String, Collection<String>> getExtensionClassNames() {
            return this.extensionClassNames;
        }

        protected Collection<String> computeLiteralClassNames() {
            return Lists.newArrayList((Object[])new String[]{CollectionLiterals.class.getName(), InputOutput.class.getName()});
        }

        protected Multimap<Class<?>, Class<?>> simpleComputeExtensionClasses() {
            ArrayListMultimap result = ArrayListMultimap.create();
            result.put(Boolean.class, BooleanExtensions.class);
            result.put(String.class, StringExtensions.class);
            result.put(Integer.class, IntegerExtensions.class);
            result.put(Integer.TYPE, IntegerExtensions.class);
            result.put(Double.class, DoubleExtensions.class);
            result.put(Double.TYPE, DoubleExtensions.class);
            result.put(BigInteger.class, BigIntegerExtensions.class);
            result.put(BigDecimal.class, BigDecimalExtensions.class);
            result.put(Comparable.class, ComparableExtensions.class);
            result.put(Object.class, ObjectExtensions.class);
            result.put(List.class, ListExtensions.class);
            result.put(Collection.class, CollectionExtensions.class);
            result.put(Map.class, CollectionExtensions.class);
            result.put(Map.class, MapExtensions.class);
            result.put(Iterable.class, IterableExtensions.class);
            result.put(Iterator.class, IteratorExtensions.class);
            result.put(Functions.Function0.class, FunctionExtensions.class);
            result.put(Functions.Function1.class, FunctionExtensions.class);
            result.put(Functions.Function2.class, FunctionExtensions.class);
            result.put(Functions.Function3.class, FunctionExtensions.class);
            result.put(Functions.Function4.class, FunctionExtensions.class);
            result.put(Functions.Function5.class, FunctionExtensions.class);
            result.put(Functions.Function6.class, FunctionExtensions.class);
            result.put(Procedures.Procedure0.class, ProcedureExtensions.class);
            result.put(Procedures.Procedure1.class, ProcedureExtensions.class);
            result.put(Procedures.Procedure2.class, ProcedureExtensions.class);
            result.put(Procedures.Procedure3.class, ProcedureExtensions.class);
            result.put(Procedures.Procedure4.class, ProcedureExtensions.class);
            result.put(Procedures.Procedure5.class, ProcedureExtensions.class);
            result.put(Procedures.Procedure6.class, ProcedureExtensions.class);
            return result;
        }
    }
}

