/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.linking.impl.ImportedNamesAdapter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IResourceScopeCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceDescription
extends AbstractResourceDescription {
    private static final Logger log = Logger.getLogger(DefaultResourceDescription.class);
    private final Resource resource;
    private final URI uri;
    private IDefaultResourceDescriptionStrategy strategy;
    private IResourceScopeCache cache;
    private static final String REFERENCE_DESCRIPTIONS_CACHE_KEY = String.valueOf(DefaultReferenceDescription.class.getName()) + "#getReferenceDescriptions";
    private static final String EOBJECT_LOOKUP_CACHE_KEY = String.valueOf(DefaultReferenceDescription.class.getName()) + "#getLookUp";

    public DefaultResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy, IResourceScopeCache cache) {
        this.resource = resource;
        this.strategy = strategy;
        this.cache = cache;
        this.uri = this.getNormalizedURI(resource);
    }

    public DefaultResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        this(resource, strategy, (IResourceScopeCache)new IResourceScopeCache.NullImpl());
    }

    @Override
    protected List<IEObjectDescription> computeExportedObjects() {
        if (!this.getResource().isLoaded()) {
            try {
                this.getResource().load(null);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        final ArrayList exportedEObjects = Lists.newArrayList();
        IAcceptor<IEObjectDescription> acceptor = new IAcceptor<IEObjectDescription>(){

            public void accept(IEObjectDescription eObjectDescription) {
                exportedEObjects.add(eObjectDescription);
            }
        };
        TreeIterator allProperContents = EcoreUtil.getAllProperContents((Resource)this.getResource(), (boolean)false);
        while (allProperContents.hasNext()) {
            EObject content = (EObject)allProperContents.next();
            if (this.strategy.createEObjectDescriptions(content, acceptor)) continue;
            allProperContents.prune();
        }
        return exportedEObjects;
    }

    @Override
    public Iterable<QualifiedName> getImportedNames() {
        EcoreUtil2.resolveLazyCrossReferences(this.resource, CancelIndicator.NullImpl);
        ImportedNamesAdapter adapter = ImportedNamesAdapter.find(this.getResource());
        if (adapter != null) {
            ImmutableSet result = ImmutableSet.copyOf(adapter.getImportedNames());
            return result;
        }
        return Collections.emptySet();
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return (Iterable)this.cache.get((Object)REFERENCE_DESCRIPTIONS_CACHE_KEY, this.getResource(), (Provider)new Provider<List<IReferenceDescription>>(){

            public List<IReferenceDescription> get() {
                return DefaultResourceDescription.this.computeReferenceDescriptions();
            }
        });
    }

    protected List<IReferenceDescription> computeReferenceDescriptions() {
        final ArrayList referenceDescriptions = Lists.newArrayList();
        IAcceptor<IReferenceDescription> acceptor = new IAcceptor<IReferenceDescription>(){

            public void accept(IReferenceDescription referenceDescription) {
                referenceDescriptions.add(referenceDescription);
            }
        };
        EcoreUtil2.resolveLazyCrossReferences(this.resource, CancelIndicator.NullImpl);
        Map<EObject, IEObjectDescription> eObject2exportedEObjects = this.createEObject2ExportedEObjectsMap(this.getExportedObjects());
        TreeIterator contents = EcoreUtil.getAllProperContents((Resource)this.resource, (boolean)true);
        while (contents.hasNext()) {
            URI exportedContainerURI;
            EObject eObject = (EObject)contents.next();
            if (this.strategy.createReferenceDescriptions(eObject, exportedContainerURI = this.findExportedContainerURI(eObject, eObject2exportedEObjects), acceptor)) continue;
            contents.prune();
        }
        return referenceDescriptions;
    }

    protected Map<EObject, IEObjectDescription> createEObject2ExportedEObjectsMap(Iterable<IEObjectDescription> exportedObjects) {
        HashMap uri2exportedEObjects = Maps.newHashMap();
        for (IEObjectDescription eObjectDescription : exportedObjects) {
            uri2exportedEObjects.put(eObjectDescription.getEObjectOrProxy(), eObjectDescription);
        }
        return uri2exportedEObjects;
    }

    protected URI findExportedContainerURI(EObject referenceOwner, Map<EObject, IEObjectDescription> eObject2exportedEObjects) {
        EObject currentContainer = referenceOwner;
        while (currentContainer != null) {
            IEObjectDescription currentContainerEObjectDescription = eObject2exportedEObjects.get(currentContainer);
            if (currentContainerEObjectDescription != null) {
                return currentContainerEObjectDescription.getEObjectURI();
            }
            currentContainer = currentContainer.eContainer();
        }
        return null;
    }

    @Override
    protected EObjectDescriptionLookUp getLookUp() {
        return (EObjectDescriptionLookUp)this.cache.get((Object)EOBJECT_LOOKUP_CACHE_KEY, this.getResource(), (Provider)new Provider<EObjectDescriptionLookUp>(){

            public EObjectDescriptionLookUp get() {
                if (DefaultResourceDescription.this.lookup != null) {
                    DefaultResourceDescription.this.lookup.setExportedObjects(DefaultResourceDescription.this.computeExportedObjects());
                } else {
                    DefaultResourceDescription.this.lookup = new EObjectDescriptionLookUp(DefaultResourceDescription.this.computeExportedObjects());
                }
                return DefaultResourceDescription.this.lookup;
            }
        });
    }
}

