/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.IHiddenTokenSequencer;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenTokenSequencer
implements IHiddenTokenSequencer,
ISyntacticSequenceAcceptor {
    protected ISequenceAcceptor delegate;
    @Inject
    protected IHiddenTokenHelper hiddenTokenHelper;
    protected INode lastNode;
    protected INode rootNode;
    protected ISyntacticSequencer sequencer;
    @Inject
    protected TokenUtil tokenUtil;

    @Override
    public void acceptAssignedCrossRefDatatype(RuleCall rc, String tkn, EObject val, int index, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptAssignedCrossRefDatatype(rc, tkn, val, index, node);
    }

    @Override
    public void acceptAssignedCrossRefEnum(RuleCall rc, String token, EObject value, int index, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptAssignedCrossRefEnum(rc, token, value, index, node);
    }

    @Override
    public void acceptAssignedCrossRefTerminal(RuleCall rc, String token, EObject value, int index, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptAssignedCrossRefTerminal(rc, token, value, index, node);
    }

    @Override
    public void acceptAssignedDatatype(RuleCall rc, String token, Object value, int index, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptAssignedDatatype(rc, token, value, index, node);
    }

    @Override
    public void acceptAssignedEnum(RuleCall enumRC, String token, Object value, int index, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptAssignedEnum(enumRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedKeyword(Keyword keyword, String token, Boolean value, int index, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptAssignedKeyword(keyword, token, value, index, node);
    }

    @Override
    public void acceptAssignedKeyword(Keyword keyword, String token, String value, int index, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptAssignedKeyword(keyword, token, value, index, node);
    }

    @Override
    public void acceptAssignedTerminal(RuleCall terminalRC, String token, Object value, int index, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptAssignedTerminal(terminalRC, token, value, index, node);
    }

    @Override
    public void acceptUnassignedAction(Action action) {
        this.delegate.acceptUnassignedAction(action);
    }

    @Override
    public void acceptUnassignedDatatype(RuleCall datatypeRC, String token, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptUnassignedDatatype(datatypeRC, token, node);
    }

    @Override
    public void acceptUnassignedEnum(RuleCall enumRC, String token, ICompositeNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = this.getLastLeaf(node);
        this.delegate.acceptUnassignedEnum(enumRC, token, node);
    }

    @Override
    public void acceptUnassignedKeyword(Keyword keyword, String token, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptUnassignedKeyword(keyword, token, node);
    }

    @Override
    public void acceptUnassignedTerminal(RuleCall terminalRC, String token, ILeafNode node) {
        this.emitHiddenTokens(this.getHiddenNodesBetween(this.lastNode, node));
        this.lastNode = node;
        this.delegate.acceptUnassignedTerminal(terminalRC, token, node);
    }

    protected void emitHiddenTokens(List<INode> hiddens) {
        if (hiddens == null) {
            return;
        }
        boolean lastNonWhitespace = true;
        for (INode node : hiddens) {
            if (this.tokenUtil.isCommentNode(node)) {
                if (lastNonWhitespace) {
                    this.delegate.acceptWhitespace(this.hiddenTokenHelper.getWhitespaceRuleFor(null, ""), "", null);
                }
                lastNonWhitespace = true;
                this.delegate.acceptComment((AbstractRule)node.getGrammarElement(), node.getText(), (ILeafNode)node);
                continue;
            }
            this.delegate.acceptWhitespace((AbstractRule)node.getGrammarElement(), node.getText(), (ILeafNode)node);
            lastNonWhitespace = false;
        }
        if (lastNonWhitespace) {
            this.delegate.acceptWhitespace(this.hiddenTokenHelper.getWhitespaceRuleFor(null, ""), "", null);
        }
    }

    @Override
    public boolean enterAssignedAction(Action action, EObject semanticChild, ICompositeNode node) {
        return this.delegate.enterAssignedAction(action, semanticChild, node);
    }

    @Override
    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject semanticChild, ICompositeNode node) {
        return this.delegate.enterAssignedParserRuleCall(rc, semanticChild, node);
    }

    @Override
    public void enterUnassignedParserRuleCall(RuleCall rc) {
        this.delegate.enterUnassignedParserRuleCall(rc);
    }

    @Override
    public void finish() {
        List<INode> hidden;
        if (this.rootNode != null && this.rootNode == this.rootNode.getRootNode() && !(hidden = this.getRemainingHiddenNodesInContainer(this.lastNode, this.rootNode)).isEmpty()) {
            this.emitHiddenTokens(hidden);
            this.lastNode = this.rootNode;
        }
        this.delegate.finish();
    }

    protected Set<INode> getCommentsForEObject(EObject semanticObject, INode node) {
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        BidiTreeIterator<INode> ti = node.getAsTreeIterable().iterator();
        while (ti.hasNext()) {
            INode next = ti.next();
            if (next.getSemanticElement() != null && next.getSemanticElement() != semanticObject) {
                ti.prune();
                continue;
            }
            if (!this.tokenUtil.isCommentNode(next)) continue;
            result.add(next);
        }
        return result;
    }

    protected List<INode> getHiddenNodesBetween(INode from, INode to) {
        if (from == null || to == null) {
            return null;
        }
        ArrayList out = Lists.newArrayList();
        NodeIterator ni = new NodeIterator(from);
        while (ni.hasNext()) {
            INode next = ni.next();
            if (this.tokenUtil.isWhitespaceOrCommentNode(next)) {
                out.add(next);
                continue;
            }
            if (next.equals(to)) {
                if (next instanceof ICompositeNode && (GrammarUtil.isDatatypeRuleCall(next.getGrammarElement()) || GrammarUtil.isEnumRuleCall(next.getGrammarElement()) || next.getGrammarElement() instanceof CrossReference)) {
                    while (ni.hasNext()) {
                        INode next2 = ni.next();
                        if (this.tokenUtil.isWhitespaceOrCommentNode(next2)) {
                            out.add(next2);
                            continue;
                        }
                        if (!(next2 instanceof ILeafNode)) continue;
                        return out;
                    }
                    continue;
                }
                return out;
            }
            if (!this.tokenUtil.isToken(next)) continue;
            return null;
        }
        return out;
    }

    protected INode getLastLeaf(INode node) {
        while (node instanceof ICompositeNode) {
            node = ((ICompositeNode)node).getLastChild();
        }
        return node;
    }

    protected List<INode> getRemainingHiddenNodesInContainer(INode from, INode root) {
        if (from == null || root == null) {
            return Collections.emptyList();
        }
        ArrayList out = Lists.newArrayList();
        NodeIterator ni = new NodeIterator(from);
        while (ni.hasNext()) {
            INode next = ni.next();
            if (next.getTotalOffset() > root.getTotalEndOffset()) {
                return out;
            }
            if (this.tokenUtil.isWhitespaceOrCommentNode(next)) {
                out.add(next);
                continue;
            }
            if (!this.tokenUtil.isToken(next)) continue;
            return Collections.emptyList();
        }
        return out;
    }

    @Override
    public void init(EObject context, EObject semanticObject, ISequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
        this.delegate = sequenceAcceptor;
        this.rootNode = this.lastNode = NodeModelUtils.findActualNodeFor(semanticObject);
    }

    @Override
    public void leaveAssignedAction(Action action, EObject semanticChild) {
        this.delegate.leaveAssignedAction(action, semanticChild);
    }

    @Override
    public void leaveAssignedParserRuleCall(RuleCall rc, EObject semanticChild) {
        this.delegate.leaveAssignedParserRuleCall(rc, semanticChild);
    }

    @Override
    public void leaveUnssignedParserRuleCall(RuleCall rc) {
        this.delegate.leaveUnssignedParserRuleCall(rc);
    }
}

