/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler.batch;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.XtendInjectorSingleton;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.core.macro.TransformationContextImpl;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.compiler.CompilationTestHelper;
import org.eclipse.xtext.xbase.lib.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendCompilerTester {
    @Inject
    CompilationTestHelper compilationTestHelper;
    @Inject
    ProcessorInstanceForJvmTypeProvider instanceForJvmTypeProvider;
    @Inject
    Provider<CompilationUnitImpl> compilationUnitProvider;

    public static XtendCompilerTester newXtendCompilerTester(Class<?> ... classesOnClassPath) {
        XtendCompilerTester instance = (XtendCompilerTester)XtendInjectorSingleton.INJECTOR.getInstance(XtendCompilerTester.class);
        instance.setJavaCompilerClassPath(classesOnClassPath);
        ProcessorInstanceForJvmTypeProvider processorProvider = (ProcessorInstanceForJvmTypeProvider)XtendInjectorSingleton.INJECTOR.getInstance(ProcessorInstanceForJvmTypeProvider.class);
        processorProvider.setClassLoader(XtendCompilerTester.class.getClassLoader());
        return instance;
    }

    public void setJavaCompilerClassPath(Class<?>[] classesOnClassPath) {
        this.compilationTestHelper.setJavaCompilerClassPath((Class[])classesOnClassPath);
    }

    public void assertCompilesTo(CharSequence source, CharSequence expected) {
        try {
            this.compilationTestHelper.configureFreshWorkspace();
            this.compilationTestHelper.assertCompilesTo(source, expected);
        }
        catch (IOException e) {
            Exceptions.sneakyThrow((Throwable)e);
        }
    }

    public void compile(CharSequence source, final IAcceptor<CompilationResult> acceptor) {
        try {
            this.compilationTestHelper.configureFreshWorkspace();
            this.compilationTestHelper.compile(source, (IAcceptor)new IAcceptor<CompilationTestHelper.Result>(){

                public void accept(final CompilationTestHelper.Result t) {
                    acceptor.accept((Object)new CompilationResult(){
                        CompilationUnitImpl compilationUnitImpl;
                        {
                            this.compilationUnitImpl = (CompilationUnitImpl)(this).XtendCompilerTester.this.compilationUnitProvider.get();
                            XtendFile xtendFile = (XtendFile)((Resource)result.getResourceSet().getResources().get(0)).getContents().get(0);
                            this.compilationUnitImpl.setXtendFile(xtendFile);
                        }

                        @Override
                        public Map<String, String> getGeneratedCode() {
                            return t.getGeneratedCode();
                        }

                        @Override
                        public String getGeneratedCode(String typeName) {
                            return t.getGeneratedCode(typeName);
                        }

                        @Override
                        public String getSingleGeneratedCode() {
                            return t.getSingleGeneratedCode();
                        }

                        @Override
                        public Class<?> getCompiledClass() {
                            return t.getCompiledClass();
                        }

                        @Override
                        public Class<?> getCompiledClass(String className) {
                            return t.getCompiledClass(className);
                        }

                        @Override
                        public Map<String, CharSequence> getAllGeneratedResources() {
                            return t.getAllGeneratedResources();
                        }

                        @Override
                        public CompilationUnit getCompilationUnit() {
                            return this.compilationUnitImpl;
                        }

                        @Override
                        public TransformationContext getTransformationContext() {
                            TransformationContextImpl transformationContextImpl = new TransformationContextImpl();
                            transformationContextImpl.setUnit(this.compilationUnitImpl);
                            return transformationContextImpl;
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            Exceptions.sneakyThrow((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CompilationResult {
        public Map<String, String> getGeneratedCode();

        public String getGeneratedCode(String var1);

        public String getSingleGeneratedCode();

        public Class<?> getCompiledClass();

        public Class<?> getCompiledClass(String var1);

        public Map<String, CharSequence> getAllGeneratedResources();

        public CompilationUnit getCompilationUnit();

        public TransformationContext getTransformationContext();
    }
}

