/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.io.CharStreams;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public abstract class AbstractTraceRegionToString {
    private int radix = 10;
    private boolean showTree = true;
    private boolean showLegend = true;

    protected abstract String getRemoteText(SourceRelativeURI var1);

    protected abstract String getLocalText();

    protected abstract AbstractTraceRegion getTrace();

    protected ITextRegion getLocalFrame() {
        return null;
    }

    protected ITextRegion getRemoteFrame(SourceRelativeURI uri) {
        return null;
    }

    protected String getLocalTitle() {
        return "generated.java";
    }

    protected String getRemoteTitle(SourceRelativeURI uri) {
        return uri.getURI().toString();
    }

    protected boolean shouldInclude(AbstractTraceRegion region) {
        ITextRegion frame = this.getLocalFrame();
        if (frame == null) {
            return true;
        }
        return frame.contains((ITextRegion)region.getMyRegion());
    }

    protected boolean shouldInclude(AbstractTraceRegion region, ILocationData location) {
        SourceRelativeURI _associatedSrcRelativePath;
        SourceRelativeURI _elvis = null;
        SourceRelativeURI _srcRelativePath = location.getSrcRelativePath();
        _elvis = _srcRelativePath != null ? _srcRelativePath : (_associatedSrcRelativePath = region.getAssociatedSrcRelativePath());
        ITextRegion frame = this.getRemoteFrame(_elvis);
        if (frame == null) {
            return true;
        }
        return frame.contains((ITextRegion)location);
    }

    protected void add(Map<SourceRelativeURI, File> files, SourceRelativeURI uri, ITextRegion it, RegionHandle region, LocationHandle location) {
        File file = files.get(uri);
        if (file == null) {
            File _file;
            File _file_1 = file = (_file = new File(uri));
            files.put(uri, _file_1);
        }
        this.add(file, it, region, location);
    }

    protected void add(File file, ITextRegion it, RegionHandle region, LocationHandle location) {
        int _offset = it.getOffset();
        Insert _insert = new Insert(_offset, true, region, location);
        file.inserts.add(_insert);
        int _offset_1 = it.getOffset();
        int _length = it.getLength();
        int _plus = _offset_1 + _length;
        Insert _insert_1 = new Insert(_plus, false, region, location);
        file.inserts.add(_insert_1);
    }

    protected int collect(AbstractTraceRegion reg, int nextID, File lFile, Map<SourceRelativeURI, File> rFiles, List<RegionHandle> result) {
        int i = nextID;
        List childResult = result;
        boolean _shouldInclude = this.shouldInclude(reg);
        if (_shouldInclude) {
            int _plusPlus = i++;
            RegionHandle regHandle = new RegionHandle(_plusPlus, reg);
            result.add((RegionHandle)regHandle);
            childResult = regHandle.children;
            this.add(lFile, (ITextRegion)reg.getMyRegion(), regHandle, null);
            Functions.Function1 _function = it -> this.shouldInclude(reg, (ILocationData)it);
            List locs = IterableExtensions.toList((Iterable)IterableExtensions.filter(reg.getAssociatedLocations(), (Functions.Function1)_function));
            for (int j = 0; j < locs.size(); ++j) {
                SourceRelativeURI _associatedSrcRelativePath;
                ILocationData loc = (ILocationData)locs.get(j);
                int _xifexpression = 0;
                int _size = locs.size();
                boolean _greaterThan = _size > 1;
                _xifexpression = _greaterThan ? j + 1 : -1;
                LocationHandle locHandle = new LocationHandle(regHandle, _xifexpression, loc);
                regHandle.locations.add(locHandle);
                SourceRelativeURI _elvis = null;
                SourceRelativeURI _srcRelativePath = loc.getSrcRelativePath();
                _elvis = _srcRelativePath != null ? _srcRelativePath : (_associatedSrcRelativePath = reg.getAssociatedSrcRelativePath());
                SourceRelativeURI path = _elvis;
                this.add(rFiles, path, (ITextRegion)loc, regHandle, locHandle);
            }
        }
        List<AbstractTraceRegion> _nestedRegions = reg.getNestedRegions();
        for (AbstractTraceRegion child : _nestedRegions) {
            i = this.collect(child, i, lFile, rFiles, childResult);
        }
        return i;
    }

    protected String render(Insert it, int width) {
        String first = Strings.padStart((String)Integer.toString(it.region.id, this.radix), (int)width, (char)'0');
        String _xifexpression = null;
        if (it.location != null && it.location.id >= 0) {
            String _string = Integer.toString(it.location.id, this.radix);
            _xifexpression = first + "_" + _string;
        } else {
            _xifexpression = first;
        }
        return _xifexpression;
    }

    protected int sortKey(Insert it) {
        int base = it.region.id * Short.MAX_VALUE;
        int _xifexpression = 0;
        _xifexpression = it.location != null && it.location.id >= 0 ? base + it.location.id : base;
        return _xifexpression;
    }

    protected String render(Collection<Insert> inserts, int width) {
        Functions.Function1 _function = it -> ((Insert)it).open;
        Functions.Function1 _function_1 = it -> this.sortKey((Insert)it);
        Functions.Function1 _function_2 = it -> this.render((Insert)it, width);
        String opens = IterableExtensions.join((Iterable)ListExtensions.map((List)IterableExtensions.sortBy((Iterable)IterableExtensions.filter(inserts, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (CharSequence)",");
        Functions.Function1 _function_3 = it -> !((Insert)it).open;
        Functions.Function1 _function_4 = it -> {
            int _sortKey = this.sortKey((Insert)it);
            return -_sortKey;
        };
        Functions.Function1 _function_5 = it -> this.render((Insert)it, width);
        String closes = IterableExtensions.join((Iterable)ListExtensions.map((List)IterableExtensions.sortBy((Iterable)IterableExtensions.filter(inserts, (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5), (CharSequence)",");
        String _xifexpression = null;
        boolean _isEmpty = opens.isEmpty();
        _xifexpression = _isEmpty ? "" : "[" + opens + "[";
        String s1 = _xifexpression;
        String _xifexpression_1 = null;
        boolean _isEmpty_1 = closes.isEmpty();
        _xifexpression_1 = _isEmpty_1 ? "" : "]" + closes + "]";
        String s2 = _xifexpression_1;
        return s2 + s1;
    }

    protected List<String> render(File file, int width) {
        try {
            int _length_1;
            String _xifexpression = null;
            _xifexpression = file.uri == null ? this.getLocalText() : this.getRemoteText(file.uri);
            String text = _xifexpression;
            ITextRegion _elvis = null;
            ITextRegion _xifexpression_1 = null;
            _xifexpression_1 = file.uri == null ? this.getLocalFrame() : this.getRemoteFrame(file.uri);
            if (_xifexpression_1 != null) {
                _elvis = _xifexpression_1;
            } else {
                int _length = text.length();
                TextRegion _textRegion = new TextRegion(0, _length);
                _elvis = _textRegion;
            }
            ITextRegion frame = _elvis;
            Functions.Function1 _function = it -> ((Insert)it).offset >= frame.getOffset() && ((Insert)it).offset <= frame.getOffset() + frame.getLength();
            Iterable inframe = IterableExtensions.filter((Iterable)file.inserts, (Functions.Function1)_function);
            Function _function_1 = it -> ((Insert)it).offset;
            Functions.Function1 _function_2 = it -> (Integer)it.getKey();
            List offsets = IterableExtensions.sortBy((Iterable)IterableExtensions.toList((Iterable)Multimaps.index((Iterable)inframe, (Function)_function_1).asMap().entrySet()), (Functions.Function1)_function_2);
            int last = frame.getOffset();
            StringBuilder result = new StringBuilder();
            for (Map.Entry e : offsets) {
                Integer offset = (Integer)e.getKey();
                String insert = this.render((Collection)e.getValue(), width);
                String prefix = text.substring(last, offset);
                result.append(prefix);
                result.append(insert);
                last = offset;
            }
            int _offset = frame.getOffset();
            int end = _offset + (_length_1 = frame.getLength());
            if (last < end) {
                result.append(text.substring(last, end));
            }
            String _string = result.toString();
            StringReader _stringReader = new StringReader(_string);
            return CharStreams.readLines((Readable)_stringReader);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String title(SourceRelativeURI uri, int width) {
        String _xifexpression = null;
        _xifexpression = uri == null ? this.getLocalTitle() : this.getRemoteTitle(uri);
        String _plus = " " + _xifexpression;
        String s = _plus + " ";
        int _length = s.length();
        int _minus = width - _length;
        int _divide = _minus / 2;
        String left = Strings.repeat((String)"-", (int)_divide);
        int _length_1 = s.length();
        int _length_2 = left.length();
        int _plus_1 = _length_1 + _length_2;
        int _minus_1 = width - _plus_1;
        String right = Strings.repeat((String)"-", (int)_minus_1);
        return left + s + right;
    }

    protected <T> Set<T> collect(T start, Functions.Function1<? super T, ? extends Iterable<T>> reachable) {
        return this.collect(start, reachable, CollectionLiterals.newLinkedHashSet((Object[])new Object[0]));
    }

    protected <R extends Collection<? super T>, T> R collect(T start, Functions.Function1<? super T, ? extends Iterable<T>> reachable, R collector) {
        boolean _add = collector.add(start);
        if (_add) {
            Iterable _apply = (Iterable)reachable.apply(start);
            for (Object r : _apply) {
                this.collect(r, reachable, collector);
            }
        }
        return collector;
    }

    protected String render(LocationHandle loc) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        if (loc.id >= 0) {
            String _string = Integer.toString(loc.id, this.radix);
            _xifexpression = _string + ": ";
        } else {
            _xifexpression = "";
        }
        String prefix = _xifexpression;
        String name = loc.location.getClass().getSimpleName();
        String _xifexpression_1 = null;
        SourceRelativeURI _srcRelativePath = loc.location.getSrcRelativePath();
        boolean bl = _tripleNotEquals = _srcRelativePath != null;
        if (_tripleNotEquals) {
            SourceRelativeURI _srcRelativePath_1 = loc.location.getSrcRelativePath();
            _xifexpression_1 = "," + _srcRelativePath_1;
        } else {
            _xifexpression_1 = "";
        }
        String path = _xifexpression_1;
        int _offset = loc.location.getOffset();
        String _plus = prefix + name + "[" + Integer.valueOf(_offset);
        String _plus_1 = _plus + ",";
        int _length = loc.location.getLength();
        String _plus_2 = _plus_1 + Integer.valueOf(_length);
        String _plus_3 = _plus_2 + path;
        return _plus_3 + "]";
    }

    protected void render(RegionHandle region, int idW, int offsetW, int lengthW, int indent, List<String> result) {
        String id = Strings.padStart((String)Integer.toString(region.id, this.radix), (int)idW, (char)'0');
        String _xifexpression = null;
        boolean _isUseForDebugging = region.region.isUseForDebugging();
        _xifexpression = _isUseForDebugging ? "D" : " ";
        String debug = _xifexpression;
        String offset = Strings.padStart((String)Integer.toString(region.region.getMyOffset()), (int)offsetW, (char)'0');
        String length = Strings.padStart((String)Integer.toString(region.region.getMyLength()), (int)lengthW, (char)'0');
        String space = Strings.repeat((String)" ", (int)indent);
        String name = region.region.getClass().getSimpleName();
        Functions.Function1 _function = it -> this.render((LocationHandle)it);
        String locations = IterableExtensions.join((Iterable)ListExtensions.map((List)region.locations, (Functions.Function1)_function), (CharSequence)", ");
        String loc = debug + " " + offset + "-" + length + space;
        String header = id + ": " + loc + name + " -> " + locations;
        boolean _isEmpty = region.children.isEmpty();
        if (_isEmpty) {
            result.add(header);
        } else {
            result.add(header + " {");
            for (RegionHandle child : region.children) {
                this.render(child, idW, offsetW, lengthW, indent + 2, result);
            }
            String _repeat = Strings.repeat((String)" ", (int)loc.length());
            String _plus = id + ": " + _repeat;
            String _plus_1 = _plus + "}";
            result.add(_plus_1);
        }
    }

    protected String render() {
        File localFile = new File(null);
        LinkedHashMap remoteFiles = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        ArrayList roothandles = CollectionLiterals.newArrayList((Object[])new RegionHandle[0]);
        int maxid = this.collect(this.getTrace(), 1, localFile, remoteFiles, roothandles);
        int idwidth = Integer.toString(maxid, this.radix).length();
        List<String> _render = this.render(localFile, idwidth);
        Iterables.addAll((Collection)localFile.lines, _render);
        Collection _values = remoteFiles.values();
        for (File file : _values) {
            List<String> _render_1 = this.render(file, idwidth);
            Iterables.addAll((Collection)file.lines, _render_1);
        }
        Functions.Function1 _function = it -> it.length();
        Integer _max = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)localFile.lines, (Functions.Function1)_function));
        int _length = this.getLocalTitle().length();
        int _plus = _length + 2;
        int localWidth = Math.max(_max, _plus);
        Functions.Function1 _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> it_1.length();
            Integer _max_1 = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)((File)it).lines, (Functions.Function1)_function_2));
            int _length_1 = this.getRemoteTitle(((File)it).uri).length();
            int _plus_1 = _length_1 + 2;
            return Math.max(_max_1, _plus_1);
        };
        Integer remoteWidth = (Integer)IterableExtensions.max((Iterable)IterableExtensions.map(remoteFiles.values(), (Functions.Function1)_function_1));
        localFile.lines.add(0, this.title(null, localWidth));
        Collection _values_1 = remoteFiles.values();
        for (File file_1 : _values_1) {
            file_1.lines.add(0, this.title(file_1.uri, remoteWidth));
        }
        List left = localFile.lines;
        Functions.Function1 _function_2 = it -> ((File)it).lines;
        List right = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map(remoteFiles.values(), (Functions.Function1)_function_2)));
        ArrayList result = CollectionLiterals.newArrayList((Object[])new String[0]);
        if (this.showLegend) {
            result.add("Regions are surrounded by [N[ ... ]N]. Regions on the left and right with the same N are associated.");
        }
        for (int i = 0; i < ((Object[])Conversions.unwrapArray((Object)left, Object.class)).length || i < ((Object[])Conversions.unwrapArray((Object)right, Object.class)).length; ++i) {
            String _xifexpression = null;
            int _size = left.size();
            boolean _lessThan = i < _size;
            _xifexpression = _lessThan ? (String)left.get(i) : "";
            String l = Strings.padEnd((String)_xifexpression, (int)localWidth, (char)' ');
            String _xifexpression_1 = null;
            int _size_1 = right.size();
            boolean _lessThan_1 = i < _size_1;
            _xifexpression_1 = _lessThan_1 ? (String)right.get(i) : "";
            String r = _xifexpression_1;
            result.add(l + " | " + r);
        }
        if (this.showTree) {
            String _repeat = Strings.repeat((String)"-", (int)(localWidth + remoteWidth + 3));
            result.add(_repeat);
            if (this.showLegend) {
                result.add("<N>: <isDebug> <offset>-<length> <RegionJavaClass> -> <LocationJavaClass>[<offset>,<length>,<uri>]");
            }
            Functions.Function1 _function_3 = it -> {
                Functions.Function1 _function_4 = it_1 -> ((RegionHandle)it_1).children;
                return this.collect(it, _function_4);
            };
            Iterable allhandles = Iterables.concat((Iterable)ListExtensions.map((List)roothandles, (Functions.Function1)_function_3));
            Functions.Function1 _function_4 = it -> ((RegionHandle)it).region.getMyOffset();
            int offsetWidth = String.valueOf(IterableExtensions.max((Iterable)IterableExtensions.map((Iterable)allhandles, (Functions.Function1)_function_4))).length();
            Functions.Function1 _function_5 = it -> ((RegionHandle)it).region.getMyLength();
            int lengthWidth = String.valueOf(IterableExtensions.max((Iterable)IterableExtensions.map((Iterable)allhandles, (Functions.Function1)_function_5))).length();
            for (RegionHandle handle : roothandles) {
                this.render(handle, idwidth, offsetWidth, lengthWidth, 1, result);
            }
        }
        return IterableExtensions.join((Iterable)result, (CharSequence)org.eclipse.xtext.util.Strings.newLine());
    }

    public String toString() {
        String _xtrycatchfinallyexpression = null;
        try {
            return this.render();
        }
        catch (Throwable _t) {
            if (!(_t instanceof Exception)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Exception e = (Exception)_t;
            _xtrycatchfinallyexpression = Throwables.getStackTraceAsString((Throwable)e);
            return _xtrycatchfinallyexpression;
        }
    }

    @Pure
    public int getRadix() {
        return this.radix;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }

    @Pure
    public boolean isShowTree() {
        return this.showTree;
    }

    public void setShowTree(boolean showTree) {
        this.showTree = showTree;
    }

    @Pure
    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    @Accessors
    protected static class LocationHandle {
        private final RegionHandle region;
        private final int id;
        private final ILocationData location;

        public LocationHandle(RegionHandle region, int id, ILocationData location) {
            this.region = region;
            this.id = id;
            this.location = location;
        }

        @Pure
        public RegionHandle getRegion() {
            return this.region;
        }

        @Pure
        public int getId() {
            return this.id;
        }

        @Pure
        public ILocationData getLocation() {
            return this.location;
        }
    }

    @Accessors
    protected static class RegionHandle {
        private final int id;
        private final AbstractTraceRegion region;
        private final List<LocationHandle> locations = CollectionLiterals.newArrayList((Object[])new LocationHandle[0]);
        private final List<RegionHandle> children = CollectionLiterals.newArrayList((Object[])new RegionHandle[0]);

        public RegionHandle(int id, AbstractTraceRegion region) {
            this.id = id;
            this.region = region;
        }

        @Pure
        public int getId() {
            return this.id;
        }

        @Pure
        public AbstractTraceRegion getRegion() {
            return this.region;
        }

        @Pure
        public List<LocationHandle> getLocations() {
            return this.locations;
        }

        @Pure
        public List<RegionHandle> getChildren() {
            return this.children;
        }
    }

    @Accessors
    protected static class File {
        private final SourceRelativeURI uri;
        private final List<Insert> inserts = CollectionLiterals.newArrayList((Object[])new Insert[0]);
        private final List<String> lines = CollectionLiterals.newArrayList((Object[])new String[0]);

        public File(SourceRelativeURI uri) {
            this.uri = uri;
        }

        @Pure
        public SourceRelativeURI getUri() {
            return this.uri;
        }

        @Pure
        public List<Insert> getInserts() {
            return this.inserts;
        }

        @Pure
        public List<String> getLines() {
            return this.lines;
        }
    }

    @Accessors
    protected static class Insert {
        private final int offset;
        private final boolean open;
        private final RegionHandle region;
        private final LocationHandle location;

        public Insert(int offset, boolean open, RegionHandle region, LocationHandle location) {
            this.offset = offset;
            this.open = open;
            this.region = region;
            this.location = location;
        }

        @Pure
        public int getOffset() {
            return this.offset;
        }

        @Pure
        public boolean isOpen() {
            return this.open;
        }

        @Pure
        public RegionHandle getRegion() {
            return this.region;
        }

        @Pure
        public LocationHandle getLocation() {
            return this.location;
        }
    }
}

