/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.ui;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xtext.junit4.ui.AbstractEditorTest;
import org.eclipse.xtext.junit4.ui.util.IResourcesSetupUtil;
import org.eclipse.xtext.junit4.ui.util.JavaProjectSetupUtil;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;

@Deprecated(forRemoval=true)
public abstract class AbstractOutlineTest
extends AbstractEditorTest {
    protected static int TAB_INDENT = 2;
    protected static String TEST_PROJECT = "test";
    protected IFile file;
    protected XtextEditor editor;
    protected IXtextDocument document;
    public String fileExtension;
    @Inject
    protected IOutlineTreeProvider treeProvider;

    @Inject
    public void setFileExtensionProvider(FileExtensionProvider extensionProvider) {
        this.fileExtension = extensionProvider.getPrimaryFileExtension();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createjavaProject(TEST_PROJECT);
    }

    protected IJavaProject createjavaProject(String projectName) throws CoreException {
        IJavaProject javaProject = JavaProjectSetupUtil.createJavaProject(projectName);
        IResourcesSetupUtil.addNature(javaProject.getProject(), "org.eclipse.xtext.ui.shared.xtextNature");
        return javaProject;
    }

    protected IOutlineNode getOutlineTree(CharSequence modelAsText) throws Exception {
        this.file = IResourcesSetupUtil.createFile(TEST_PROJECT + "/test." + this.fileExtension, modelAsText.toString());
        this.editor = this.openEditor(this.file);
        this.document = this.editor.getDocument();
        return this.treeProvider.createRoot(this.document);
    }

    protected void assertAllLabels(CharSequence modelAsText, CharSequence expected) throws Exception {
        this.assertAllLabels(this.getOutlineTree(modelAsText), expected);
    }

    protected void assertAllLabels(IOutlineNode rootNode, CharSequence expected) {
        AbstractOutlineTest.assertEquals((Object)expected.toString().trim(), (Object)this.outlineStringRepresentation(rootNode).trim());
    }

    protected String outlineStringRepresentation(IOutlineNode node) {
        StringBuffer buffer = new StringBuffer();
        this.outlineStringRepresentation(node, buffer, 0);
        return buffer.toString();
    }

    protected void outlineStringRepresentation(IOutlineNode node, StringBuffer buffer, int tabs) {
        if (this.getNodeText(node) != "<unnamed>") {
            this.addToStringRepresentation(node, buffer, tabs);
            tabs += TAB_INDENT;
        }
        for (IOutlineNode child : node.getChildren()) {
            this.addToStringRepresentation(child, buffer, tabs);
            if (!child.hasChildren()) continue;
            for (IOutlineNode child2 : child.getChildren()) {
                this.outlineStringRepresentation(child2, buffer, tabs + TAB_INDENT);
            }
        }
    }

    protected void addToStringRepresentation(IOutlineNode node, StringBuffer buffer, int tabs) {
        this.indent(buffer, tabs);
        buffer.append(this.getNodeText(node) + System.getProperty("line.separator"));
    }

    protected String getNodeText(IOutlineNode node) {
        return node.getText().toString();
    }

    protected void indent(StringBuffer buffer, int tabs) {
        int i = 0;
        while (i < tabs) {
            buffer.append(" ");
            ++i;
        }
    }
}

