/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.chm.CHM2XHTML;
import org.apache.tika.parser.chm.CHMDocumentInformation;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChmParser
extends AbstractParser {
    private static final long serialVersionUID = 5938777307516469802L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"chm"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        CHMDocumentInformation chmInfo = CHMDocumentInformation.load(stream);
        metadata.set("Content-Type", "chm");
        this.extractMetadata(chmInfo, metadata);
        CHM2XHTML.process(chmInfo, handler);
    }

    private void extractMetadata(CHMDocumentInformation chmInfo, Metadata metadata) throws TikaException, IOException {
        chmInfo.getCHMDocInformation(metadata);
    }
}

