/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.mappings;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.FieldAccessSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.ReplaceResultReferenceVisitor;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstClone;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public abstract class MethodMappingImplementor {
    int bindingDirection;
    protected AstGenerator synthGen;
    protected RoleModel _role;
    private MethodSignatureEnhancer methodSignatureEnhancer;

    public MethodMappingImplementor(RoleModel role) {
        this._role = role;
    }

    protected MethodMappingImplementor() {
    }

    MethodSignatureEnhancer getMethodSignatureEnhancer() {
        if (this.methodSignatureEnhancer == null) {
            this.methodSignatureEnhancer = MethodSignatureEnhancer.variants[this._role.getWeavingScheme().ordinal()];
        }
        return this.methodSignatureEnhancer;
    }

    Expression[] makeWrapperCallArguments(AbstractMethodMappingDeclaration methodMapping, MethodDeclaration wrapperMethodDeclaration, MethodSpec sourceMethodSpec, FieldAccessSpec baseFieldSpec, boolean hasResultArgument) {
        if (methodMapping.mappings != null) {
            methodMapping.traverse((ASTVisitor)new ReplaceResultReferenceVisitor(methodMapping), methodMapping.scope.classScope());
            if (methodMapping.isReplaceCallin()) {
                ((CallinMappingDeclaration)methodMapping).checkResultMapping();
            }
        }
        Argument[] wrapperMethodArguments = wrapperMethodDeclaration.arguments;
        Expression[] arguments = null;
        boolean hasArgError = false;
        TypeBinding[] implParameters = this.getImplementationParamters(methodMapping, wrapperMethodDeclaration);
        int implementationArgLen = implParameters.length;
        int expressionsOffset = 0;
        if (baseFieldSpec != null) {
            if (baseFieldSpec.implementationStrategy == MethodSpec.ImplementationStrategy.DYN_ACCESS) {
                if (!baseFieldSpec.isSetter()) {
                    implementationArgLen = 0;
                }
            } else if (this._role.getWeavingScheme() == CompilerOptions.WeavingScheme.OTRE && !((FieldAccessSpec)methodMapping.getBaseMethodSpecs()[0]).isStatic()) {
                expressionsOffset = 1;
                ReferenceBinding baseType = methodMapping.scope.enclosingSourceType().baseclass();
                arguments = new Expression[implementationArgLen + expressionsOffset];
                MethodSpec baseSpec = ((CalloutMappingDeclaration)methodMapping).baseMethodSpec;
                AstGenerator gen = new AstGenerator(baseSpec);
                arguments[0] = new CastExpression(gen.singleNameReference(IOTConstants._OT_BASE), gen.baseclassReference(baseType), baseType.isRole() ? 1 : 2);
            }
        }
        if (arguments == null) {
            arguments = new Expression[implementationArgLen];
        }
        if (wrapperMethodArguments != null && wrapperMethodDeclaration.binding.parameters != Binding.NO_PARAMETERS) {
            int idx = 0;
            while (idx < wrapperMethodArguments.length) {
                wrapperMethodArguments[idx].bind(wrapperMethodDeclaration.scope, wrapperMethodDeclaration.binding.parameters[idx], false);
                ++idx;
            }
        }
        int idx = 0;
        while (idx < implementationArgLen) {
            arguments[idx + expressionsOffset] = this.getArgument(methodMapping, wrapperMethodDeclaration, implParameters, idx, hasResultArgument, sourceMethodSpec);
            if (arguments[idx + expressionsOffset] == null) {
                hasArgError = true;
            }
            ++idx;
        }
        if (hasArgError) {
            wrapperMethodDeclaration.statements = new Statement[0];
            return null;
        }
        return arguments;
    }

    TypeBinding[] getImplementationParamters(AbstractMethodMappingDeclaration methodMapping, MethodDeclaration wrapperMethod) {
        return methodMapping.getImplementationMethodSpec().resolvedParameters();
    }

    TypeBinding substituteVariables(TypeBinding original, TypeVariableBinding[] variables) {
        if (original.isTypeVariable()) {
            int i = 0;
            while (i < variables.length) {
                if (CharOperation.equals(original.internalName(), variables[i].sourceName)) {
                    return variables[i];
                }
                ++i;
            }
        } else if (original.isParameterizedType()) {
            ParameterizedTypeBinding pt = (ParameterizedTypeBinding)original;
            TypeBinding[] args = pt.arguments;
            if (args != null) {
                int l = args.length;
                TypeBinding[] typeBindingArray = args;
                args = new TypeBinding[l];
                System.arraycopy(typeBindingArray, 0, args, 0, l);
                boolean changed = false;
                int i = 0;
                while (i < l) {
                    TypeBinding tb = this.substituteVariables(args[i], variables);
                    if (TypeBinding.notEquals(tb, args[i])) {
                        args[i] = tb;
                        changed = true;
                    }
                    ++i;
                }
                if (changed) {
                    return new ParameterizedTypeBinding((ReferenceBinding)pt.erasure(), args, pt.enclosingType(), pt.environment);
                }
            }
        }
        return original;
    }

    Expression getArgument(AbstractMethodMappingDeclaration methodMapping, MethodDeclaration wrapperDeclaration, TypeBinding[] implParameters, int idx, boolean hasResultArgument, MethodSpec sourceMethodSpec) {
        return null;
    }

    protected Argument[] copyArguments(AstGenerator gen, Scope scope, TypeBinding[] arguments, MethodSpec declaredMethodSpec) {
        if (arguments == null || arguments.length == 0) {
            return null;
        }
        ITeamAnchor baseSideAnchor = RoleTypeCreator.getPlayedByAnchor(scope);
        boolean useDeclaredArgs = declaredMethodSpec.arguments != null && declaredMethodSpec.arguments.length == arguments.length;
        Argument[] result = new Argument[arguments.length];
        int idx = 0;
        while (idx < arguments.length) {
            char[] argName;
            long pos = ((long)declaredMethodSpec.sourceStart << 32) + (long)declaredMethodSpec.sourceEnd;
            int argModifiers = 16;
            TypeReference argTypeReference = null;
            if (useDeclaredArgs) {
                Argument argument = declaredMethodSpec.arguments[idx];
                argName = argument.name;
                pos = ((long)argument.sourceStart << 32) + (long)argument.sourceEnd;
                argModifiers = argument.modifiers;
                if (this.bindingDirection == 77) {
                    argTypeReference = AstClone.copyTypeReference(argument.type);
                }
            } else {
                argName = ("_OT$arg" + idx).toCharArray();
            }
            TypeBinding argType = arguments[idx];
            if (this.bindingDirection == 78) {
                argTypeReference = this.getAnchoredTypeReference(gen, baseSideAnchor, argType);
            }
            if (argTypeReference == null) {
                argTypeReference = gen.typeReference(argType);
            }
            result[idx] = new Argument(argName, pos, argTypeReference, argModifiers);
            ++idx;
        }
        return result;
    }

    TypeReference getAnchoredTypeReference(AstGenerator gen, ITeamAnchor baseSideAnchor, TypeBinding type) {
        TypeReference argTypeReference = null;
        int dims = type.dimensions();
        if ((type = type.leafComponentType()) instanceof RoleTypeBinding) {
            ReferenceBinding baseSideTeam;
            RoleTypeBinding roleTypeArg = (RoleTypeBinding)type;
            if (roleTypeArg.hasExplicitAnchor()) {
                if (roleTypeArg._teamAnchor.isBaseAnchor()) {
                    TypeAnchorReference anchorRef = new TypeAnchorReference(gen.singleNameReference(IOTConstants.BASE), gen.sourceStart);
                    argTypeReference = new ParameterizedSingleTypeReference(roleTypeArg.internalName(), new TypeReference[]{anchorRef}, dims, gen.pos);
                }
            } else if (baseSideAnchor != null && TeamModel.isTeamContainingRole(baseSideTeam = (ReferenceBinding)baseSideAnchor.getResolvedType(), roleTypeArg)) {
                argTypeReference = gen.roleTypeReference(baseSideAnchor, roleTypeArg, dims);
            }
        }
        return argTypeReference;
    }

    Expression genSimpleArgExpr(char[] argName, MethodSpec targetMethodSpec) {
        AstGenerator gen = this.synthGen != null ? this.synthGen : new AstGenerator(targetMethodSpec.sourceStart, targetMethodSpec.sourceEnd);
        return gen.singleNameReference(argName);
    }

    protected TypeParameter[] getTypeParameters(boolean hasSignature, MethodBinding rrrBinding, MethodSpec roleMethodSpec, AstGenerator gen) {
        TypeParameter[] typeParams = null;
        if (hasSignature) {
            typeParams = roleMethodSpec.typeParameters;
            if (typeParams != null) {
                typeParams = AstClone.copyTypeParameters(typeParams);
            }
        } else {
            TypeVariableBinding[] typeVariables = rrrBinding.typeVariables;
            if (typeVariables != Binding.NO_TYPE_VARIABLES) {
                typeParams = new TypeParameter[typeVariables.length];
                int i = 0;
                while (i < typeVariables.length) {
                    typeParams[i] = gen.typeParameter(typeVariables[i]);
                    ++i;
                }
            }
        }
        return typeParams;
    }
}

