/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.License;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.oomph.setup.LicenseInfo;
import org.eclipse.oomph.setup.ui.AbstractConfirmDialog;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseDialog
extends AbstractConfirmDialog {
    private static final String LIST_WEIGHT = "ListSashWeight";
    private static final String LICENSE_WEIGHT = "LicenseSashWeight";
    private static final int PRIMARY_COLUMN_WIDTH = 60;
    private static final int COLUMN_WIDTH = 40;
    private static final int TABLE_HEIGHT = 10;
    private final Map<ILicense, List<IInstallableUnit>> licensesToIUs;
    private SashForm sashForm;
    private TreeViewer viewer;
    private Text licenseTextBox;

    public LicenseDialog(Map<ILicense, List<IInstallableUnit>> licensesToIUs) {
        super("Licenses", 1000, 600, "Remember accepted licenses");
        this.licensesToIUs = licensesToIUs;
    }

    @Override
    protected String getShellText() {
        return "Oomph License Confirmation";
    }

    protected String getDefaultMessage() {
        return "Review and accept licenses before the software can be installed.";
    }

    protected void createUI(Composite parent) {
        Composite control;
        List<IInstallableUnit> ius;
        this.initializeDialogUnits((Control)parent);
        if (this.licensesToIUs.size() == 1 && (ius = this.licensesToIUs.values().iterator().next()).size() == 1) {
            control = this.createLicenseContentSection(parent, ius.get(0));
        } else {
            this.sashForm = new SashForm(parent, 65792);
            this.sashForm.setLayout((Layout)new GridLayout());
            GridData gd = new GridData(1808);
            this.sashForm.setLayoutData((Object)gd);
            this.createLicenseListSection((Composite)this.sashForm);
            this.createLicenseContentSection((Composite)this.sashForm, null);
            this.sashForm.setWeights(this.getSashWeights());
            control = this.sashForm;
        }
        Dialog.applyDialogFont((Control)control);
    }

    private void createLicenseListSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.viewer = new TreeViewer(composite, 66304);
        this.viewer.setContentProvider((IContentProvider)new LicenseContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LicenseLabelProvider());
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setInput(this.licensesToIUs);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LicenseDialog.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        this.viewer.getControl().setLayoutData((Object)gd);
    }

    private Composite createLicenseContentSection(Composite parent, IInstallableUnit singleIU) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.licenseTextBox = new Text(composite, 586);
        this.licenseTextBox.setBackground(this.licenseTextBox.getDisplay().getSystemColor(25));
        this.initializeDialogUnits((Control)this.licenseTextBox);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        this.licenseTextBox.setLayoutData((Object)gd);
        if (singleIU != null) {
            ILicense license;
            String licenseBody = "";
            Iterator licenses = singleIU.getLicenses(null).iterator();
            ILicense iLicense = license = licenses.hasNext() ? (ILicense)licenses.next() : null;
            if (license != null && license.getBody() != null) {
                licenseBody = license.getBody();
            }
            this.licenseTextBox.setText(licenseBody);
        }
        return composite;
    }

    private void handleSelectionChanged(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            Object selected = selection.getFirstElement();
            if (selected instanceof License) {
                this.licenseTextBox.setText(((License)selected).getBody());
            } else if (selected instanceof IUWithLicenseParent) {
                this.licenseTextBox.setText(((IUWithLicenseParent)selected).license.getBody());
            }
        }
    }

    private int[] getSashWeights() {
        try {
            int[] weights = new int[2];
            IDialogSettings settings = this.getDialogSettings();
            if (settings.get(LIST_WEIGHT) != null) {
                weights[0] = settings.getInt(LIST_WEIGHT);
                if (settings.get(LICENSE_WEIGHT) != null) {
                    weights[1] = settings.getInt(LICENSE_WEIGHT);
                    return weights;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return new int[]{50, 50};
    }

    private static String getIUName(IInstallableUnit iu) {
        StringBuffer buf = new StringBuffer();
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (name != null) {
            buf.append(name);
        } else {
            buf.append(iu.getId());
        }
        buf.append(" ");
        buf.append(iu.getVersion().toString());
        return buf.toString();
    }

    private final class IUWithLicenseParent {
        public final IInstallableUnit iu;
        public final ILicense license;

        public IUWithLicenseParent(ILicense license, IInstallableUnit iu) {
            this.license = license;
            this.iu = iu;
        }
    }

    private final class LicenseContentProvider
    implements ITreeContentProvider {
        private LicenseContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ILicense && LicenseDialog.this.licensesToIUs.containsKey(element)) {
                List iusWithLicense = (List)LicenseDialog.this.licensesToIUs.get(element);
                IInstallableUnit[] ius = iusWithLicense.toArray(new IInstallableUnit[iusWithLicense.size()]);
                Object[] children = new IUWithLicenseParent[ius.length];
                int i = 0;
                while (i < ius.length) {
                    children[i] = new IUWithLicenseParent((ILicense)element, ius[i]);
                    ++i;
                }
                return children;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IUWithLicenseParent) {
                return ((IUWithLicenseParent)element).license;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return LicenseDialog.this.licensesToIUs.containsKey(element);
        }

        public Object[] getElements(Object inputElement) {
            return LicenseDialog.this.licensesToIUs.keySet().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class LicenseLabelProvider
    extends LabelProvider {
        private LicenseLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof License) {
                return SetupUIPlugin.INSTANCE.getSWTImage("license");
            }
            if (element instanceof IUWithLicenseParent || element instanceof IInstallableUnit) {
                return SetupUIPlugin.INSTANCE.getSWTImage("feature");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof License) {
                return LicenseInfo.getFirstLine((String)((License)element).getBody());
            }
            if (element instanceof IUWithLicenseParent) {
                return LicenseDialog.getIUName(((IUWithLicenseParent)element).iu);
            }
            if (element instanceof IInstallableUnit) {
                return LicenseDialog.getIUName((IInstallableUnit)element);
            }
            return "";
        }
    }
}

