/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileCreator;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.p2.internal.core.AgentManagerElementImpl;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.ProfileCreatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlePoolImpl
extends AgentManagerElementImpl
implements BundlePool {
    private final Agent agent;
    private File location;
    private String path;
    private IFileArtifactRepository fileArtifactRepository;

    public BundlePoolImpl(AgentImpl agent, File location) {
        this.agent = agent;
        this.setLocation(location);
    }

    @Override
    public String getElementType() {
        return "bundle pool";
    }

    @Override
    public AgentManager getAgentManager() {
        return this.agent.getAgentManager();
    }

    @Override
    public Agent getAgent() {
        return this.agent;
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    public void setLocation(File location) {
        this.location = location;
        this.path = location.getAbsolutePath();
    }

    @Override
    public Set<String> getClients() {
        return ((AgentManagerImpl)this.agent.getAgentManager()).getClientsFor(this.path);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isCurrent() {
        if (!this.agent.isCurrent()) {
            return false;
        }
        Profile currentProfile = this.agent.getCurrentProfile();
        return currentProfile != null && currentProfile.getBundlePool() == this;
    }

    @Override
    public boolean isUsed() {
        return !this.getProfiles().isEmpty();
    }

    @Override
    protected void doDelete() {
        ((AgentImpl)this.agent).deleteBundlePool(this);
    }

    @Override
    public synchronized IFileArtifactRepository getFileArtifactRepository() {
        if (this.fileArtifactRepository == null) {
            IArtifactRepositoryManager artifactRepositoryManager = this.agent.getArtifactRepositoryManager();
            URI uri = this.location.toURI();
            try {
                if (artifactRepositoryManager.contains(uri)) {
                    this.fileArtifactRepository = (IFileArtifactRepository)artifactRepositoryManager.loadRepository(uri, null);
                }
            }
            catch (CoreException coreException) {}
            if (this.fileArtifactRepository == null) {
                try {
                    this.fileArtifactRepository = (IFileArtifactRepository)artifactRepositoryManager.createRepository(uri, "Shared Bundle Pool", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
                }
                catch (ProvisionException provisionException) {
                    throw new P2Exception("Bundle pool " + this.location + " could not be loaded");
                }
            }
        }
        return this.fileArtifactRepository;
    }

    @Override
    public Set<String> getProfileIDs() {
        return ((AgentImpl)this.agent).getProfileIDs(this);
    }

    @Override
    public Collection<Profile> getProfiles() {
        return ((AgentImpl)this.agent).getProfiles(this);
    }

    @Override
    public Profile getProfile(String id) {
        Profile profile = this.agent.getProfile(id);
        if (profile != null && profile.getBundlePool() == this) {
            return profile;
        }
        return null;
    }

    @Override
    public ProfileCreator addProfile(String id, String type) {
        return new ProfileCreatorImpl(this, id, type){
            private static final long serialVersionUID = 1L;

            public ProfileCreator setCacheFolder(File value) {
                if (!BundlePoolImpl.this.location.equals(value)) {
                    throw new IllegalArgumentException("Cache folder of a pooled profile cannot be changed: " + value);
                }
                return this;
            }

            protected Profile doCreateProfile() {
                this.set("org.eclipse.equinox.p2.cache", BundlePoolImpl.this.path);
                return ((AgentImpl)BundlePoolImpl.this.agent).createProfile(this);
            }
        };
    }

    public String toString() {
        return this.getLocation().getAbsolutePath();
    }
}

